/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr;

import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import lotus.domino.Database;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.DocumentCollection;
import lotus.domino.EmbeddedObject;
import lotus.domino.Item;
import lotus.domino.MIMEEntity;
import lotus.domino.NotesException;
import lotus.domino.NotesFactory;
import lotus.domino.NotesThread;
import lotus.domino.Session;
import lotus.domino.ViewEntry;
import lotus.domino.ViewEntryCollection;
import net.gopro.gdr.IO;
import net.gopro.gdr.Reader;
import net.gopro.util.domino.GoProCaseDocumentFormatter;
import org.jdom.Attribute;
import org.jdom.Element;

public class DominoHelper {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/gopro/gdr/DominoHelper.java 2     20.09.05 9:38 Kbg $";
    IO io;
    Session session;
    String sessionType = "iiop";
    boolean bInit = false;

    public String getSessionType() {
        return this.sessionType;
    }

    public String getServer() {
        return this.io.getParameters().getString("server");
    }

    public String getDB() {
        return this.io.getParameters().getString("database");
    }

    public Session getSession() {
        return this.session;
    }

    public DominoHelper(IO io, String sessionType) {
        this.io = io;
        this.sessionType = sessionType;
    }

    public void initThread() {
        if (!this.sessionType.equals("iiop")) {
            NotesThread.sinitThread();
        }
    }

    public void termThread() {
        if (!this.sessionType.equals("iiop")) {
            NotesThread.stermThread();
        }
    }

    public boolean checkConnection() {
        if (this.sessionType.equals("iiop")) {
            try {
                this.session.getDatabase(this.session.getServerName(), this.getDB());
                this.io.getRouter().getLog().debug("Session still active");
            }
            catch (Exception e) {
                this.io.getRouter().getLog().debug(this.io.getType() + "." + this.io.getName() + " reconnecting session");
                this.init();
            }
        }
        return this.bInit;
    }

    public void init() {
        try {
            String sUser = this.io.getParameters().getString("user");
            String sPassword = this.io.getParameters().getString("password");
            this.io.getRouter().getLog().debug("User: " + sUser);
            this.io.getRouter().getLog().debug("Password: " + sPassword);
            this.io.getRouter().getLog().debug("Sessiontype: " + this.sessionType);
            this.io.getRouter().getLog().debug("Server: " + this.getServer());
            if (this.sessionType.equals("server")) {
                this.session = NotesFactory.createSession();
            } else {
                if ("".equals(sUser)) {
                    this.io.setError("missing parameter", "'user' is requried for 'local' and 'iiop' sessions'");
                    return;
                }
                if ("".equals(sPassword)) {
                    this.io.setError("missing parameter", "'password' is requried for 'local' and 'iiop' sessions'");
                    return;
                }
                if (this.sessionType.equals("local")) {
                    this.session = NotesFactory.createSession((String)null, (String)sUser, (String)sPassword);
                } else {
                    this.sessionType = "iiop";
                    String s = this.getServer();
                    if ("".equals(s)) {
                        this.io.setError("missing parameter", "'server' is requried for 'iiop' sessions'");
                        return;
                    }
                    this.session = NotesFactory.createSession((String)this.getServer(), (String)sUser, (String)sPassword);
                }
            }
            if (this.session == null) {
                this.io.getRouter().getLog().error("DominoHelper:<init> session = NULL ");
            } else {
                this.session.setConvertMime(false);
                String msg = "Created " + this.sessionType + " session for " + this.session.getUserName() + " on " + this.session.getServerName() + " which is Domino " + this.session.getPlatform() + " " + (this.session.isOnServer() ? "server " : "client ") + this.session.getNotesVersion();
                this.io.getParameters().put("session info", msg);
                this.io.getRouter().getLog().debug(msg);
                this.bInit = true;
            }
        }
        catch (Exception ne) {
            if (ne instanceof NotesException) {
                this.io.setError("creating session", ((NotesException)((Object)ne)).text);
            } else {
                this.io.setError("creating session", ne);
            }
            this.io.getRouter().getLog().error(this.io.getType() + "." + this.io.getName() + ": Unable to create a session", ne);
            this.bInit = false;
        }
    }

    public void term() {
    }

    public Database getDatabase() {
        try {
            Database db;
            if (this.session == null) {
                this.io.getRouter().getLog().error(this.io.getType() + "." + this.io.getName() + ": I need session");
                return null;
            }
            String server = this.session.getServerName();
            if (this.sessionType.equals("server")) {
                server = this.getServer();
            }
            if (!(db = this.session.getDatabase(server, this.getDB())).isOpen()) {
                db.open();
            }
            return db;
        }
        catch (NotesException ne) {
            this.io.setError("getting datbase", ne.text);
            this.io.getRouter().getLog().error((Exception)((Object)ne));
            return null;
        }
        catch (Exception e) {
            this.io.setError("getting datbase", e);
            this.io.getRouter().getLog().error(e);
            return null;
        }
    }

    public org.jdom.Document makeJDOMDocument(Reader r, Document ddoc, boolean bAttachments, String fields) {
        org.jdom.Document retdoc = DominoHelper.makeJDOMDocument(r, ddoc, fields);
        try {
            String outputDirAttachments;
            Vector vAttachments;
            if (bAttachments && (vAttachments = this.dumpAttachments(ddoc, outputDirAttachments = r.getRouter().getWebRoot() + "tmp")) != null && vAttachments.size() > 0) {
                Element root = retdoc.getRootElement();
                Element fa = new Element("fileattachments");
                root.addContent(fa);
                GoProCaseDocumentFormatter df = new GoProCaseDocumentFormatter();
                String fileNameReal = "";
                for (int i = 0; i < vAttachments.size(); ++i) {
                    Element file = new Element("fileattachment");
                    fa.addContent(file);
                    Vector vAttachmentInfo = (Vector)vAttachments.elementAt(i);
                    String filename = (String)vAttachmentInfo.elementAt(0);
                    String filesize = (String)vAttachmentInfo.elementAt(1);
                    String filetype = (String)vAttachmentInfo.elementAt(2);
                    fileNameReal = df.getXMLBaseName(ddoc) + "." + filename;
                    file.addContent(fileNameReal);
                    file.setAttribute("name", filename);
                    file.setAttribute("size", filesize);
                    file.setAttribute("type", filetype);
                }
            }
        }
        catch (NotesException ne) {
            r.setError("creating xml document", ne.text);
            this.io.getRouter().getLog().error((Exception)((Object)ne));
        }
        catch (Exception e) {
            r.setError("creating xml document", e);
            this.io.getRouter().getLog().error(e);
        }
        return retdoc;
    }

    public static org.jdom.Document makeJDOMDocument(Reader r, Document ddoc) {
        return DominoHelper.makeJDOMDocument(r, ddoc, null);
    }

    public static org.jdom.Document makeJDOMDocument(Reader r, Document ddoc, String fields) {
        org.jdom.Document retdoc = IO.makeXMLDocument(r);
        try {
            Database db;
            Vector<Item> items;
            Hashtable<String, String> alias = new Hashtable<String, String>();
            if (fields != null && fields.length() > 0) {
                items = new Vector<Item>();
                StringTokenizer e = new StringTokenizer(fields, ",");
                while (e.hasMoreElements()) {
                    String name = ((String)e.nextElement()).toLowerCase().trim();
                    int pos = name.indexOf(32);
                    if (pos > -1) {
                        String al = name.substring(pos).trim();
                        name = name.substring(0, pos).trim();
                        alias.put(name, al);
                    }
                    items.addElement(ddoc.getFirstItem(name));
                }
            } else {
                items = ddoc.getItems();
            }
            String sServer = (db = ddoc.getParentDatabase()).getServer().length() == 0 ? "" : db.getServer();
            Element doc = retdoc.getRootElement();
            String strURI = r.getRouter().getWebURI();
            doc.setAttribute("uri", strURI);
            doc.setAttribute("webroot", "http://" + strURI.substring(0, strURI.lastIndexOf("/")));
            doc.addContent(new Element("server").addContent(sServer));
            doc.addContent(new Element("database").addContent(db.getFilePath()));
            doc.addContent(new Element("form").addContent(ddoc.getItemValueString("form")));
            doc.addContent(new Element("noteid").addContent(ddoc.getNoteID()));
            doc.addContent(new Element("unid").addContent(ddoc.getUniversalID()));
            if (!ddoc.getParentDocumentUNID().equals("")) {
                doc.addContent(new Element("parentunid").addContent(ddoc.getParentDocumentUNID()));
            }
            DateTime dt = ddoc.getCreated();
            doc.addContent(new Element("created").addContent(dt.getGMTTime()));
            dt = ddoc.getLastModified();
            doc.addContent(new Element("modified").addContent(dt.getGMTTime()));
            dt = ddoc.getLastAccessed();
            doc.addContent(new Element("accessed").addContent(dt.getGMTTime()));
            dt.setNow();
            doc.addContent(new Element("thisread").addContent(dt.getGMTTime()));
            doc.addContent(new Element("isresponse").addContent(ddoc.isResponse() ? "yes" : "no"));
            Element eitems = new Element("items");
            for (int j = 0; j < items.size(); ++j) {
                String sType = null;
                Item item = (Item)items.elementAt(j);
                switch (item.getType()) {
                    case 1076: {
                        sType = "AUTHOR";
                        break;
                    }
                    case 1024: {
                        sType = "DATETIME";
                        break;
                    }
                    case 1074: {
                        sType = "NAME";
                        break;
                    }
                    case 768: {
                        sType = "NUMBER";
                        break;
                    }
                    case 1: {
                        sType = "RICHTEXT";
                        break;
                    }
                    case 1075: {
                        sType = "READER";
                        break;
                    }
                    case 1280: {
                        sType = "TEXT";
                        break;
                    }
                    case 25: {
                        sType = "MIME";
                    }
                }
                String sName = item.getName().toLowerCase();
                if (sType == null || sName.equals("form")) continue;
                String al = (String)alias.get(sName);
                if (al != null) {
                    sName = al;
                }
                if (sName.indexOf(36) > -1) {
                    sName = DominoHelper.dollarEncode(sName);
                }
                Element eitem = new Element("item");
                eitem.setAttribute("name", sName);
                if (item.getType() == 25) {
                    MIMEEntity m = item.getMIMEEntity();
                    eitem.setAttribute("type", sType);
                    eitem.addContent(m.getContentAsText());
                } else {
                    Vector vValues = item.getValues();
                    if (vValues != null && vValues.size() > 1) {
                        eitem.setAttribute("type", sType + "LIST");
                        for (int i = 0; i < vValues.size(); ++i) {
                            Element listitem = new Element(sType);
                            listitem.addContent(vValues.elementAt(i).toString());
                            eitem.addContent(listitem);
                        }
                    } else {
                        eitem.setAttribute("type", sType);
                        String sValue = "";
                        if (vValues == null || vValues.size() != 1) continue;
                        sValue = vValues.elementAt(0).toString();
                        eitem.addContent(sValue);
                    }
                }
                eitems.addContent(eitem);
            }
            doc.addContent(eitems);
        }
        catch (NotesException ne) {
            r.setError("creating xml document", ne.text);
            r.getRouter().getLog().error((Exception)((Object)ne));
        }
        catch (Exception e) {
            r.setError("creating xml document", e);
            r.getRouter().getLog().error(e);
        }
        return retdoc;
    }

    public static org.jdom.Document makeJDOMDocument(Reader r, DocumentCollection coll, int startAt, int maxReturn, String fields) {
        org.jdom.Document retdoc = IO.makeXMLDocument(r);
        Element root = new Element("documents");
        Element e1 = null;
        try {
            Document ddoc = coll.getNthDocument(startAt);
            for (int idx = 0; ddoc != null && idx < maxReturn; ++idx) {
                e1 = DominoHelper.makeJDOMDocument(r, ddoc, fields).getRootElement();
                root.addContent(e1);
                ddoc = coll.getNextDocument(ddoc);
            }
            retdoc.setRootElement(root);
        }
        catch (NotesException ne) {
            r.setError("creating xml document", ne.text);
            r.getRouter().getLog().error((Exception)((Object)ne));
        }
        catch (Exception e) {
            r.setError("creating xml document", e);
            r.getRouter().getLog().error(e);
        }
        return retdoc;
    }

    public static org.jdom.Document makeJDOMDocument(Reader r, ViewEntryCollection coll, int startAt, int maxReturn, String fields) {
        org.jdom.Document retdoc = IO.makeXMLDocument(r);
        Element root = new Element("documents");
        Element e1 = null;
        try {
            ViewEntry entry = coll.getNthEntry(startAt);
            for (int idx = 0; entry != null && idx < maxReturn; ++idx) {
                Document ddoc = entry.getDocument();
                e1 = DominoHelper.makeJDOMDocument(r, ddoc, fields).getRootElement();
                root.addContent(e1);
                entry = coll.getNextEntry();
            }
            retdoc.setRootElement(root);
        }
        catch (NotesException ne) {
            r.setError("creating xml document", ne.text);
            r.getRouter().getLog().error((Exception)((Object)ne));
        }
        catch (Exception e) {
            r.setError("creating xml document", e);
            r.getRouter().getLog().error(e);
        }
        return retdoc;
    }

    public static void updateFromJDOMDocument(Document ddoc, org.jdom.Document doc) {
        try {
            Element items = doc.getRootElement().getChild("items");
            if (items == null) {
                throw new Exception("Malformed document to DominoWriter, no items");
            }
            List l = items.getChildren();
            Iterator i = l.iterator();
            Session session = ddoc.getParentDatabase().getParent();
            while (i.hasNext()) {
                Element e = (Element)i.next();
                Attribute aType = e.getAttribute("type");
                String type = null;
                if (aType != null) {
                    type = aType.getValue();
                }
                if (type == null || "".equals(type)) {
                    type = "TEXT";
                }
                String name = null;
                Attribute aName = e.getAttribute("name");
                if (aName == null || aName.getValue() == null || "".equals(aName.getValue()) || (name = aName.getValue()).startsWith("__dollar__") || type.equals("RICHTEXT") || type.equals("MIME")) continue;
                Vector v = new Vector();
                if (type.endsWith("LIST")) {
                    for (Element ie : e.getChildren()) {
                        DominoHelper.addValueToVector(type, v, ie, session);
                    }
                } else {
                    DominoHelper.addValueToVector(type, v, e, session);
                }
                if (v.size() > 1) {
                    ddoc.replaceItemValue(name, v);
                    continue;
                }
                if (v.size() != 1) continue;
                ddoc.replaceItemValue(name, v.elementAt(0));
            }
        }
        catch (NotesException ne) {
            ne.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void addValueToVector(String type, Vector v, Element ie, Session session) throws NotesException {
        if (type.startsWith("DATETIME")) {
            v.addElement(session.createDateTime(ie.getText()));
        } else if (type.startsWith("NUMBER")) {
            v.addElement(new Double(ie.getText()));
        } else {
            v.addElement(ie.getText());
        }
    }

    static String dollarEncode(String s) {
        String ret = "";
        for (int i = 0; i < s.length(); ++i) {
            ret = s.charAt(i) == '$' ? ret + "__dollar__" : ret + s.charAt(i);
        }
        return ret;
    }

    public org.jdom.Document makeJDOMDocumentWithResponses(Reader r, Document ddoc, boolean bAttachments, String fields) {
        this.io.getRouter().getLog().debug("makeJDOMDocumentWithResponses");
        org.jdom.Document doc = this.makeJDOMDocument(r, ddoc, bAttachments, fields);
        try {
            try {
                String strUNID = ddoc.getUniversalID();
                String strServer = this.getDatabase().getServer();
                String strDb = this.getDatabase().getFilePath();
                Database db = this.session.getDatabase(strServer, strDb);
            }
            catch (Exception e) {
                // empty catch block
            }
            Element e = doc.getRootElement();
            DocumentCollection dc = ddoc.getResponses();
            Document rdoc = dc.getFirstDocument();
            Element children = new Element("children");
            if (rdoc != null) {
                e.addContent(children);
            }
            while (rdoc != null) {
                children.addContent(this.dumpRecursive(r, rdoc, 0, bAttachments));
                rdoc = dc.getNextDocument(rdoc);
            }
            return doc;
        }
        catch (Exception e) {
            r.setError("creating xml document", e);
            this.io.getRouter().getLog().error(e);
            return null;
        }
    }

    private Element dumpRecursive(Reader r, Document doc, int level, boolean bAttachments) {
        try {
            Element e = this.makeJDOMDocument(r, doc, true, null).getRootElement();
            DocumentCollection dc = doc.getResponses();
            Document rdoc = dc.getFirstDocument();
            Element children = new Element("children");
            if (rdoc != null) {
                e.addContent(children);
            }
            while (rdoc != null) {
                children.addContent(this.dumpRecursive(r, rdoc, level + 1, bAttachments));
                rdoc = dc.getNextDocument(rdoc);
            }
            return e;
        }
        catch (Exception e) {
            r.setError("creating xml document", e);
            this.io.getRouter().getLog().error(e);
            return null;
        }
    }

    public Vector dumpAttachments(Document ddoc, String path) throws Exception {
        Vector vReturn = null;
        if (ddoc.hasEmbedded()) {
            int i;
            if (path == null || "".equals(path)) {
                this.io.getRouter().getLog().debug("Skipping attachments because of missing attachment path");
                return null;
            }
            if (ddoc.hasItem("$FILE")) {
                vReturn = new Vector();
                Vector vItems = ddoc.getItems();
                for (i = 0; i < vItems.size(); ++i) {
                    int tmp;
                    Item item = (Item)vItems.elementAt(i);
                    if (item.getType() != 1084) continue;
                    String filename = item.getValueString();
                    EmbeddedObject eo = ddoc.getAttachment(filename);
                    Vector<String> vEOInfo = new Vector<String>();
                    String eoname = eo.getSource();
                    vEOInfo.addElement(eoname);
                    vEOInfo.addElement(Integer.toString(eo.getFileSize()));
                    int dot = eoname.indexOf(46);
                    while (dot > -1 && (tmp = eoname.indexOf(46, dot + 1)) != -1) {
                        dot = tmp;
                    }
                    String postfix = "";
                    if (dot > -1) {
                        postfix = eoname.substring(dot + 1);
                    }
                    vEOInfo.addElement(postfix);
                    this.handleAttachment(ddoc, eo, path);
                    vReturn.addElement(vEOInfo);
                }
            }
            Vector vEO = ddoc.getEmbeddedObjects();
            for (i = 0; i < vEO.size(); ++i) {
                EmbeddedObject eo = (EmbeddedObject)vEO.elementAt(i);
                if (eo.getType() == 1454) continue;
                this.handleObject(ddoc, (EmbeddedObject)vEO.elementAt(i), path);
            }
        }
        return vReturn;
    }

    private void handleAttachment(Document ddoc, EmbeddedObject eo, String path) {
        String filename = "";
        try {
            GoProCaseDocumentFormatter df = new GoProCaseDocumentFormatter();
            filename = path + File.separator + df.getXMLBaseName(ddoc) + "." + eo.getSource();
            this.io.getRouter().getLog().debug("Attachment, " + eo.getFileSize() + " bytes, " + filename);
            eo.extractFile(filename);
        }
        catch (Exception e) {
            String msg = "Problem saving attachments '" + filename + "'.  I will try to continue anyway";
            this.io.getRouter().getLog().warn(msg, e);
        }
    }

    private void handleObject(Document ddoc, EmbeddedObject eo, String filename) throws Exception {
        try {
            GoProCaseDocumentFormatter df = new GoProCaseDocumentFormatter();
            this.io.getRouter().getLog().warn("document '" + df.getSubject(ddoc) + "' has an object which will not be dumped: '" + eo.getName() + "'");
        }
        catch (Exception e) {
            String msg = "Problem saving attachments '" + filename + "'.  I will try to continue anyway";
            this.io.getRouter().getLog().warn(msg, e);
        }
    }
}

