/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import net.gopro.gdr.IO;
import net.gopro.gdr.Router;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;

public class Documents {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/NET/gopro/gdr/Documents.java 1     23.06.03 15:18 Kbg $";
    static SimpleDateFormat df = new SimpleDateFormat("yyMMddhhmmssSSS");
    static volatile LinkedList<Document> ll;
    long documentsProcessed;
    Router servex;

    String docInfo(Document d) {
        String s = d.getRootElement().getAttributeValue("description");
        if (s == null) {
            return new String("document with no description");
        }
        return s;
    }

    Documents(Router servex) {
        this.servex = servex;
        ll = new LinkedList();
        this.documentsProcessed = 0L;
    }

    long getDocumentsProcessed() {
        return this.documentsProcessed;
    }

    public synchronized void put(Document d) {
        this.servex.getLog().debug("Document '" + this.docInfo(d) + "' received");
        ll.addFirst(d);
        ++this.documentsProcessed;
    }

    public synchronized Document get() {
        if (ll.size() > 0) {
            Document d = ll.removeLast();
            this.servex.getLog().debug("Document '" + this.docInfo(d) + "' removed");
            return d;
        }
        return null;
    }

    public boolean isEmpty() {
        return ll.size() == 0;
    }

    public int size() {
        return ll.size();
    }

    public static String dump(IO io, Document doc) {
        return Documents.dump(io.getRouter(), io.getType(), io.getName(), doc);
    }

    public static String dump(Router rtr, String iotype, String ioname, Document doc) {
        String name = null;
        String dir = rtr.getDebugDir();
        String lastpart = "-" + iotype + "-" + ioname + ".xml";
        try {
            String datepart = df.format(new Date());
            name = dir + File.separatorChar + datepart + lastpart;
            XMLOutputter putter = IO.makeXMLOutputter(rtr.getParameters());
            putter.output(doc, (OutputStream)new FileOutputStream(name));
        }
        catch (Exception e) {
            rtr.getLog().error(e);
        }
        return name;
    }
}

