/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.gopro.gdr.CMDLineParser;

class CMDLineParserThread
extends Thread {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/NET/gopro/gdr/CMDLineParserThread.java 1     23.06.03 15:18 Kbg $";
    volatile boolean thread_run;
    CMDLineParser parent;

    public CMDLineParserThread(CMDLineParser parent) {
        super("CMDLineParserThread");
        this.parent = parent;
    }

    public void stopThread() {
        this.thread_run = false;
    }

    @Override
    public void run() {
        this.thread_run = true;
        while (this.thread_run) {
            BufferedReader d = new BufferedReader(new InputStreamReader(System.in));
            try {
                while (this.thread_run) {
                    String s = "";
                    System.out.flush();
                    System.out.print(">");
                    s = d.readLine();
                    if (s.equalsIgnoreCase("help")) {
                        this.parent.cmd_help();
                        continue;
                    }
                    if (s.equalsIgnoreCase("exit")) {
                        this.parent.cmd_exit();
                        continue;
                    }
                    if (s.equalsIgnoreCase("reload")) continue;
                    if (s.equalsIgnoreCase("show readers")) {
                        this.parent.cmd_show_readers();
                        continue;
                    }
                    if (s.equalsIgnoreCase("show writers")) {
                        this.parent.cmd_show_writers();
                        continue;
                    }
                    if (s.equalsIgnoreCase("show server")) {
                        this.parent.cmd_show_server();
                        continue;
                    }
                    if (s.equalsIgnoreCase("show java properties")) {
                        System.getProperties().list(System.out);
                        continue;
                    }
                    if (s.equalsIgnoreCase("show all")) {
                        this.parent.cmd_show_server();
                        this.parent.cmd_show_readers();
                        this.parent.cmd_show_writers();
                        continue;
                    }
                    if (s.toLowerCase().startsWith("kick")) {
                        if (s.length() < 5) {
                            System.out.println("You have to specify which reader to kick");
                            continue;
                        }
                        String r = s.substring(5);
                        this.parent.cmd_kick_reader(r);
                        continue;
                    }
                    if (s.equals("")) {
                        System.out.println(">");
                        continue;
                    }
                    System.out.println("Command or option not recognised");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

