/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdr;

import net.gopro.gdr.CMDLineParserThread;
import net.gopro.gdr.Reader;
import net.gopro.gdr.Router;

public class CMDLineParser {
    private static final String id = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/gopro/gdr/CMDLineParser.java 2     20.09.05 9:38 Kbg $";
    private Router parent;
    private CMDLineParserThread lpt;

    CMDLineParser(Router parent) {
        this.parent = parent;
    }

    public void stop() {
        this.lpt.stopThread();
    }

    public void serve() {
        this.lpt = new CMDLineParserThread(this);
        this.lpt.start();
    }

    void cmd_exit() {
        System.out.println("Starting server shutdown");
        this.parent.stop();
    }

    void cmd_show_readers() {
        System.out.println(this.parent.getReaders().report());
    }

    void cmd_show_writers() {
        System.out.println(this.parent.getWriters().report());
    }

    void cmd_kick_reader(String sreader) {
        if (sreader != null) {
            Reader r = this.parent.getReaders().getReaderByName(sreader);
            if (r != null) {
                r.kick();
            } else {
                System.out.println("Reader " + sreader + " not found");
            }
        }
    }

    void cmd_show_server() {
        Router.copyright();
        System.out.println(this.parent.report());
    }

    void cmd_help() {
        String msg = "";
        msg = msg + "EXIT                     Exit server \n";
        msg = msg + "HELP                     Help (Displays this help information)\n";
        msg = msg + "RELOAD                   Reload the readers and writers\n";
        msg = msg + "KICK <reader name>       Kick a reader\n";
        msg = msg + "SHOW                     Show information:\n";
        msg = msg + "    READERS                  Reader specific information\n";
        msg = msg + "    WRITERS                  Writer specific information\n";
        msg = msg + "    SERVER                   Server information\n";
        msg = msg + "    ALL                      All information\n";
        System.out.println(msg);
    }
}

