/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.crm.domino;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import lotus.domino.Item;
import lotus.domino.NotesException;
import net.gopro.crm.domino.Database;
import net.gopro.crm.domino.Document;
import net.gopro.crm.domino.Session;
import net.gopro.util.Log;
import net.gopro.util.domino.DateConvert;

public class ResponseDocument
extends Document {
    protected lotus.domino.Document m_ParentNotesDocument;
    private static int NR_FIELDS_TO_INHERIT = 17;
    private static String[] FIELDS_TO_INHERIT = new String[]{"CompanyName", "IDNumber", "CustomerNumber", "Name", "ContIDNumber", "Title", "Greeting", "ContactDep", "Location", "StreetAddress1", "StreetAddress2", "PostCodeNo", "PostCodeCity", "Country", "PhoneNumber", "FaxNumber", "ReadAccessList", "AuthorNames", "ReaderList", "Authorlist", "SendTo"};
    static int NR_FIELDS = 37;
    private static String[][] response = new String[][]{{"Case.Number", "String", "CaseNumber", "TEXT"}, {"Client.Address1", "String", "StreetAddress1", "TEXT"}, {"Client.Address2", "String", "StreetAddress2", "TEXT"}, {"Client.City", "String", "PostCodeCity", "TEXT"}, {"Client.Country", "String", "Country", "TEXT"}, {"Client.Fax", "String", "FaxNumber", "TEXT"}, {"Client.ID", "String", "IDnumber", "TEXT"}, {"Client.Language", "String", "Language", "TEXT"}, {"Client.Location", "String", "Location", "TEXT"}, {"Client.Name", "String", "CompanyName", "TEXT"}, {"Client.Number", "String", "CustomerNumber", "TEXT"}, {"Client.Phone", "String", "PhoneNumber", "TEXT"}, {"Client.PostCode", "String", "PostCodeNo", "TEXT"}, {"Contact.Department", "String", "ContactDep", "TEXT"}, {"Contact.Greeting", "String", "Greeting", "TEXT"}, {"Contact.ID", "String", "ContIDNumber", "TEXT"}, {"Contact.Name", "String", "Name", "TEXT"}, {"Document.AlarmText", "String", "AlarmText", "TEXT"}, {"Document.AlarmTime", "String", "AlarmTime", "TEXT"}, {"Document.Author", "String", "From", "TEXT"}, {"Document.AuthorInitials", "String", "Editor", "TEXT"}, {"Document.Body", "String", "Body", "RICHTEXT"}, {"Document.Cat", "String", "DocCat", "TEXT"}, {"Document.CreationDate", "Date", "CreationDate", "DATETIMES"}, {"Document.DateModified", "Date", "ModifiedDate", "DATETIMES"}, {"Document.FollowupDate", "String", "FollowupDate", "TEXT"}, {"Document.ID", "String", "GPUNID", "TEXT"}, {"Document.ParentID", "String", "parentDocumentID", "TEXT"}, {"Document.ReadAccessList", "String", "ReadAccessList", "READERS"}, {"Document.SerialNumber", "String", "DocumentSerialNumber", "TEXT"}, {"Document.Status", "String", "Status", "TEXT"}, {"document.subject", "String", "subject", "TEXT"}, {"Document.SubscriptionList", "String", "SubscriptionList", "TEXT"}, {"Document.Type", "String", "DocType", "TEXT"}, {"Document.WriteAccessList", "String", "AuthorNames", "AUTHORS"}, {"Response.NameTo", "String", "NameTo", "NAMES"}, {"response.sendto", "String", "sendto", "TEXT"}};

    public ResponseDocument() {
        this.initMapping();
    }

    public ResponseDocument(Database db) {
        super(db);
        this.initMapping();
    }

    @Override
    protected void inheritGoPro() {
        super.inheritGoPro();
        try {
            for (int i = 0; i < NR_FIELDS_TO_INHERIT; ++i) {
                Vector vecVal = this.m_ParentNotesDocument.getItemValue(FIELDS_TO_INHERIT[i]);
                this.m_NotesDocument.replaceItemValue(FIELDS_TO_INHERIT[i], (Object)vecVal);
            }
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
    }

    private void initMapping() {
        int i = 0;
        for (i = 0; i < NR_FIELDS; ++i) {
            String str0 = new String(response[i][0]).toLowerCase();
            String str1 = new String(response[i][1]).toLowerCase();
            String str2 = new String(response[i][2]).toLowerCase();
            String str3 = new String(response[i][3]).toLowerCase();
            this.m_hashNotesDoc.put(str0, str1);
            this.m_hashXMLRpcDoc.put(str2, str3);
            this.m_MapNotesXMLRpc.put(str2, str0);
            this.m_MapXMLRpcNotes.put(str0, str2);
        }
    }

    public Hashtable mapToNotes(Hashtable XMLdoc) {
        Hashtable<String, Object> retDoc = new Hashtable<String, Object>();
        if (XMLdoc != null) {
            String strField = new String();
            String strNotesField = new String();
            Enumeration e = XMLdoc.keys();
            while (e.hasMoreElements()) {
                Object objFieldVal = new Object();
                Vector vecFieldVal = new Vector();
                strField = (String)e.nextElement();
                objFieldVal = XMLdoc.get(strField.toLowerCase());
                if (objFieldVal == null) {
                    objFieldVal = XMLdoc.get(strField);
                }
                vecFieldVal = this.encapsulateObject(objFieldVal);
                strNotesField = (String)this.m_MapXMLRpcNotes.get(strField.toLowerCase());
                if (strNotesField == null || vecFieldVal == null) continue;
                retDoc.put(strNotesField.toLowerCase(), vecFieldVal.clone());
            }
        }
        return retDoc;
    }

    @Override
    public Hashtable updateDocument(int session, Hashtable doc, boolean computeWithForm) {
        Hashtable h = new Hashtable();
        Session s = this.m_ParentDatabase.getgpSession();
        try {
            Enumeration e = doc.keys();
            while (e.hasMoreElements()) {
                Vector value;
                String fieldName = (String)e.nextElement();
                if (fieldName.startsWith("$") || (value = (Vector)doc.get(fieldName)).size() <= 0) continue;
                if (value.elementAt(0) instanceof Date) {
                    Vector v = DateConvert.mkDateTimeVector(s.getSessionByID(session), value);
                    this.m_NotesDocument.replaceItemValue(fieldName, (Object)v);
                    continue;
                }
                this.m_NotesDocument.replaceItemValue(fieldName, (Object)value);
            }
            if (computeWithForm) {
                this.m_NotesDocument.computeWithForm(false, false);
            }
            this.m_NotesDocument.save(true, false);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        h = this.mapToXML(null);
        return h;
    }

    public Hashtable mapToXML(Hashtable NotesDoc) {
        Hashtable retDoc = new Hashtable();
        try {
            if (NotesDoc == null) {
                try {
                    NotesDoc = this.makeDocumentHashtable(this.m_NotesDocument, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (NotesDoc != null) {
                String strField = new String();
                String strXMLField = new String();
                Enumeration e = NotesDoc.keys();
                while (e.hasMoreElements()) {
                    strField = (String)e.nextElement();
                    Object objFieldVal = NotesDoc.get(strField.toLowerCase());
                    if (objFieldVal == null) {
                        try {
                            objFieldVal = NotesDoc.get(strField);
                        }
                        catch (Exception e2) {
                            Log.debug_println("Client: Value = null - " + NotesDoc.get(strField));
                        }
                    }
                    if ((strXMLField = (String)this.m_MapNotesXMLRpc.get(strField.toLowerCase())) == null || objFieldVal == null) continue;
                    retDoc.put(strXMLField.toLowerCase(), objFieldVal);
                }
            }
            retDoc.put("document.id", this.m_NotesDocument.getUniversalID());
            retDoc.put("document.parentid", this.m_NotesDocument.getParentDocumentUNID());
            retDoc.put("document.form", this.m_NotesDocument.getItemValueString("form"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retDoc;
    }

    public Hashtable makeDocumentHashtable(lotus.domino.Document ddoc, Vector fields) throws NotesException {
        Hashtable h = new Hashtable();
        if (fields == null || fields.size() == 0) {
            Vector items = ddoc.getItems();
            for (int j = 0; j < items.size(); ++j) {
                Item item = (Item)items.elementAt(j);
                this.addItemToHash(h, item);
            }
        } else {
            for (int i = 0; i < fields.size(); ++i) {
                String fieldName = (String)fields.elementAt(i);
                Item item = ddoc.getFirstItem(fieldName);
                if (item == null) continue;
                this.addItemToHash(h, item);
            }
        }
        Vector<String> vecPar = new Vector<String>();
        vecPar.addElement(this.m_ParentNotesDocument.getParentDocumentUNID());
        h.put("parentdocumentid", vecPar);
        Vector<String> vecID = new Vector<String>();
        vecID.addElement(ddoc.getUniversalID());
        h.put("documentid", vecID);
        return h;
    }

    void addItemToHash(Hashtable h, Item item) throws NotesException {
        if (item == null) {
            Log.debug_println("addItemToHash: null item");
            return;
        }
        if (item.getType() == 1024) {
            Vector v2 = DateConvert.mkJavaDateVector(item.getValues());
            if (v2 != null) {
                String strTemp2 = v2.toString();
                strTemp2 = strTemp2.substring(1, strTemp2.length() - 1);
                h.put(item.getName().toLowerCase(), strTemp2);
            }
        } else {
            Vector v = new Vector();
            v = item.getValues();
            if (v != null) {
                try {
                    String strTemp = v.toString();
                    String strTemp2 = strTemp.substring(1, strTemp.length() - 1);
                    h.put(item.getName().toLowerCase(), strTemp2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Hashtable addFieldToHash(Hashtable h, String strField, Object objVal) throws NotesException {
        if (objVal == null) {
            Log.debug_println("addFieldToHash: null item");
            return h;
        }
        if (strField != null) {
            h.put(strField.toLowerCase(), objVal);
        }
        return h;
    }

    public void setNotesDocument(lotus.domino.Document doc) {
        this.m_NotesDocument = doc;
    }

    public void setNotesParentDocument(lotus.domino.Document doc) {
        this.m_ParentNotesDocument = doc;
    }

    public void makeResponse(lotus.domino.Document doc) {
        try {
            this.m_ParentNotesDocument = doc;
            this.m_NotesDocument.makeResponse(this.m_ParentNotesDocument);
            this.inheritGoPro();
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
    }
}

