/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.crm.domino;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import lotus.domino.Item;
import lotus.domino.NotesException;
import net.gopro.crm.domino.Database;
import net.gopro.crm.domino.FieldMapper;
import net.gopro.crm.domino.Session;
import net.gopro.util.Log;
import net.gopro.util.domino.DateConvert;

public class Document
extends net.gopro.Document {
    protected FieldMapper myMapping;
    protected Hashtable m_hashXMLRpcDoc;
    protected Hashtable m_hashNotesDoc;
    protected Hashtable m_MapNotesXMLRpc;
    protected Hashtable m_MapXMLRpcNotes;
    protected lotus.domino.Document m_NotesDocument;
    protected Database m_ParentDatabase;
    private static int NR_INHERIT_MAINDOC = 17;
    private static String[] INHERIT_MAINDOC = new String[]{"CompanyName", "IDNumber", "CustomerNumber", "Name", "ContIDNumber", "Title", "Greeting", "ContactDep", "Location", "StreetAddress1", "StreetAddress2", "PostCodeNo", "PostCodeCity", "Country", "PhoneNumber", "FaxNumber", "ReadAccessList", "AuthorNames", "ReaderList", "Authorlist", "SendTo", null};

    public Document() {
        this.m_hashXMLRpcDoc = new Hashtable();
        this.m_hashNotesDoc = new Hashtable();
        this.m_MapNotesXMLRpc = new Hashtable();
        this.m_MapXMLRpcNotes = new Hashtable();
    }

    public Document(Database ParentDatabase) {
        this.m_ParentDatabase = ParentDatabase;
        this.m_hashXMLRpcDoc = new Hashtable();
        this.m_hashNotesDoc = new Hashtable();
        this.m_MapNotesXMLRpc = new Hashtable();
        this.m_MapXMLRpcNotes = new Hashtable();
    }

    @Override
    public Hashtable mapToDocument(Hashtable XMLdoc) {
        Hashtable<String, Object> retDoc = new Hashtable<String, Object>();
        this.m_MapXMLRpcNotes = this.myMapping.getXMLToNative();
        if (XMLdoc != null) {
            String strField = new String();
            String strNotesField = new String();
            Enumeration e = XMLdoc.keys();
            while (e.hasMoreElements()) {
                Object objFieldVal = new Object();
                strField = (String)e.nextElement();
                objFieldVal = XMLdoc.get(strField.toLowerCase());
                if (objFieldVal == null) {
                    objFieldVal = XMLdoc.get(strField);
                }
                Vector vecFieldVal = this.encapsulateObject(objFieldVal);
                Vector vecFieldName = (Vector)this.m_MapXMLRpcNotes.get(strField.toLowerCase());
                if (vecFieldName == null) continue;
                strNotesField = (String)vecFieldName.elementAt(0);
                if (vecFieldVal == null) continue;
                retDoc.put(strNotesField.toLowerCase(), vecFieldVal.clone());
            }
        }
        this.m_hashNotesDoc = retDoc;
        return retDoc;
    }

    @Override
    public Hashtable mapToXML(Object nDoc, Vector fields) {
        Hashtable<String, String> retDoc = new Hashtable<String, String>();
        try {
            this.m_NotesDocument = (lotus.domino.Document)nDoc;
            Hashtable NotesDoc = new Hashtable();
            Vector vecField = new Vector();
            String strField = new String();
            String strXMLField = new String();
            Item nItem = null;
            if (fields == null || fields.size() == 0) {
                this.m_MapNotesXMLRpc = this.myMapping.getNativeToXML();
                Enumeration e = this.m_MapNotesXMLRpc.keys();
                while (e.hasMoreElements()) {
                    strField = (String)e.nextElement();
                    nItem = this.m_NotesDocument.getFirstItem(strField);
                    if (nItem == null || (strXMLField = this.myMapping.getXMLFromNative(strField.toLowerCase())) == null) continue;
                    this.addItemToHash(retDoc, nItem, strXMLField.toLowerCase());
                }
            } else {
                for (int i = 0; i < fields.size(); ++i) {
                    Item item;
                    String fieldName = (String)fields.elementAt(i);
                    String strNotesFieldName = this.myMapping.getNativeFromXML(fieldName.toLowerCase());
                    if (strNotesFieldName == null || (item = this.m_NotesDocument.getFirstItem(strNotesFieldName)) == null) continue;
                    this.addItemToHash(retDoc, item, fieldName);
                }
            }
            retDoc.put("document.id", this.m_NotesDocument.getUniversalID());
            retDoc.put("document.form", this.m_NotesDocument.getItemValueString("form"));
            this.m_hashXMLRpcDoc = retDoc;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retDoc;
    }

    private Hashtable makeDocumentHashtable(lotus.domino.Document ddoc, Vector fields) throws NotesException {
        Hashtable h = new Hashtable();
        if (fields == null || fields.size() == 0) {
            Vector items = ddoc.getItems();
            for (int j = 0; j < items.size(); ++j) {
                Item item = (Item)items.elementAt(j);
                this.addItemToHash(h, item);
            }
        } else {
            for (int i = 0; i < fields.size(); ++i) {
                String fieldName = (String)fields.elementAt(i);
                String strNotesFieldName = (String)this.m_MapXMLRpcNotes.get(fieldName.toLowerCase());
                Item item = ddoc.getFirstItem(strNotesFieldName);
                if (item == null) continue;
                this.addItemToHash(h, item);
            }
        }
        Vector<String> vecID = new Vector<String>();
        vecID.addElement(this.m_NotesDocument.getUniversalID());
        h.put("documentid", vecID);
        return h;
    }

    private void addItemToHash(Hashtable h, Item item) throws NotesException {
        if (item == null) {
            Log.debug_println("addItemToHash: null item");
            return;
        }
        if (item.getType() == 1024) {
            h.put(item.getName().toLowerCase(), DateConvert.mkJavaDateVector(item.getValues()));
        } else {
            Vector v = new Vector();
            v = item.getValues();
            if (v != null) {
                h.put(item.getName().toLowerCase(), v);
            }
        }
    }

    protected void addItemToHash(Hashtable h, Item item, String strNameInHash) throws NotesException {
        if (item == null) {
            Log.debug_println("addItemToHash: null item");
            return;
        }
        if (item.getType() == 1024) {
            Vector v2 = DateConvert.mkJavaDateVector(item.getValues());
            if (v2 != null) {
                String strTemp2 = v2.toString();
                strTemp2 = strTemp2.substring(1, strTemp2.length() - 1);
                h.put(strNameInHash.toLowerCase(), strTemp2);
            }
        } else {
            Vector v = new Vector();
            v = item.getValues();
            if (v != null) {
                try {
                    String strTemp = v.toString();
                    String strTemp2 = strTemp.substring(1, strTemp.length() - 1);
                    h.put(strNameInHash.toLowerCase(), strTemp2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void setDocument(Object doc) {
        this.m_NotesDocument = (lotus.domino.Document)doc;
    }

    @Override
    public void replaceItemValue(String strFieldName, Vector val) {
        try {
            this.m_NotesDocument.replaceItemValue(strFieldName, (Object)val);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
    }

    protected void updateAccesControl() {
        try {
            Vector vecItemWrite = this.m_NotesDocument.getItemValue("AuthorNames");
            Vector vecItemRead = this.m_NotesDocument.getItemValue("ReadAccessList");
            this.m_NotesDocument.replaceItemValue("Authorlist", (Object)vecItemWrite);
            this.m_NotesDocument.replaceItemValue("Readerlist", (Object)vecItemRead);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
    }

    @Override
    public boolean save(boolean bForce, boolean bCreateConflict) {
        boolean ret = false;
        try {
            ret = this.m_NotesDocument.save(bForce, bCreateConflict);
            this.m_hashNotesDoc.remove("gpunid");
            this.m_hashNotesDoc.put("gpunid", this.m_NotesDocument.getUniversalID());
            this.m_hashXMLRpcDoc.remove("Document.ID");
            this.m_hashXMLRpcDoc.put("Document.ID", this.m_NotesDocument.getUniversalID());
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return ret;
    }

    @Override
    public Hashtable getDocumentHashtable() {
        return this.m_hashNotesDoc;
    }

    @Override
    public Hashtable getXMLHashtable() {
        return this.m_hashXMLRpcDoc;
    }

    @Override
    public Hashtable updateDocument(int session, Hashtable doc, boolean computeWithForm) {
        Hashtable h = new Hashtable();
        Session s = this.m_ParentDatabase.getgpSession();
        try {
            Enumeration e = doc.keys();
            while (e.hasMoreElements()) {
                Vector value;
                String fieldName = (String)e.nextElement();
                if (fieldName.startsWith("$") || (value = (Vector)doc.get(fieldName)).size() <= 0) continue;
                if (value.elementAt(0) instanceof Date) {
                    Vector v = DateConvert.mkDateTimeVector(s.getSessionByID(session), value);
                    this.m_NotesDocument.replaceItemValue(fieldName, (Object)v);
                    continue;
                }
                this.m_NotesDocument.replaceItemValue(fieldName, (Object)value);
            }
            if (computeWithForm) {
                this.m_NotesDocument.computeWithForm(false, false);
            }
            this.m_NotesDocument.save(true, false);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        h = this.mapToXML(this.m_NotesDocument, null);
        return h;
    }

    protected void inheritGoPro() {
        try {
            for (int i = 0; i < NR_INHERIT_MAINDOC; ++i) {
                Vector vecVal = this.m_NotesDocument.getItemValue(INHERIT_MAINDOC[i]);
                this.m_NotesDocument.replaceItemValue(INHERIT_MAINDOC[i], (Object)vecVal);
            }
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
    }

    @Override
    public String getItemValueString(String strFieldName) {
        try {
            return this.m_NotesDocument.getItemValueString(strFieldName);
        }
        catch (Exception e) {
            Log.print_exception(e);
            return null;
        }
    }

    protected Vector encapsulateObject(Object objVal) {
        Vector<Object> ret = new Vector<Object>();
        try {
            if (objVal instanceof Vector) {
                return (Vector)objVal;
            }
            if (objVal instanceof String) {
                String strTemp = (String)objVal;
                ret.addElement(strTemp);
                return ret;
            }
            ret.addElement(objVal);
            return ret;
        }
        catch (Exception e) {
            Log.debug_println("encapsulate 5");
            Log.print_exception(e);
            return null;
        }
    }
}

