/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.crm.domino;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import lotus.domino.DateTime;
import lotus.domino.DocumentCollection;
import lotus.domino.Item;
import lotus.domino.NotesException;
import lotus.domino.View;
import lotus.domino.ViewEntry;
import lotus.domino.ViewEntryCollection;
import net.gopro.crm.domino.Case;
import net.gopro.crm.domino.Client;
import net.gopro.crm.domino.ConstantDocument;
import net.gopro.crm.domino.Contact;
import net.gopro.crm.domino.Document;
import net.gopro.crm.domino.Email;
import net.gopro.crm.domino.Fax;
import net.gopro.crm.domino.Letter;
import net.gopro.crm.domino.ResponseDocument;
import net.gopro.crm.domino.Session;
import net.gopro.util.Log;
import net.gopro.util.domino.DateConvert;

public class Database
extends net.gopro.Database {
    static String ssid = "$Header: /gopro/products/GoPro_Web_for_J2EE/src/net/gopro/crm/domino/Database.java 2     20.09.05 9:38 Kbg $";
    final String GOPRO_CLIENT_VIEW_CUST = "companyFlatCust";
    final String GOPRO_CONTACT_VIEW_CUST = "ContactFlatCust";
    final String GOPRO_CLIENT_VIEW = "CompanyFlat";
    final String GOPRO_CONTACT_VIEW = "ContactFlatCust";
    final String GOPRO_CONTACT_BY_CLIENT_VIEW = "CompanyFlat";
    final String GOPRO_CASE_VIEW = "AllCases";
    final String GOPRO_LOOKUP_VIEW = "vwUNIDView";
    final String GOPRO_CLIENT_FORM = "Company";
    final String GOPRO_CONTACT_FORM = "CompContact";
    final String GOPRO_CASE_FORM = "MainDoc";
    final String GOPRO_EMAIL_FORM = "Memo";
    final String GOPRO_LETTER_FORM = "Letter";
    final String GOPRO_FAX_FORM = "Fax";
    private String m_Database;
    private String m_Server;
    private Session m_gpSession;
    private Client m_Client;
    private Contact m_Contact;
    private Case m_Case;
    private Email m_Email;
    private Letter m_Letter;
    private Fax m_Fax;
    private ResponseDocument m_Response;
    private ConstantDocument m_ConstDoc;
    private lotus.domino.Database m_CurDatabase;
    private lotus.domino.Document m_CurDocument;
    private Hashtable viewNames;

    public Database(String database) throws NotesException {
        this.m_Database = database;
        this.viewNames = new Hashtable();
        this.viewNames.put("CASE_NUMBER", "AllCases");
        this.viewNames.put("CASE_EMPLOYEE", "caseEmployee");
        this.viewNames.put("CASE_TYPE", "vwCaseType");
        this.viewNames.put("CASE_STATUS", "CasesByStatus");
        this.viewNames.put("CASE_SUBJECT", "casesBySubject");
        this.viewNames.put("CASE_CATEGORY", "vwCaseCategory");
        this.viewNames.put("CASE_DEADLINE", "CasesByTimeLimit");
        this.viewNames.put("DOC_CREATED", "docDate");
        this.viewNames.put("DOC_AUTHOR", "docAuthor");
        this.viewNames.put("CASE_COMPANYNAME", "casesByCompanyName");
        this.viewNames.put("CONTACT_COMPANYNAME", "CompanyFlat");
        this.viewNames.put("COMPANY_NAME", "CompanyFlat");
        this.viewNames.put("CONTACT_NAME", "ContactFlatCust");
        this.viewNames.put("CLIENT_CONTACT_ACCOUNTMANAGER", "custAccount");
        this.viewNames.put("CLIENT_CONTACT_IDNUMBER", "custID");
    }

    public int sendMail(int session, String documentID, Vector recipients) {
        try {
            lotus.domino.Session dominoSession = this.m_gpSession.getSessionByID(session);
            lotus.domino.Document doc = this.getDocumentByKey(dominoSession, documentID, "vwUNIDView");
            if (doc != null) {
                if (recipients.isEmpty() && (!doc.hasItem("SendTo") || doc.getItemValueString("sendTo") == "")) {
                    return 0;
                }
                if (!recipients.isEmpty() && doc.hasItem("sendTo")) {
                    Hashtable<String, Vector> d = new Hashtable<String, Vector>();
                    Hashtable h = new Hashtable();
                    d.put("sendTo", recipients);
                    if (doc.isResponse()) {
                        ResponseDocument res = new ResponseDocument(this);
                        res.setNotesDocument(doc);
                        String parentId = doc.getParentDocumentUNID();
                        lotus.domino.Document parent = this.getDocumentByKey(dominoSession, parentId, "vwUNIDView");
                        res.setNotesParentDocument(parent);
                        h = res.updateDocument(session, d, false);
                        if (h == null || h.isEmpty()) {
                            return 0;
                        }
                        res.save(true, false);
                    } else {
                        Document res = new Document(this);
                        res.setDocument(doc);
                        h = res.updateDocument(session, d, false);
                        if (h == null || h.isEmpty()) {
                            return 0;
                        }
                        res.save(true, false);
                    }
                }
                doc.send(recipients);
                return 1;
            }
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return 0;
    }

    public int markForDelete(int sessionID, String strDocumentID) {
        try {
            lotus.domino.Document doc = this.getDocumentByKey(this.m_gpSession.getSessionByID(sessionID), strDocumentID, "vwUNIDView");
            if (doc != null) {
                String strDocType = doc.getItemValueString("Form");
                Hashtable d = new Hashtable();
                Hashtable h = new Hashtable();
                Vector<Integer> newValue = new Vector<Integer>();
                newValue.addElement(new Integer(1));
                Vector<Date> newDate = new Vector<Date>();
                newDate.addElement(new Date());
                d.put("MARKFORDELETE", newValue);
                d.put("MarkForDeleteDate", newDate);
                Document docOther = new Document(this);
                docOther.setDocument(doc);
                h = docOther.updateDocument(sessionID, d, false);
                docOther.save(true, false);
                if (h != null && !h.isEmpty()) {
                    return 1;
                }
            }
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return 0;
    }

    public Vector getCases(int sessionID, String searchBy, String key, int maxReturn, int startPoint, Vector fields) {
        if (this.m_Case == null) {
            this.m_Case = new Case(this);
        }
        Vector v = new Vector();
        String viewName = (String)this.viewNames.get(searchBy);
        if (viewName == null) {
            viewName = "AllCases";
        }
        try {
            v = this.getDocumentsByKey(this.m_gpSession.getSessionByID(sessionID), viewName, "MainDoc", key, maxReturn, startPoint, 0, fields);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return v;
    }

    @Override
    public Vector getCases(int sessionID, String searchBy, Hashtable criteria, int maxReturn, int startPoint, Vector fields) {
        if (this.m_Case == null) {
            this.m_Case = new Case(this);
        }
        Vector v = new Vector();
        String viewName = (String)this.viewNames.get(searchBy);
        Hashtable criteriaNotes = this.m_Case.mapToDocument(criteria);
        String str_criteria = this.getCriteria(criteriaNotes);
        if (viewName == null) {
            viewName = "AllCases";
        }
        try {
            v = this.getDocumentsByFTSearch(this.m_gpSession.getSessionByID(sessionID), viewName, "MainDoc", str_criteria, maxReturn, startPoint, 0, fields);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return v;
    }

    @Override
    public Vector getClients(int sessionID, String searchBy, Hashtable criteria, int maxReturn, int startPoint, Vector fields) {
        if (this.m_Client == null) {
            this.m_Client = new Client(this);
        }
        Vector v = new Vector();
        String viewName = (String)this.viewNames.get(searchBy);
        Hashtable criteriaNotes = this.m_Client.mapToDocument(criteria);
        String str_criteria = this.getCriteria(criteriaNotes);
        if (viewName == null) {
            viewName = "CompanyFlat";
        }
        try {
            v = this.getDocumentsByFTSearch(this.m_gpSession.getSessionByID(sessionID), viewName, "Company", str_criteria, maxReturn, startPoint, 0, fields);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return v;
    }

    public Vector getClients(int sessionID, String searchBy, String key, int maxReturn, int startPoint, Vector fields) {
        if (this.m_Client == null) {
            this.m_Client = new Client(this);
        }
        Vector v = new Vector();
        String viewName = (String)this.viewNames.get(searchBy);
        if (viewName == null) {
            viewName = "CompanyFlat";
        }
        try {
            v = this.getDocumentsByKey(this.m_gpSession.getSessionByID(sessionID), viewName, "Company", key, maxReturn, startPoint, 0, fields);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return v;
    }

    @Override
    public Vector getContacts(int sessionID, String searchBy, Hashtable criteria, int maxReturn, int startPoint, Vector fields) {
        if (this.m_Contact == null) {
            this.m_Contact = new Contact(this);
        }
        Vector v = new Vector();
        String viewName = (String)this.viewNames.get(searchBy);
        Hashtable criteriaNotes = this.m_Contact.mapToDocument(criteria);
        String str_criteria = this.getCriteria(criteriaNotes);
        if (viewName == null) {
            viewName = "ContactFlatCust";
        }
        try {
            v = this.getDocumentsByFTSearch(this.m_gpSession.getSessionByID(sessionID), viewName, "CompContact", str_criteria, maxReturn, startPoint, 0, fields);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return v;
    }

    public Vector getContacts(int sessionID, String searchBy, String key, int maxReturn, int startPoint, Vector fields) {
        if (this.m_Contact == null) {
            this.m_Contact = new Contact(this);
        }
        Vector v = new Vector();
        String viewName = (String)this.viewNames.get(searchBy);
        if (viewName == null) {
            viewName = "ContactFlatCust";
        }
        try {
            v = this.getDocumentsByKey(this.m_gpSession.getSessionByID(sessionID), viewName, "CompContact", key, maxReturn, startPoint, 0, fields);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return v;
    }

    private String getCriteria(Hashtable criteria) {
        String res = new String("");
        if (criteria == null) {
            return res;
        }
        Enumeration e = criteria.keys();
        while (e.hasMoreElements()) {
            String fieldName = (String)e.nextElement();
            String fieldValue = (String)((Vector)criteria.get(fieldName)).elementAt(0);
            res = res + "FIELD " + fieldName + " CONTAINS " + fieldValue;
            if (!e.hasMoreElements()) continue;
            res = res + " AND ";
        }
        return res;
    }

    @Override
    public Hashtable createClient(int session, Hashtable doc) {
        Hashtable h = new Hashtable();
        Hashtable d = new Hashtable();
        try {
            if (this.m_Client == null) {
                this.m_Client = new Client(this);
            }
            d = this.m_Client.mapToDocument(doc);
            h = this.createDocument(this.m_gpSession.getSessionByID(session), "Company", d);
            this.m_Client.setDocument(this.m_CurDocument);
            this.m_Client.updateAccesControl();
            this.m_Client.save(true, false);
            h = this.m_Client.getXMLHashtable();
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return h;
    }

    @Override
    public Hashtable createContact(int session, Hashtable doc) {
        Hashtable h = new Hashtable();
        Hashtable d = new Hashtable();
        try {
            if (this.m_Contact == null) {
                this.m_Contact = new Contact(this);
            }
            d = this.m_Contact.mapToDocument(doc);
            this.createDocument(this.m_gpSession.getSessionByID(session), "CompContact", d);
            this.m_Contact.setDocument(this.m_CurDocument);
            this.m_Contact.updateAccesControl();
            this.m_Contact.save(true, false);
            h = this.m_Contact.getXMLHashtable();
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return h;
    }

    @Override
    public Hashtable createCase(int session, Hashtable doc) {
        Hashtable h = new Hashtable();
        Hashtable d = new Hashtable();
        try {
            if (this.m_Case == null) {
                this.m_Case = new Case(this);
            }
            lotus.domino.Session s = this.m_gpSession.getSessionByID(session);
            d = this.m_Case.mapToDocument(doc);
            h = this.createDocument(s, "MainDoc", d);
            this.m_Case.setDocument(this.m_CurDocument);
            this.m_Case.createCaseNumber(this.m_CurDatabase, s);
            this.m_Case.updateAccesControl();
            this.m_Case.computedWhenComposed();
            this.m_Case.save(true, false);
            h = this.m_Case.getXMLHashtable();
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return h;
    }

    @Override
    public Vector getDocumentsByKey(lotus.domino.Session session, String viewName, String formName, String criteria, int maxReturn, int startPoint, int searchOptions, Vector fields) {
        Vector v = new Vector();
        try {
            if (session == null) {
                throw new Exception("Unable to get session");
            }
            lotus.domino.Database db = session.getDatabase(null, this.m_Database);
            View view = db.getView(viewName + "_CUST");
            if (view == null && (view = db.getView(viewName)) == null) {
                throw new Exception("Unable to open view " + viewName);
            }
            view.refresh();
            DocumentCollection vec = null;
            ViewEntryCollection entColl = null;
            if (!criteria.equals("")) {
                vec = view.getAllDocumentsByKey((Object)criteria);
            } else if (view == null) {
                String strSearchCriteria = "FIELD Form CONTAINS \"" + formName + "\"";
                vec = db.FTSearch(strSearchCriteria, 0);
            } else {
                entColl = view.getAllEntries();
            }
            int found = 0;
            if (vec != null) {
                found = vec.getCount();
                v = this.mapResults(vec, formName, maxReturn, startPoint, fields);
            } else {
                found = entColl.getCount();
                v = this.mapResults(entColl, formName, maxReturn, startPoint, fields);
            }
        }
        catch (Exception e) {
            v.addElement(new String(e.toString()));
            e.printStackTrace();
        }
        return v;
    }

    public Vector getDocumentsByFTSearch(lotus.domino.Session session, String viewName, String formName, String criteria, int maxReturn, int startPoint, int searchOptions, Vector fields) {
        Vector v = new Vector();
        try {
            if (session == null) {
                throw new Exception("Unable to get session");
            }
            lotus.domino.Database db = session.getDatabase(null, this.m_Database);
            View view = db.getView(viewName + "_CUST");
            if (view == null && (view = db.getView(viewName)) == null) {
                throw new Exception("Unable to open view " + viewName);
            }
            view.refresh();
            DocumentCollection vec = null;
            ViewEntryCollection entColl = null;
            if (!criteria.equals("")) {
                entColl = view.getAllEntries();
                entColl.FTSearch(criteria, 0);
            } else if (view == null) {
                String strSearchCriteria = "FIELD Form CONTAINS \"" + formName + "\"";
                vec = db.FTSearch(strSearchCriteria, 0);
            } else {
                entColl = view.getAllEntries();
            }
            int found = 0;
            if (vec != null) {
                found = vec.getCount();
                v = this.mapResults(vec, formName, maxReturn, startPoint, fields);
            } else {
                found = entColl.getCount();
                v = this.mapResults(entColl, formName, maxReturn, startPoint, fields);
            }
        }
        catch (Exception e) {
            v.addElement(new String(e.toString()));
            e.printStackTrace();
        }
        return v;
    }

    private Vector mapResults(DocumentCollection vec, String formName, int maxReturn, int startPoint, Vector fields) {
        Vector<Object> v;
        block12: {
            v = new Vector<Object>();
            try {
                int found = vec.getCount();
                if (!(found > 0 & found + 1 > startPoint)) break block12;
                int idx = 0;
                if (startPoint == 0) {
                    startPoint = 1;
                }
                lotus.domino.Document doc = vec.getNthDocument(startPoint);
                while (doc != null && idx < maxReturn) {
                    try {
                        String form = doc.getItemValueString("form");
                        Vector vecIt = doc.getItems();
                        if (form != null && form.equalsIgnoreCase(formName)) {
                            if (form.equalsIgnoreCase("Company")) {
                                v.addElement(this.m_Client.mapToXML(doc, fields));
                            } else if (form.equalsIgnoreCase("CompContact")) {
                                v.addElement(this.m_Contact.mapToXML(doc, fields));
                            } else if (form.equalsIgnoreCase("MainDoc")) {
                                v.addElement(this.m_Case.mapToXML(doc, fields));
                            }
                            ++idx;
                        }
                    }
                    catch (Exception e) {
                        v.addElement(new String(e.toString()));
                        e.printStackTrace();
                    }
                    doc = vec.getNextDocument(doc);
                }
            }
            catch (Exception e) {
                v.addElement(new String(e.toString()));
                e.printStackTrace();
            }
        }
        return v;
    }

    private Vector mapResults(ViewEntryCollection vec, String formName, int maxReturn, int startPoint, Vector fields) {
        Vector<Object> v;
        Date d1;
        block12: {
            d1 = new Date();
            v = new Vector<Object>();
            try {
                int found = vec.getCount();
                if (!(found > 0 & found + 1 > startPoint)) break block12;
                int idx = 0;
                if (startPoint == 0) {
                    startPoint = 1;
                }
                ViewEntry ent = vec.getNthEntry(startPoint);
                lotus.domino.Document doc = null;
                while (ent != null && idx < maxReturn) {
                    try {
                        String form;
                        doc = ent.getDocument();
                        if (doc != null && (form = doc.getItemValueString("form")) != null && form.equalsIgnoreCase(formName)) {
                            if (form.equalsIgnoreCase("Company")) {
                                v.addElement(this.m_Client.mapToXML(doc, fields));
                            } else if (form.equalsIgnoreCase("CompContact")) {
                                v.addElement(this.m_Contact.mapToXML(doc, fields));
                            } else if (form.equalsIgnoreCase("MainDoc")) {
                                v.addElement(this.m_Case.mapToXML(doc, fields));
                            }
                            ++idx;
                        }
                    }
                    catch (Exception e) {
                        v.addElement(new String(e.toString()));
                        e.printStackTrace();
                    }
                    ent = vec.getNextEntry(ent);
                }
            }
            catch (Exception e) {
                v.addElement(new String(e.toString()));
                e.printStackTrace();
            }
        }
        Date d2 = new Date();
        Log.debug_time_println("mapResults all - ", d1, d2);
        return v;
    }

    private Hashtable createDocument(lotus.domino.Session session, String form, Hashtable doc) {
        Hashtable<String, Vector> h = new Hashtable<String, Vector>();
        try {
            if (session == null) {
                throw new Exception("Unable to get session");
            }
            lotus.domino.Database db = session.getDatabase(null, this.m_Database);
            lotus.domino.Document dominodoc = db.createDocument();
            Enumeration e = doc.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key.startsWith("$")) continue;
                Vector value = (Vector)doc.get(key);
                h.put(key, value);
                if (value.size() <= 0) continue;
                if (value.elementAt(0) instanceof Date) {
                    Vector v = DateConvert.mkDateTimeVector(session, value);
                    dominodoc.replaceItemValue(key, (Object)v);
                    continue;
                }
                try {
                    if (key.equalsIgnoreCase("Authors")) {
                        // empty if block
                    }
                    Item it = dominodoc.replaceItemValue(key, value.elementAt(0));
                    if (value.size() <= 1) continue;
                    for (int i = 1; i < value.size(); ++i) {
                        it.appendToTextList((String)value.elementAt(i));
                    }
                }
                catch (Exception e1) {
                    Log.print_exception(e1);
                }
            }
            dominodoc.replaceItemValue("form", (Object)form);
            dominodoc.save(true);
            this.m_CurDocument = dominodoc;
            this.m_CurDatabase = db;
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return h;
    }

    @Override
    public Hashtable createResponseDocument(int session, String strParentID, Hashtable doc) {
        Hashtable h = new Hashtable();
        Hashtable d = new Hashtable();
        try {
            if (this.m_Response == null) {
                this.m_Response = new ResponseDocument(this);
            }
            Vector vec = (Vector)doc.get("custom.form");
            String strForm = null;
            if (vec != null) {
                strForm = (String)vec.elementAt(0);
            }
            d = this.m_Response.mapToNotes(doc);
            h = this.createDocument(this.m_gpSession.getSessionByID(session), strForm, d);
            this.m_Response.setNotesDocument(this.m_CurDocument);
            this.m_Response.makeResponse(this.getDocumentByKey(this.m_gpSession.getSessionByID(session), strParentID, "vwUNIDView"));
            this.m_Response.save(true, false);
            h = this.m_Response.getXMLHashtable();
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return h;
    }

    public Session getgpSession() {
        return this.m_gpSession;
    }

    public void setgpSession(Session gpSession) {
        this.m_gpSession = gpSession;
    }

    @Override
    public Vector getRelatedDocuments(int sessionID, String strDocumentKey) {
        Vector v = new Vector();
        try {
            lotus.domino.Session session = this.m_gpSession.getSessionByID(sessionID);
            if (session == null) {
                throw new Exception("Unable to get session");
            }
            lotus.domino.Database db = session.getDatabase(null, this.m_Database);
            View view = db.getView("vwUNIDView");
            if (view == null) {
                throw new Exception("Unable to open view vwUNIDView");
            }
            view.refresh();
            DocumentCollection vec = view.getAllDocumentsByKey((Object)strDocumentKey);
            int found = vec.getCount();
            if (found > 0) {
                boolean idx = false;
                lotus.domino.Document doc = vec.getFirstDocument();
                if (doc != null) {
                    String form = doc.getItemValueString("form");
                    v = this.getAllChildren(v, doc);
                }
            }
        }
        catch (Exception e) {
            v.addElement(new String(e.toString()));
            e.printStackTrace();
        }
        return v;
    }

    private Vector getAllChildren(Vector v, lotus.domino.Document doc) {
        try {
            String form = doc.getItemValueString("form");
            DocumentCollection children = doc.getResponses();
            if (children != null) {
                int iResp = children.getCount();
                lotus.domino.Document docChild = children.getFirstDocument();
                while (docChild != null) {
                    v = this.getAllChildren(v, docChild);
                    ResponseDocument res = new ResponseDocument();
                    res.setNotesDocument(docChild);
                    res.setNotesParentDocument(doc);
                    v.addElement(res.mapToXML(res.makeDocumentHashtable(docChild, null)));
                    docChild = children.getNextDocument(docChild);
                }
            }
        }
        catch (Exception e) {
            v.addElement(new String(e.toString()));
            e.printStackTrace();
        }
        return v;
    }

    @Override
    public Hashtable createEmail(int session, String strParentID, Hashtable doc) {
        Hashtable h = new Hashtable();
        Hashtable d = new Hashtable();
        try {
            if (this.m_Email == null) {
                this.m_Email = new Email(this);
            }
            d = this.m_Email.mapToNotes(doc);
            h = this.createDocument(this.m_gpSession.getSessionByID(session), "Memo", d);
            this.m_Email.setNotesDocument(this.m_CurDocument);
            this.m_Email.makeResponse(this.getDocumentByKey(this.m_gpSession.getSessionByID(session), strParentID, "vwUNIDView"));
            this.m_Email.save(true, false);
            h = this.m_Email.getXMLHashtable();
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return h;
    }

    @Override
    public Hashtable createLetter(int session, String strParentID, Hashtable doc) {
        Hashtable h = new Hashtable();
        Hashtable d = new Hashtable();
        try {
            if (this.m_Letter == null) {
                this.m_Letter = new Letter(this);
            }
            d = this.m_Letter.mapToNotes(doc);
            h = this.createDocument(this.m_gpSession.getSessionByID(session), "Letter", d);
            this.m_Letter.setNotesDocument(this.m_CurDocument);
            this.m_Letter.makeResponse(this.getDocumentByKey(this.m_gpSession.getSessionByID(session), strParentID, "vwUNIDView"));
            this.m_Letter.save(true, false);
            h = this.m_Letter.getXMLHashtable();
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return h;
    }

    @Override
    public Hashtable createFax(int session, String strParentID, Hashtable doc) {
        Hashtable h = new Hashtable();
        Hashtable d = new Hashtable();
        try {
            if (this.m_Fax == null) {
                this.m_Fax = new Fax(this);
            }
            d = this.m_Fax.mapToNotes(doc);
            h = this.createDocument(this.m_gpSession.getSessionByID(session), "Fax", d);
            this.m_Fax.setNotesDocument(this.m_CurDocument);
            this.m_Fax.makeResponse(this.getDocumentByKey(this.m_gpSession.getSessionByID(session), strParentID, "vwUNIDView"));
            this.m_Fax.save(true, false);
            h = this.m_Fax.getXMLHashtable();
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return h;
    }

    private lotus.domino.Document getDocumentByKey(lotus.domino.Session session, String strDocumentKey, String strView) {
        lotus.domino.Document doc = null;
        try {
            lotus.domino.Database db = session.getDatabase(null, this.m_Database);
            View view = db.getView(strView);
            if (view == null) {
                throw new Exception("Unable to open view " + strView);
            }
            view.refresh();
            DocumentCollection vec = view.getAllDocumentsByKey((Object)strDocumentKey);
            int found = vec.getCount();
            if (found > 0) {
                doc = vec.getFirstDocument();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    public int deleteDocument(int session, String strDocumentID) {
        int res = 0;
        try {
            lotus.domino.Document doc = this.getDocumentByKey(this.m_gpSession.getSessionByID(session), strDocumentID, "vwUNIDView");
            if (doc != null) {
                res = doc.remove(false) ? 1 : 0;
            }
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return res;
    }

    @Override
    public Hashtable updateDocument(int session, String strDocumentKey, Hashtable XMLdoc, boolean computeWithForm) {
        Hashtable h = new Hashtable();
        try {
            lotus.domino.Document doc = this.getDocumentByKey(this.m_gpSession.getSessionByID(session), strDocumentKey, "vwUNIDView");
            if (doc != null) {
                String strDocType = doc.getItemValueString("Form");
                h = this.updateType(session, doc, strDocType, XMLdoc, computeWithForm);
            }
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return h;
    }

    private Hashtable updateType(int session, lotus.domino.Document doc, String strDocType, Hashtable XMLdoc, boolean computeWithForm) {
        Hashtable d = new Hashtable();
        Hashtable h = new Hashtable();
        try {
            if (doc != null) {
                if (strDocType.equalsIgnoreCase("Company")) {
                    if (this.m_Client == null) {
                        this.m_Client = new Client(this);
                    }
                    d = this.m_Client.mapToDocument(XMLdoc);
                    this.m_Client.setDocument(doc);
                    h = this.m_Client.updateDocument(session, d, computeWithForm);
                    this.m_Client.save(true, false);
                } else if (strDocType.equalsIgnoreCase("CompContact")) {
                    if (this.m_Contact == null) {
                        this.m_Contact = new Contact(this);
                    }
                    d = this.m_Contact.mapToDocument(XMLdoc);
                    this.m_Contact.setDocument(doc);
                    h = this.m_Contact.updateDocument(session, d, computeWithForm);
                    this.m_Contact.save(true, false);
                } else if (strDocType.equalsIgnoreCase("MainDoc")) {
                    if (this.m_Case == null) {
                        this.m_Case = new Case(this);
                    }
                    d = this.m_Case.mapToDocument(XMLdoc);
                    this.m_Case.setDocument(doc);
                    h = this.m_Case.updateDocument(session, d, computeWithForm);
                    this.m_Case.save(true, false);
                } else if (strDocType.equalsIgnoreCase("Email")) {
                    if (this.m_Email == null) {
                        this.m_Email = new Email(this);
                    }
                    d = this.m_Email.mapToDocument(XMLdoc);
                    this.m_Email.setDocument(doc);
                    h = this.m_Email.updateDocument(session, d, computeWithForm);
                    this.m_Email.save(true, false);
                } else if (strDocType.equalsIgnoreCase("Letter")) {
                    if (this.m_Letter == null) {
                        this.m_Letter = new Letter(this);
                    }
                    d = this.m_Letter.mapToDocument(XMLdoc);
                    this.m_Letter.setDocument(doc);
                    h = this.m_Letter.updateDocument(session, d, computeWithForm);
                    this.m_Letter.save(true, false);
                } else if (strDocType.equalsIgnoreCase("Fax")) {
                    if (this.m_Fax == null) {
                        this.m_Fax = new Fax(this);
                    }
                    d = this.m_Fax.mapToDocument(XMLdoc);
                    this.m_Fax.setDocument(doc);
                    h = this.m_Fax.updateDocument(session, d, computeWithForm);
                    this.m_Fax.save(true, false);
                } else if (strDocType.equalsIgnoreCase("Response")) {
                    if (this.m_Response == null) {
                        this.m_Response = new ResponseDocument();
                    }
                    d = this.m_Response.mapToDocument(XMLdoc);
                    this.m_Response.setDocument(doc);
                    h = this.m_Response.updateDocument(session, d, computeWithForm);
                    this.m_Response.save(true, false);
                } else {
                    Document docOther = new Document();
                    d = docOther.mapToDocument(XMLdoc);
                    docOther.setDocument(doc);
                    h = docOther.updateDocument(session, d, computeWithForm);
                    docOther.save(true, false);
                }
            }
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return h;
    }

    Hashtable makeDocumentHashtable(lotus.domino.Document ddoc, Vector fields) throws NotesException {
        Hashtable h = new Hashtable();
        if (fields == null || fields.size() == 0) {
            Vector items = ddoc.getItems();
            for (int j = 0; j < items.size(); ++j) {
                Item item = (Item)items.elementAt(j);
                this.addItemToHash(h, item);
            }
        } else {
            for (int i = 0; i < fields.size(); ++i) {
                String fieldName = (String)fields.elementAt(i);
                Item item = ddoc.getFirstItem(fieldName);
                if (item == null) continue;
                this.addItemToHash(h, item);
            }
        }
        return h;
    }

    public int getNumberOfCases(int sessionID, String searchBy, Hashtable criteria) {
        int res = 0;
        if (this.m_Case == null) {
            this.m_Case = new Case(this);
        }
        String viewName = (String)this.viewNames.get(searchBy);
        Hashtable criteriaNotes = this.m_Case.mapToDocument(criteria);
        String str_criteria = this.getCriteria(criteriaNotes);
        try {
            res = this.getNumberOfDocumentsInView(this.m_gpSession.getSessionByID(sessionID), viewName, "MainDoc", str_criteria);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return res;
    }

    public int getNumberOfClients(int sessionID, String searchBy, Hashtable criteria) {
        int res = 0;
        if (this.m_Client == null) {
            this.m_Client = new Client(this);
        }
        String viewName = (String)this.viewNames.get(searchBy);
        Hashtable criteriaNotes = this.m_Client.mapToDocument(criteria);
        String str_criteria = this.getCriteria(criteriaNotes);
        try {
            res = this.getNumberOfDocumentsInView(this.m_gpSession.getSessionByID(sessionID), viewName, "Company", str_criteria);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return res;
    }

    public int getNumberOfContacts(int sessionID, String searchBy, Hashtable criteria) {
        int res = 0;
        if (this.m_Contact == null) {
            this.m_Contact = new Contact(this);
        }
        String viewName = (String)this.viewNames.get(searchBy);
        Hashtable criteriaNotes = this.m_Contact.mapToDocument(criteria);
        String str_criteria = this.getCriteria(criteriaNotes);
        try {
            res = this.getNumberOfDocumentsInView(this.m_gpSession.getSessionByID(sessionID), viewName, "CompContact", str_criteria);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return res;
    }

    public String getDatabaseTitle(int session) {
        String dbTitle = new String("Database not found or you have insufficient access to database " + this.m_Database);
        try {
            lotus.domino.Session s = this.m_gpSession.getSessionByID(session);
            lotus.domino.Database db = s.getDatabase(null, this.m_Database);
            dbTitle = db.getTitle();
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return dbTitle;
    }

    public Hashtable getDocumentByID(int sessionID, String ID, Vector fields) {
        Hashtable h = new Hashtable();
        try {
            lotus.domino.Session session = this.m_gpSession.getSessionByID(sessionID);
            if (session == null) {
                throw new Exception("Unable to get session");
            }
            lotus.domino.Document doc = this.getDocumentByKey(session, ID, "vwUNIDView");
            if (doc != null) {
                if (doc.isResponse()) {
                    ResponseDocument res = new ResponseDocument(this);
                    res.setNotesDocument(doc);
                    String parentId = doc.getParentDocumentUNID();
                    lotus.domino.Document parent = this.getDocumentByKey(session, parentId, "vwUNIDView");
                    res.setNotesParentDocument(parent);
                    h = res.mapToXML(res.makeDocumentHashtable(doc, fields.isEmpty() ? null : fields));
                } else {
                    String form = doc.getItemValueString("form");
                    if (form != null) {
                        if (form.equalsIgnoreCase("Company")) {
                            if (this.m_Client == null) {
                                this.m_Client = new Client(this);
                            }
                            h = this.m_Client.mapToXML(doc, null);
                        } else if (form.equalsIgnoreCase("CompContact")) {
                            if (this.m_Contact == null) {
                                this.m_Contact = new Contact(this);
                            }
                            h = this.m_Contact.mapToXML(doc, null);
                        } else if (form.equalsIgnoreCase("MainDoc")) {
                            if (this.m_Case == null) {
                                this.m_Case = new Case(this);
                            }
                            h = this.m_Case.mapToXML(doc, null);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return h;
    }

    int getNumberOfDocumentsInView(lotus.domino.Session session, String viewName, String formName, String criteria) {
        try {
            if (session == null) {
                throw new Exception("Unable to get session");
            }
            lotus.domino.Database db = session.getDatabase(null, this.m_Database);
            View view = db.getView(viewName + "_CUST");
            if (view == null && (view = db.getView(viewName)) == null) {
                throw new Exception("Unable to open view " + viewName);
            }
            view.refresh();
            DocumentCollection vec = null;
            ViewEntryCollection entColl = null;
            String strSearchCriteria = "FIELD Form CONTAINS \"" + formName + "\"";
            if (!criteria.equals("")) {
                entColl = view.getAllEntries();
                entColl.FTSearch(criteria + " AND " + strSearchCriteria, 0);
            } else if (view == null) {
                vec = db.FTSearch(strSearchCriteria, 0);
            } else {
                entColl = view.getAllEntries();
                entColl.FTSearch(strSearchCriteria, 0);
            }
            int found = 0;
            if (vec != null) {
                found = vec.getCount();
                return found;
            }
            found = entColl.getCount();
            return found;
        }
        catch (Exception e) {
            Log.print_exception(e);
            return 0;
        }
    }

    void addItemToHash(Hashtable h, Item item) throws NotesException {
        if (item == null) {
            return;
        }
        if (item.getType() == 1024) {
            h.put(item.getName(), this.mkJavaDateVector(item.getValues()));
        } else {
            Vector v = new Vector();
            v = item.getValues();
            if (v != null) {
                h.put(item.getName(), v);
            }
        }
    }

    Vector mkJavaDateVector(Vector v_in) throws NotesException {
        Vector<Date> v = new Vector<Date>();
        for (int i = 0; i < v_in.size(); ++i) {
            DateTime dt = (DateTime)v_in.elementAt(i);
            v.addElement(new Date(dt.toJavaDate().getTime()));
        }
        return v;
    }

    Vector mkDateTimeVector(lotus.domino.Session session, Vector v_in) throws NotesException {
        Vector<DateTime> v = new Vector<DateTime>();
        for (int i = 0; i < v_in.size(); ++i) {
            Date jdate = (Date)v_in.elementAt(i);
            v.addElement(session.createDateTime(jdate));
        }
        return v;
    }

    public Vector getViewEntries(int sessionID, String strView, String key, int maxReturn, int startPoint, int levels) {
        Vector<Hashtable> v = new Vector<Hashtable>();
        try {
            lotus.domino.Session session = this.m_gpSession.getSessionByID(sessionID);
            lotus.domino.Database db = session.getDatabase(null, this.m_Database);
            View vwView = db.getView(strView);
            if (vwView == null) {
                throw new Exception("Unable to open view " + strView);
            }
            vwView.refresh();
            ViewEntryCollection vColl = null;
            vColl = key == null | key.equals("") ? vwView.getAllEntries() : vwView.getAllEntriesByKey((Object)key, false);
            int found = vColl.getCount();
            Object vecCol = null;
            Object vecEnt = null;
            Hashtable h = new Hashtable();
            if (found > 0 & found + 1 > startPoint) {
                int idx = 0;
                if (startPoint == 0) {
                    startPoint = 1;
                }
                ViewEntry ent = vColl.getNthEntry(startPoint);
                while (ent != null && idx < maxReturn) {
                    if (ent.isCategory()) {
                        System.out.println("Indent = " + ent.getIndentLevel());
                    }
                    h = this.createXMLviewEntry(ent);
                    v.addElement(h);
                    ++idx;
                    ent = vColl.getNextEntry(ent);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return v;
    }

    private Hashtable createXMLviewEntry(ViewEntry ent) throws NotesException {
        Hashtable<String, String> h = new Hashtable<String, String>();
        Vector vec = ent.getColumnValues();
        for (int i = 0; i < vec.size(); ++i) {
            String strTemp = vec.elementAt(i).toString();
            if (!(strTemp != null & !strTemp.equals(""))) continue;
            h.put("col" + Integer.toString(i), strTemp);
        }
        h.put("document.id", ent.getUniversalID());
        return h;
    }
}

