/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.crm.domino;

import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import lotus.domino.Database;
import lotus.domino.DateRange;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.Item;
import lotus.domino.NotesException;
import lotus.domino.View;
import lotus.domino.ViewEntry;
import lotus.domino.ViewEntryCollection;
import net.gopro.crm.domino.CalendarEvent;
import net.gopro.crm.domino.Session;
import net.gopro.util.Log;

public class CalendarDatabase {
    private Database m_curCalendar;
    private Session m_gpSession;

    public CalendarDatabase(Session gpSession) {
        this.m_gpSession = gpSession;
        try {
            lotus.domino.Session session = this.m_gpSession.getNotesSession();
            if (session == null) {
                throw new Exception("Unable to get session");
            }
            if (!this.setCalendarDatabase(session)) {
                Log.debug_println("CalendarDatabase:No calendar found");
            }
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
    }

    public boolean isCalendarFound() {
        return this.m_curCalendar != null;
    }

    public void setSession(Session gpSession) {
        Log.debug_println("net.gopro.crm.domino.CalendarDatabase::setSession");
        this.m_gpSession = gpSession;
    }

    public Session getgpSession() {
        return this.m_gpSession;
    }

    public void setgpSession(Session gpSession) {
        this.m_gpSession = gpSession;
    }

    public int updateEvent(int sessionID, String documentID, Hashtable changes) {
        int resInt = 0;
        try {
            lotus.domino.Session session = this.m_gpSession.getSessionByID(sessionID);
            if (session == null) {
                throw new Exception("Unable to get session");
            }
            if (!this.setCalendarDatabase(session)) {
                return resInt;
            }
            if (this.m_curCalendar == null) {
                Log.debug_println("CalendarDatabase::getEventsByMonth-not current calendar");
                return resInt;
            }
            Document doc = this.m_curCalendar.getDocumentByUNID(documentID);
            if (doc != null) {
                Hashtable d = new Hashtable();
                Hashtable h = new Hashtable();
                CalendarEvent res = new CalendarEvent(doc, this);
                d = res.mapToDocument(changes);
                h = res.updateDocument(sessionID, d, true);
                if (h != null && !h.isEmpty()) {
                    return 1;
                }
            }
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return resInt;
    }

    public Hashtable getEventByID(int sessionID, String documentID, Vector fields) {
        Log.debug_println("net.gopro.crm.domino.CalendarDatabase::getEventByID");
        Hashtable h = new Hashtable();
        try {
            lotus.domino.Session session = this.m_gpSession.getSessionByID(sessionID);
            if (session == null) {
                throw new Exception("Unable to get session");
            }
            if (!this.setCalendarDatabase(session)) {
                return h;
            }
            if (this.m_curCalendar == null) {
                Log.debug_println("CalendarDatabase::getEventsByMonth-not current calendar");
                return h;
            }
            Document doc = this.m_curCalendar.getDocumentByUNID(documentID);
            if (doc != null) {
                CalendarEvent res = new CalendarEvent(doc, this);
                h = res.mapToXML(fields);
            }
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return h;
    }

    public Vector getEventsByMonth(int sessionID, String month, Vector fields) {
        Log.debug_println("net.gopro.crm.domino.CalendarDatabase::getEventsByMonth");
        Vector v = new Vector();
        try {
            lotus.domino.Session session = this.m_gpSession.getSessionByID(sessionID);
            if (session == null) {
                throw new Exception("Unable to get session");
            }
            if (!this.setCalendarDatabase(session)) {
                return v;
            }
            if (this.m_curCalendar == null) {
                return v;
            }
            DateRange daterange = this.getMonthRange(session, month);
            if (daterange == null) {
                Log.debug_println("net.gopro.crm.domino.CalendarDatabase::getEventsByMonth-illegal dateformat");
                return v;
            }
            String viewName = "Calendar";
            View eventView = this.m_curCalendar.getView(viewName);
            if (eventView == null) {
                Log.debug_println("CalendarDatabase::no calendar view found in database");
                return v;
            }
            ViewEntryCollection eventEntries = eventView.getAllEntriesByKey((Object)daterange);
            if (eventEntries == null) {
                Log.debug_println("CalendarDatabase::no events found");
                return v;
            }
            Log.debug_println("CalendarDatabase::getEventsByMonth-events found: " + eventEntries.getCount());
            v = this.mapResults(eventEntries, fields);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return v;
    }

    private Vector mapResults(ViewEntryCollection vec, Vector fields) {
        Vector<Object> v = new Vector<Object>();
        try {
            int found = vec.getCount();
            if (found > 0) {
                boolean idx = false;
                ViewEntry ent = vec.getFirstEntry();
                Document doc = null;
                while (ent != null) {
                    doc = ent.getDocument();
                    if (doc != null) {
                        CalendarEvent event = new CalendarEvent(doc, this);
                        v.addElement(event.mapToXML(fields));
                    }
                    ent = vec.getNextEntry(ent);
                }
            }
        }
        catch (Exception e) {
            v.addElement(new String(e.toString()));
            e.printStackTrace();
        }
        return v;
    }

    Hashtable makeDocumentHashtable(Document ddoc, Vector fields) throws NotesException {
        Hashtable h = new Hashtable();
        if (fields == null || fields.size() == 0) {
            Vector items = ddoc.getItems();
            for (int j = 0; j < items.size(); ++j) {
                Item item = (Item)items.elementAt(j);
                this.addItemToHash(h, item);
            }
        } else {
            for (int i = 0; i < fields.size(); ++i) {
                String fieldName = (String)fields.elementAt(i);
                Item item = ddoc.getFirstItem(fieldName);
                if (item == null) continue;
                this.addItemToHash(h, item);
            }
        }
        return h;
    }

    public int deleteEvent(int sessionID, String documentID) {
        int res = 0;
        try {
            lotus.domino.Session session = this.m_gpSession.getSessionByID(sessionID);
            if (session == null) {
                throw new Exception("Unable to get session");
            }
            if (!this.setCalendarDatabase(session)) {
                return 0;
            }
            if (this.m_curCalendar == null) {
                Log.debug_println("CalendarDatabase::getEventsByMonth-not current calendar");
                return 0;
            }
            Document doc = this.m_curCalendar.getDocumentByUNID(documentID);
            if (doc != null) {
                res = doc.remove(false) ? 1 : 0;
            }
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return res;
    }

    private DateRange getMonthRange(lotus.domino.Session session, String month) {
        String firstDay = month;
        try {
            DateTime dtbegin = session.createDateTime(firstDay);
            Log.debug_println("CalendarDatabase::getEventsByMonth" + dtbegin.getDateOnly());
            DateTime dtend = session.createDateTime(firstDay);
            dtend.adjustMonth(1);
            dtend.adjustDay(-1);
            DateRange dr = session.createDateRange(dtbegin, dtend);
            return dr;
        }
        catch (Exception e) {
            Log.print_exception(e);
            return null;
        }
    }

    private boolean setCalendarDatabase(lotus.domino.Session session) {
        Log.debug_println("net.gopro.crm.domino.CalendarDatabase::setCalendarDatabase");
        try {
            Database serverAddressBook = session.getDatabase(null, "names.nsf");
            Log.debug_println("Server addressbook found " + serverAddressBook.getTitle());
            String userName = session.getUserName();
            View lookupView = serverAddressBook.getView("($Users)");
            if (lookupView == null) {
                Log.debug_println("No person lookupview found in " + serverAddressBook.getTitle());
                return false;
            }
            Document persondoc = lookupView.getDocumentByKey((Object)userName, false);
            if (persondoc == null) {
                Log.debug_println("Person document not found for " + userName);
                return false;
            }
            String mailFile = persondoc.getItemValueString("MailFile");
            if (mailFile == "") {
                Log.debug_println("No mailfile location registered for " + userName);
                return false;
            }
            this.m_curCalendar = session.getDatabase(null, mailFile);
            if (this.m_curCalendar == null) {
                Log.debug_println("No calendar found for " + userName + " at " + mailFile);
                return false;
            }
            Log.debug_println("Calendar " + this.m_curCalendar.getTitle() + " found for " + userName + " at " + mailFile);
        }
        catch (Exception e) {
            Log.print_exception(e);
        }
        return true;
    }

    void addItemToHash(Hashtable h, Item item) throws NotesException {
        if (item == null) {
            return;
        }
        if (item.getType() == 1024) {
            h.put(item.getName(), this.mkJavaDateVector(item.getValues()));
        } else {
            Vector v = new Vector();
            v = item.getValues();
            if (v != null) {
                h.put(item.getName(), v);
            }
        }
    }

    Vector mkJavaDateVector(Vector v_in) throws NotesException {
        Vector<Date> v = new Vector<Date>();
        for (int i = 0; i < v_in.size(); ++i) {
            DateTime dt = (DateTime)v_in.elementAt(i);
            v.addElement(new Date(dt.toJavaDate().getTime()));
        }
        return v;
    }
}

