/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.ws.proxy;

import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.soap.SOAPBinding;
import net.gopro.gdf.data.DocumentCollectionType;
import net.gopro.gdf.data.EntityCollectionType;
import net.gopro.gdf.data.InlineMetaDataCollectionType;
import net.gopro.gdf.data.PhaseType;
import net.gopro.gdf.data.RoutingSlipType;
import net.gopro.gdf.exceptions.GdfServiceException;
import net.gopro.gdf.services.IWorkflowService;
import net.gopro.gdf.ws.handlers.DominoAxisHandler;
import net.gopro.gdf.ws.handlers.LoggingHandler;
import net.gopro.gdf.ws.proxy.plain.workflow.WorkflowService_Service;
import net.gopro.gdf.ws.util.ArrayUtils;

public class WorkflowService
implements IWorkflowService {
    private static final QName qname;
    private WorkflowService_Service proxy;
    private net.gopro.gdf.ws.proxy.plain.workflow.WorkflowService stub;
    private boolean debug = false;
    private static final URL wsdlUrl;

    public WorkflowService(String endpoint, String username, String password) {
        this.initializeService(endpoint, username, password);
    }

    public WorkflowService(String endpoint, String username, String password, boolean debug) {
        this.debug = debug;
        this.initializeService(endpoint, username, password);
    }

    private void initializeService(String endpoint, String username, String password) {
        this.proxy = new WorkflowService_Service(wsdlUrl, qname);
        this.stub = this.proxy.getWorkflowServiceSoap();
        ((BindingProvider)this.stub).getRequestContext().put("javax.xml.ws.service.endpoint.address", endpoint);
        ((BindingProvider)this.stub).getRequestContext().put("javax.xml.ws.security.auth.username", username);
        ((BindingProvider)this.stub).getRequestContext().put("javax.xml.ws.security.auth.password", password);
        ArrayList<Object> chain = new ArrayList<Object>();
        if (this.debug) {
            chain.add(new LoggingHandler());
        }
        if (endpoint.toLowerCase().contains(".nsf")) {
            chain.add(new DominoAxisHandler());
        }
        ((BindingProvider)this.stub).getBinding().setHandlerChain(chain);
        SOAPBinding binding = (SOAPBinding)((BindingProvider)this.stub).getBinding();
        binding.setMTOMEnabled(true);
        ((BindingProvider)this.stub).getRequestContext().put("com.sun.xml.ws.request.timeout", 60000);
        ((BindingProvider)this.stub).getRequestContext().put("com.sun.xml.ws.connect.timeout", 120000);
    }

    public void approveReview(RoutingSlipType routingSlipType, String comment, String response) throws GdfServiceException {
        try {
            this.stub.approveReview(routingSlipType.toXMLString(), comment, response);
        }
        catch (Exception ex) {
            throw new GdfServiceException((Throwable)ex);
        }
    }

    public DocumentCollectionType createRoutingSlips(DocumentCollectionType documentCollection, boolean start) throws GdfServiceException {
        try {
            String results = this.stub.createRoutingSlips(documentCollection.toXMLString(), start);
            StringReader reader = new StringReader(results);
            return DocumentCollectionType.unmarshalDocumentCollectionType((Reader)reader);
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public String[] createTasks(EntityCollectionType tasks) throws GdfServiceException {
        try {
            String results = this.stub.createTasks(tasks.toXMLString());
            return ArrayUtils.deserializeStringArray(results);
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public EntityCollectionType getTaskInitiationData(String associatedId) throws GdfServiceException {
        try {
            String results = this.stub.getTaskInitiationData(associatedId);
            StringReader reader = new StringReader(results);
            return EntityCollectionType.unmarshalEntityCollectionType((Reader)reader);
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public InlineMetaDataCollectionType getWorkflowDefinitions() throws GdfServiceException {
        try {
            String results = this.stub.getWorkflowDefinitions();
            StringReader reader = new StringReader(results);
            return InlineMetaDataCollectionType.unmarshalInlineMetaDataCollectionType((Reader)reader);
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public void rejectReview(RoutingSlipType routingSlipType, String comment) throws GdfServiceException {
        try {
            this.stub.rejectReview(routingSlipType.toXMLString(), comment);
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public RoutingSlipType startCreatedRoutingSlip(RoutingSlipType routingForm, String parentID) throws GdfServiceException {
        try {
            String results = this.stub.startCreatedRoutingSlip(routingForm.toXMLString(), parentID);
            StringReader reader = new StringReader(results);
            return (RoutingSlipType)RoutingSlipType.unmarshalRoutingSlipType((Reader)reader);
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public PhaseType updatePhaseStep(PhaseType phaseType, String workflowID, String comment, String response, boolean completePhaseStep) throws GdfServiceException {
        try {
            String results = this.stub.updatePhaseStep(phaseType.toXMLString(), workflowID, comment, response, completePhaseStep);
            StringReader reader = new StringReader(results);
            return (PhaseType)PhaseType.unmarshalPhaseType((Reader)reader);
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public void updateRoutingSlips(DocumentCollectionType documentCollection) throws GdfServiceException {
        try {
            this.stub.updateRoutingSlips(documentCollection.toXMLString());
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public String[] updateTasks(EntityCollectionType tasks) throws GdfServiceException {
        try {
            String results = this.stub.updateTasks(tasks.toXMLString());
            return ArrayUtils.deserializeStringArray(results);
        }
        catch (Exception ex) {
            throw new GdfServiceException((Throwable)ex);
        }
    }

    public String[] createTaskTemplates(EntityCollectionType collection) throws GdfServiceException {
        throw new GdfServiceException("Method not supported");
    }

    public EntityCollectionType getTaskTemplateInitiationData(String data) throws GdfServiceException {
        throw new GdfServiceException("Method not supported");
    }

    public void startPhases(String arg0, String arg1) throws GdfServiceException {
        throw new GdfServiceException("Method not supported");
    }

    public void updatePhaseSteps(PhaseType arg0, String[] arg1) throws GdfServiceException {
        throw new GdfServiceException("Method not supported");
    }

    public String[] updateTaskTemplates(EntityCollectionType collectionType) throws GdfServiceException {
        throw new GdfServiceException("Method not supported");
    }

    static {
        URL url;
        qname = new QName("http://gopro/gdf/workflowservice/2009/02/02/", "WorkflowService");
        wsdlUrl = url = WorkflowService.class.getResource("/META-INF/wsdl/WorkflowService.wsdl");
    }
}

