/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.ws.proxy;

import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import net.gopro.gdf.data.BaseRefCollectionType;
import net.gopro.gdf.data.CredentialsBaseType;
import net.gopro.gdf.data.UserCredentialsType;
import net.gopro.gdf.data.UserPrincipal;
import net.gopro.gdf.data.UserPrivilegeCollectionType;
import net.gopro.gdf.exceptions.GdfServiceException;
import net.gopro.gdf.services.ISecurityService;
import net.gopro.gdf.ws.handlers.DominoAxisHandler;
import net.gopro.gdf.ws.handlers.LoggingHandler;
import net.gopro.gdf.ws.proxy.plain.security.SecurityService_Service;

public class SecurityService
implements ISecurityService {
    private static final QName qname;
    private SecurityService_Service proxy;
    private net.gopro.gdf.ws.proxy.plain.security.SecurityService stub;
    private boolean debug = false;
    private static final URL wsdlUrl;

    public SecurityService(String endpoint) {
        this.initializeService(endpoint, null, null);
    }

    private void initializeService(String endpoint, String username, String password) {
        this.proxy = new SecurityService_Service(wsdlUrl, qname);
        this.stub = this.proxy.getSecurityServiceSoap();
        ((BindingProvider)this.stub).getRequestContext().put("javax.xml.ws.service.endpoint.address", endpoint);
        ArrayList<Object> chain = new ArrayList<Object>();
        if (this.debug) {
            chain.add(new LoggingHandler());
        }
        if (endpoint.toLowerCase().contains(".nsf")) {
            chain.add(new DominoAxisHandler());
        }
        ((BindingProvider)this.stub).getBinding().setHandlerChain(chain);
    }

    public UserPrincipal authenticateUser(UserCredentialsType credentials) throws GdfServiceException {
        try {
            String result = this.stub.authenticateUser(credentials.toXMLString());
            UserPrincipal userPrincipal = null;
            if (result != null) {
                StringReader reader = new StringReader(result);
                userPrincipal = UserPrincipal.unmarshalUserPrincipal((Reader)reader);
            }
            return userPrincipal;
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public UserPrincipal authenticateUser(CredentialsBaseType credentialsBaseType) throws GdfServiceException {
        return this.authenticateUser((UserCredentialsType)credentialsBaseType);
    }

    public UserPrincipal authenticateUser(String username, String password) throws GdfServiceException {
        UserCredentialsType uct = new UserCredentialsType();
        uct.setUsername(username);
        uct.setPassword(password);
        return this.authenticateUser(uct);
    }

    public void closeUserSession(String sessionId) throws GdfServiceException {
        try {
            this.stub.closeUserSession(sessionId);
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public void setUserPassword(String oldPassword, String newPassword, String newPasswordConfirm) throws GdfServiceException {
        try {
            this.stub.setUserPassword(oldPassword, newPassword, newPasswordConfirm);
        }
        catch (Exception ex) {
            throw new GdfServiceException((Throwable)ex);
        }
    }

    public void hasAccess(UserPrivilegeCollectionType privileges) throws GdfServiceException {
        try {
            this.stub.hasAccess(privileges.toXMLString());
        }
        catch (Exception ex) {
            throw new GdfServiceException((Throwable)ex);
        }
    }

    public BaseRefCollectionType getUserNamesList(String userID) throws GdfServiceException {
        try {
            String results = this.stub.getUserNamesList(userID);
            StringReader reader = new StringReader(results);
            return BaseRefCollectionType.unmarshalBaseRefCollectionType((Reader)reader);
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public UserPrivilegeCollectionType getUserPrivileges(String userID) throws GdfServiceException {
        try {
            String results = this.stub.getUserPrivileges(userID);
            StringReader reader = new StringReader(results);
            return UserPrivilegeCollectionType.unmarshalUserPrivilegeCollectionType((Reader)reader);
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    static {
        URL url;
        qname = new QName("http://gopro/gdf/securityservice/2009/02/02/", "SecurityService");
        wsdlUrl = url = SecurityService.class.getResource("/META-INF/wsdl/SecurityService.wsdl");
    }
}

