/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.ws.proxy;

import java.net.URL;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import net.gopro.gdf.data.types.LicenceStatusType;
import net.gopro.gdf.exceptions.GdfServiceException;
import net.gopro.gdf.services.ILicenceService;
import net.gopro.gdf.ws.handlers.DominoAxisHandler;
import net.gopro.gdf.ws.handlers.LoggingHandler;
import net.gopro.gdf.ws.proxy.plain.license.LicenceService;
import net.gopro.gdf.ws.proxy.plain.license.LicenceService_Service;

public class LicenseService
implements ILicenceService {
    private static final QName qname;
    private LicenceService_Service proxy;
    private LicenceService stub;
    private boolean debug = false;
    private static final URL wsdlUrl;

    public LicenseService(String endpoint) {
        this.initializeService(endpoint, null, null);
    }

    private void initializeService(String endpoint, String username, String password) {
        this.proxy = new LicenceService_Service(wsdlUrl, qname);
        this.stub = this.proxy.getLicenceServiceSoap();
        ((BindingProvider)this.stub).getRequestContext().put("javax.xml.ws.service.endpoint.address", endpoint);
        ArrayList<Object> chain = new ArrayList<Object>();
        if (this.debug) {
            chain.add(new LoggingHandler());
        }
        if (endpoint.toLowerCase().contains(".nsf")) {
            chain.add(new DominoAxisHandler());
        }
        ((BindingProvider)this.stub).getBinding().setHandlerChain(chain);
    }

    public LicenceStatusType checkLicenceStatus(String moduleName) throws GdfServiceException {
        try {
            String result = this.stub.checkLicenceStatus(moduleName);
            return LicenceStatusType.valueOf((String)result);
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    static {
        URL url;
        qname = new QName("http://gopro/gdf/licenceservice/2009/02/02/", "LicenceService");
        wsdlUrl = url = LicenseService.class.getResource("/META-INF/wsdl/LicenceService.wsdl");
    }
}

