/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.ws.plain;

import java.io.Reader;
import java.io.StringReader;
import javax.annotation.Resource;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.servlet.ServletContext;
import javax.xml.ws.WebServiceContext;
import net.gopro.gdf.data.DocumentFilterType;
import net.gopro.gdf.data.EntityCollectionType;
import net.gopro.gdf.data.UserPrincipal;
import net.gopro.gdf.data.UserTagType;
import net.gopro.gdf.data.types.TagType;
import net.gopro.gdf.selfservice.ServiceFactory;
import net.gopro.gdf.services.plain.IUserDocumentService;
import net.gopro.gdf.ws.util.AuthenticationUtil;

@WebService(targetNamespace="http://gopro/gdf/userdocumentservice/2009/02/02/", serviceName="UserDocumentService", portName="UserDocumentServiceSoap")
@SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
public class UserDocumentService
implements IUserDocumentService {
    private static final String GDF_NS = "http://gopro/gdf/userdocumentservice/2009/02/02/";
    @Resource
    protected WebServiceContext wsContext;

    @WebMethod(operationName="addTaggedDocument", action="http://gopro/gdf/userdocumentservice/2009/02/02/addTaggedDocument")
    @WebResult(name="addTaggedDocumentResult", targetNamespace="http://gopro/gdf/userdocumentservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String addTaggedDocument(@WebParam(name="documentId", targetNamespace="http://gopro/gdf/userdocumentservice/2009/02/02/") String documentId, @WebParam(name="tagType", targetNamespace="http://gopro/gdf/userdocumentservice/2009/02/02/") String tagType) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            net.gopro.gdf.selfservice.UserDocumentService service = ServiceFactory.getUserDocumentService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            TagType tag = TagType.valueOf((String)tagType);
            UserTagType userTagType = service.addTaggedDocument(documentId, tag);
            return userTagType.toXMLString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="getTaggedDocuments", action="http://gopro/gdf/userdocumentservice/2009/02/02/getTaggedDocuments")
    @WebResult(name="getTaggedDocumentsResult", targetNamespace="http://gopro/gdf/userdocumentservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String getTaggedDocuments(@WebParam(name="tagType", targetNamespace="http://gopro/gdf/userdocumentservice/2009/02/02/") String tagType) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            net.gopro.gdf.selfservice.UserDocumentService service = ServiceFactory.getUserDocumentService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            TagType tag = TagType.valueOf((String)tagType);
            EntityCollectionType documents = service.getTaggedDocuments(tag);
            return documents.toXMLString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="removeTaggedDocument", action="http://gopro/gdf/userdocumentservice/2009/02/02/removeTaggedDocument")
    @WebResult(name="removeTaggedDocumentResult", targetNamespace="http://gopro/gdf/userdocumentservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public void removeTaggedDocument(@WebParam(name="documentId", targetNamespace="http://gopro/gdf/userdocumentservice/2009/02/02/") String documentId, @WebParam(name="tagType", targetNamespace="http://gopro/gdf/userdocumentservice/2009/02/02/") String tagType) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            net.gopro.gdf.selfservice.UserDocumentService service = ServiceFactory.getUserDocumentService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            TagType tag = TagType.valueOf((String)tagType);
            service.removeTaggedDocument(documentId, tag);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="getDocumentTags", action="http://gopro/gdf/userdocumentservice/2009/02/02/getDocumentTags")
    @WebResult(name="getDocumentTagsResult", targetNamespace="http://gopro/gdf/userdocumentservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String getDocumentTags(@WebParam(name="documentId", targetNamespace="http://gopro/gdf/userdocumentservice/2009/02/02/") String documentId) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            net.gopro.gdf.selfservice.UserDocumentService service = ServiceFactory.getUserDocumentService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            EntityCollectionType tags = service.getDocumentTags(documentId);
            return tags.toXMLString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="getPendingTasks", action="http://gopro/gdf/userdocumentservice/2009/02/02/getPendingTasks")
    @WebResult(name="getPendingTasksResult", targetNamespace="http://gopro/gdf/userdocumentservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String getPendingTasks(@WebParam(name="filter", targetNamespace="http://gopro/gdf/userdocumentservice/2009/02/02/") String filter) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            net.gopro.gdf.selfservice.UserDocumentService service = ServiceFactory.getUserDocumentService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            StringReader reader = new StringReader(filter);
            DocumentFilterType documentFilterType = (DocumentFilterType)DocumentFilterType.unmarshalDocumentFilterType((Reader)reader);
            EntityCollectionType collectionType = service.getPendingTasks(documentFilterType);
            return collectionType.toXMLString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="markNotificationRead", action="http://gopro/gdf/userdocumentservice/2009/02/02/markNotificationRead")
    @WebResult(name="markNotificationReadResult", targetNamespace="http://gopro/gdf/userdocumentservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public boolean markNotificationRead(@WebParam(name="notificationId", targetNamespace="http://gopro/gdf/userdocumentservice/2009/02/02/") String notificationId) {
        return false;
    }

    private final ServletContext getServletContext() {
        return (ServletContext)this.wsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.context");
    }
}

