/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.ws.plain;

import java.io.Reader;
import java.io.StringReader;
import javax.annotation.Resource;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.servlet.ServletContext;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.soap.MTOM;
import net.gopro.gdf.data.Chunk;
import net.gopro.gdf.data.DocumentBaseType;
import net.gopro.gdf.data.DocumentCollectionType;
import net.gopro.gdf.data.DocumentFilterType;
import net.gopro.gdf.data.EntityCollectionType;
import net.gopro.gdf.data.FileAttachmentType;
import net.gopro.gdf.data.FlexibleDataSetType;
import net.gopro.gdf.data.InlineMetaDataCollectionType;
import net.gopro.gdf.data.UserPrincipal;
import net.gopro.gdf.data.helpers.XMLTransformHelper;
import net.gopro.gdf.data.types.DocumentDownloadFormatType;
import net.gopro.gdf.data.types.DocumentStateType;
import net.gopro.gdf.selfservice.DocumentService;
import net.gopro.gdf.selfservice.ServiceFactory;
import net.gopro.gdf.services.plain.IBaseDocumentService;
import net.gopro.gdf.ws.util.ArrayUtils;
import net.gopro.gdf.ws.util.AuthenticationUtil;

@MTOM
@WebService(targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/", serviceName="BaseDocumentService", portName="BaseDocumentServiceSoap")
@SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
public class BaseDocumentService
implements IBaseDocumentService {
    private static final String GDF_NS = "http://gopro/gdf/basedocumentservice/2009/02/02/";
    @Resource
    protected WebServiceContext wsContext;

    @WebMethod(operationName="copyDocuments", action="http://gopro/gdf/basedocumentservice/2009/02/02/copyDocuments")
    @WebResult(name="copyDocumentsResult", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String copyDocuments(@WebParam(name="filter", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String filter, @WebParam(name="destinationId", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String destinationId) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            DocumentService service = ServiceFactory.getDocumentService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            StringReader reader = new StringReader(filter);
            DocumentFilterType documentFilterType = (DocumentFilterType)DocumentFilterType.unmarshalDocumentFilterType((Reader)reader);
            String[] result = service.copyDocuments(documentFilterType, destinationId);
            return ArrayUtils.convertStringArrayToString(result);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="createDocuments", action="http://gopro/gdf/basedocumentservice/2009/02/02/createDocuments")
    @WebResult(name="createDocumentsResult", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String createDocuments(@WebParam(name="documentCollection", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String documentCollection) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            DocumentService service = ServiceFactory.getDocumentService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            StringReader reader = new StringReader(documentCollection);
            DocumentCollectionType documentCollectionType = DocumentCollectionType.unmarshalDocumentCollectionType((Reader)reader);
            String[] result = service.createDocuments(documentCollectionType);
            return ArrayUtils.convertStringArrayToString(result);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @WebMethod(operationName="deleteDocuments", action="http://gopro/gdf/basedocumentservice/2009/02/02/deleteDocuments")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public void deleteDocuments(@WebParam(name="filter", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String filter) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            DocumentService service = ServiceFactory.getDocumentService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            StringReader reader = new StringReader(filter);
            DocumentFilterType documentFilterType = (DocumentFilterType)DocumentFilterType.unmarshalDocumentFilterType((Reader)reader);
            service.deleteDocuments(documentFilterType);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="destroyDocuments", action="http://gopro/gdf/basedocumentservice/2009/02/02/destroyDocuments")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public void destroyDocuments(@WebParam(name="filter", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String filter) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            DocumentService service = ServiceFactory.getDocumentService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            StringReader reader = new StringReader(filter);
            DocumentFilterType documentFilterType = (DocumentFilterType)DocumentFilterType.unmarshalDocumentFilterType((Reader)reader);
            service.destroyDocuments(documentFilterType);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="getChunk", action="http://gopro/gdf/basedocumentservice/2009/02/02/getChunk")
    @WebResult(name="getChunkResult", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public byte[] getChunk(@WebParam(name="id", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") long id, @WebParam(name="chunkNumber", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") int chunkNumber, @WebParam(name="chunkSize", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") int chunkSize) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            DocumentService service = ServiceFactory.getDocumentService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            Chunk chunk = service.getChunk(id, chunkNumber, chunkSize);
            return chunk.getData();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="getReadOnlyFormats", action="http://gopro/gdf/basedocumentservice/2009/02/02/getReadOnlyFormats")
    @WebResult(name="getReadOnlyFormatsResult", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String getReadOnlyFormats(@WebParam(name="documentIds", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String documentIds) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            DocumentService service = ServiceFactory.getDocumentService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            String[] documentIdList = ArrayUtils.convertStringToStringArray(documentIds);
            FileAttachmentType[] files = service.getReadOnlyFormats(documentIdList);
            StringBuffer sb = new StringBuffer();
            for (FileAttachmentType file : files) {
                sb.append(file.toXMLString());
            }
            return sb.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="moveDocuments", action="http://gopro/gdf/basedocumentservice/2009/02/02/moveDocuments")
    @WebResult(name="moveDocumentsResult", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String moveDocuments(@WebParam(name="filter", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String filter, @WebParam(name="destinationId", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String destinationId) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            DocumentService service = ServiceFactory.getDocumentService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            StringReader reader = new StringReader(filter);
            DocumentFilterType documentFilterType = (DocumentFilterType)DocumentFilterType.unmarshalDocumentFilterType((Reader)reader);
            String[] results = service.moveDocuments(documentFilterType, destinationId);
            return ArrayUtils.convertStringArrayToString(results);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="getDocumentHeaders", action="http://gopro/gdf/basedocumentservice/2009/02/02/getDocumentHeaders")
    @WebResult(name="getDocumentHeadersResult", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String getDocumentHeaders(@WebParam(name="filter", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String filter) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            DocumentService service = ServiceFactory.getDocumentService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            StringReader reader = new StringReader(filter);
            DocumentFilterType documentFilterType = (DocumentFilterType)DocumentFilterType.unmarshalDocumentFilterType((Reader)reader);
            FlexibleDataSetType results = service.getDocumentHeaders(documentFilterType);
            return results.toXMLString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="getDocumentRelatedData", action="http://gopro/gdf/basedocumentservice/2009/02/02/getDocumentRelatedData")
    @WebResult(name="getDocumentRelatedDataResult", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String getDocumentRelatedData(@WebParam(name="documentId", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String documentId, @WebParam(name="documentType", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") int documentType) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            DocumentService service = ServiceFactory.getDocumentService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            InlineMetaDataCollectionType results = service.getDocumentRelatedData(documentId, documentType);
            return results.toXMLString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="getDocumentVersion", action="http://gopro/gdf/basedocumentservice/2009/02/02/getDocumentVersion")
    @WebResult(name="getDocumentVersionResult", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String getDocumentVersion(@WebParam(name="filter", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String filter) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            DocumentService service = ServiceFactory.getDocumentService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            StringReader reader = new StringReader(filter);
            DocumentFilterType documentFilterType = (DocumentFilterType)DocumentFilterType.unmarshalDocumentFilterType((Reader)reader);
            DocumentBaseType results = service.getDocumentVersion(documentFilterType);
            return results.toXMLString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="getDocumentVersionList", action="http://gopro/gdf/basedocumentservice/2009/02/02/getDocumentVersionList")
    @WebResult(name="getDocumentVersionListResult", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String getDocumentVersionList(@WebParam(name="filter", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String filter) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            DocumentService service = ServiceFactory.getDocumentService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            StringReader reader = new StringReader(filter);
            DocumentFilterType documentFilterType = (DocumentFilterType)DocumentFilterType.unmarshalDocumentFilterType((Reader)reader);
            FlexibleDataSetType results = service.getDocumentVersionList(documentFilterType);
            return results.toXMLString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="getDocuments", action="http://gopro/gdf/basedocumentservice/2009/02/02/getDocuments")
    @WebResult(name="getDocumentsResult", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String getDocuments(@WebParam(name="filter", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String filter, @WebParam(name="documentStateSet", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String documentStateSet) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            DocumentService service = ServiceFactory.getDocumentService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            StringReader reader = new StringReader(filter);
            DocumentFilterType documentFilterType = (DocumentFilterType)DocumentFilterType.unmarshalDocumentFilterType((Reader)reader);
            DocumentStateType documentStateType = DocumentStateType.UNCHANGED;
            DocumentCollectionType result = service.getDocuments(documentFilterType, documentStateType);
            return result.toXMLString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="putChunk", action="http://gopro/gdf/basedocumentservice/2009/02/02/putChunk")
    @WebResult(name="putChunkResult", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public int putChunk(@WebParam(name="id", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") int id, @WebParam(name="data", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") byte[] data, @WebParam(name="chunkNumber", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") int chunkNumber, @WebParam(name="totalChunks", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") int totalChunks, @WebParam(name="transactionID", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") int transactionID) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            DocumentService service = ServiceFactory.getDocumentService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            Chunk chunk = new Chunk();
            chunk.setCRC((long)id);
            chunk.setChunksStackId((long)transactionID);
            chunk.setChunkNumber(chunkNumber);
            chunk.setChunksCount(totalChunks);
            chunk.setData(data);
            return (int)service.createChunk(chunk);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="restoreDocuments", action="http://gopro/gdf/basedocumentservice/2009/02/02/restoreDocuments")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public void restoreDocuments(@WebParam(name="filter", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String filter) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            DocumentService service = ServiceFactory.getDocumentService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            StringReader reader = new StringReader(filter);
            DocumentFilterType documentFilterType = (DocumentFilterType)DocumentFilterType.unmarshalDocumentFilterType((Reader)reader);
            service.restoreDocuments(documentFilterType);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @WebMethod(operationName="setDocumentsState", action="http://gopro/gdf/basedocumentservice/2009/02/02/setDocumentsState")
    @WebResult(name="setDocumentsStateResult", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String setDocumentsState(@WebParam(name="filter", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String filter, @WebParam(name="state", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String state) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            DocumentService service = ServiceFactory.getDocumentService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            StringReader reader = new StringReader(filter);
            DocumentFilterType documentFilterType = (DocumentFilterType)DocumentFilterType.unmarshalDocumentFilterType((Reader)reader);
            DocumentStateType documentStateType = DocumentStateType.valueOf((String)state);
            String[] results = service.setDocumentsState(documentFilterType, documentStateType);
            return ArrayUtils.convertStringArrayToString(results);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="updateDocumentFields", action="http://gopro/gdf/basedocumentservice/2009/02/02/updateDocumentFields")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public void updateDocumentFields(@WebParam(name="filter", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String filter, @WebParam(name="documentPattern", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String documentPattern, @WebParam(name="propertylist", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String propertylist) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            DocumentService service = ServiceFactory.getDocumentService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            StringReader reader = new StringReader(filter);
            DocumentFilterType documentFilterType = (DocumentFilterType)DocumentFilterType.unmarshalDocumentFilterType((Reader)reader);
            DocumentBaseType documentBaseType = (DocumentBaseType)XMLTransformHelper.toReferencableObject((String)documentPattern);
            String[] pList = ArrayUtils.convertStringToStringArray(propertylist);
            service.updateDocumentFields(documentFilterType, documentBaseType, pList);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="updateDocuments", action="http://gopro/gdf/basedocumentservice/2009/02/02/updateDocuments")
    @WebResult(name="updateDocumentsResult", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String updateDocuments(@WebParam(name="documentCollection", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String documentCollection, @WebParam(name="newVersion", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") boolean newVersion, @WebParam(name="documentStateSet", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String documentStateSet) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            DocumentService service = ServiceFactory.getDocumentService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            StringReader reader = new StringReader(documentCollection);
            DocumentCollectionType documentCollectionType = DocumentCollectionType.unmarshalDocumentCollectionType((Reader)reader);
            DocumentStateType documentStateType = DocumentStateType.valueOf((String)"UNCHANGED");
            String[] result = service.updateDocuments(documentCollectionType, newVersion, documentStateType);
            return ArrayUtils.convertStringArrayToString(result);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="getDocumentInitiationData", action="http://gopro/gdf/basedocumentservice/2009/02/02/getDocumentInitiationData")
    @WebResult(name="getDocumentInitiationDataResult", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String getDocumentInitiationData(@WebParam(name="parentId", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String parentId, @WebParam(name="documentType", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") int documentType, @WebParam(name="templateId", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String templateId) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            DocumentService service = ServiceFactory.getDocumentService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            DocumentCollectionType results = service.getDocumentInitiationData(parentId, documentType, templateId);
            return results.toXMLString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="createDocumentsCheckin", action="http://gopro/gdf/basedocumentservice/2009/02/02/createDocumentsCheckin")
    @WebResult(name="createDocumentsCheckinResult", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String createDocumentsCheckin(@WebParam(name="documentCollection", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String documentCollection, @WebParam(name="autoChecking", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") boolean autoCheckin) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            DocumentService service = ServiceFactory.getDocumentService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            StringReader reader = new StringReader(documentCollection);
            DocumentCollectionType documentCollectionType = DocumentCollectionType.unmarshalDocumentCollectionType((Reader)reader);
            String[] result = service.createDocumentsCheckin(documentCollectionType, autoCheckin);
            return ArrayUtils.convertStringArrayToString(result);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @WebMethod(operationName="getEntities", action="http://gopro/gdf/basedocumentservice/2009/02/02/getEntities")
    @WebResult(name="getEntitiesResult", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String getEntities(@WebParam(name="filter", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String filter) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            DocumentService service = ServiceFactory.getDocumentService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            StringReader reader = new StringReader(filter);
            DocumentFilterType documentFilterType = (DocumentFilterType)DocumentFilterType.unmarshalDocumentFilterType((Reader)reader);
            EntityCollectionType results = service.getEntities(documentFilterType);
            return results.toXMLString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="getDownloadDocument", action="http://gopro/gdf/basedocumentservice/2009/02/02/getDownloadDocument")
    @WebResult(name="getDownloadDocumentResult", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String getDownloadDocument(@WebParam(name="documentId", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String documentId, @WebParam(name="format", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String format, @WebParam(name="attachmentId", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String attachmentId) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            DocumentService service = ServiceFactory.getDocumentService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            DocumentDownloadFormatType formatType = DocumentDownloadFormatType.valueOf((String)format);
            FileAttachmentType attachment = service.getDownloadDocument(documentId, formatType, attachmentId);
            return attachment.toXMLString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private final ServletContext getServletContext() {
        return (ServletContext)this.wsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.context");
    }

    @WebMethod(operationName="getDocumentEvents", action="http://gopro/gdf/basedocumentservice/2009/02/02/getDocumentEvents")
    @WebResult(name="getDocumentEventsResult", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String getDocumentEvents(@WebParam(name="ids", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") String ids, @WebParam(name="documentType", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") int documentType, @WebParam(name="start", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") int start, @WebParam(name="size", targetNamespace="http://gopro/gdf/basedocumentservice/2009/02/02/") int size) {
        return null;
    }
}

