/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.ws.handlers;

import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSProcessor;
import com.sun.xml.wss.XWSSProcessorFactory;
import com.sun.xml.wss.XWSSecurityException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import net.gopro.gdf.ws.handlers.UserNameTokenCallbackHandler;

public class UserNameTokenHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final String NS_URL = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static final String CONFIG = "META-INF/UserNameToken.xml";
    private XWSSProcessor processor = null;

    public UserNameTokenHandler(String username, String password) {
        InputStream config = null;
        try {
            config = this.getClass().getResourceAsStream("/META-INF/UserNameToken.xml");
            if (config == null) {
                config = new FileInputStream(new File(CONFIG));
            }
            XWSSProcessorFactory factory = XWSSProcessorFactory.newInstance();
            this.processor = factory.createProcessorForSecurityConfiguration(config, (CallbackHandler)new UserNameTokenCallbackHandler(username, password));
            config.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Set<QName> getHeaders() {
        QName securityHeader = new QName(NS_URL, "Security", "wsse");
        HashSet<QName> headers = new HashSet<QName>();
        headers.add(securityHeader);
        return headers;
    }

    public void close(MessageContext messageContext) {
    }

    public boolean handleFault(SOAPMessageContext messageContext) {
        return true;
    }

    public boolean handleMessage(SOAPMessageContext messageContext) {
        Boolean outMessageIndicator = (Boolean)messageContext.get((Object)"javax.xml.ws.handler.message.outbound");
        SOAPMessage message = messageContext.getMessage();
        if (outMessageIndicator.booleanValue()) {
            try {
                ProcessingContext context = this.processor.createProcessingContext(message);
                context.setSOAPMessage(message);
                SOAPMessage secureMsg = this.processor.secureOutboundMessage(context);
                messageContext.setMessage(secureMsg);
            }
            catch (XWSSecurityException ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return true;
    }
}

