/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.ws.handlers;

import com.sun.xml.wss.impl.callback.KeyStoreCallback;
import com.sun.xml.wss.impl.callback.PrivateKeyCallback;
import com.sun.xml.wss.impl.callback.SignatureKeyCallback;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

public class KeyStoreCallbackHandler
implements CallbackHandler {
    private String keyStoreURL;
    private String keyStorePassword;
    private String keyStoreType;
    private String certAlias = null;
    private InputStream keystoreStream = null;
    private KeyStore keyStore;

    public KeyStoreCallbackHandler(InputStream keystore, String keystorepass, String keystoretype, String certAlias) {
        try {
            this.keystoreStream = keystore;
            this.keyStoreType = keystoretype;
            this.keyStorePassword = keystorepass;
            this.certAlias = certAlias;
            this.initKeyStore();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public KeyStoreCallbackHandler() {
        try {
            this.keyStoreURL = "META-INF/keystore.jks";
            this.keyStoreType = "JKS";
            this.keyStorePassword = "changeit";
            this.initKeyStore();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            SignatureKeyCallback cb;
            if (callback instanceof KeyStoreCallback) {
                ((KeyStoreCallback)callback).setKeystore(this.keyStore);
                continue;
            }
            if (callback instanceof PrivateKeyCallback) {
                ((PrivateKeyCallback)callback).setKeystore(this.keyStore);
                ((PrivateKeyCallback)callback).setAlias(this.certAlias);
                try {
                    ((PrivateKeyCallback)callback).setKey((PrivateKey)this.keyStore.getKey(this.certAlias, this.keyStorePassword.toCharArray()));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            if (!(callback instanceof SignatureKeyCallback) || !((cb = (SignatureKeyCallback)callback).getRequest() instanceof SignatureKeyCallback.AliasPrivKeyCertRequest)) continue;
            SignatureKeyCallback.AliasPrivKeyCertRequest request = (SignatureKeyCallback.AliasPrivKeyCertRequest)cb.getRequest();
            if (this.certAlias == null) {
                this.certAlias = request.getAlias();
            }
            try {
                X509Certificate cert = (X509Certificate)this.keyStore.getCertificate(this.certAlias);
                request.setX509Certificate(cert);
                PrivateKey privKey = (PrivateKey)this.keyStore.getKey(this.certAlias, this.keyStorePassword.toCharArray());
                request.setPrivateKey(privKey);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    private void initKeyStore() throws IOException {
        try {
            this.keyStore = KeyStore.getInstance(this.keyStoreType);
            if (this.keystoreStream != null) {
                this.keyStore.load(this.keystoreStream, this.keyStorePassword.toCharArray());
                this.keystoreStream.close();
            } else {
                this.keyStore.load(new FileInputStream(this.keyStoreURL), this.keyStorePassword.toCharArray());
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

