/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.ws.handlers;

import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSProcessor;
import com.sun.xml.wss.XWSSProcessorFactory;
import com.sun.xml.wss.XWSSecurityException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import net.gopro.gdf.ws.handlers.CertStoreCallbackHandler;
import net.gopro.gdf.ws.handlers.KeyStoreCallbackHandler;

public class CertStoreHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final String CONFIG = "META-INF/X509Token.xml";
    private XWSSProcessor processor = null;

    public CertStoreHandler(InputStream keystore, String keystorepass, String keystoretype, String certAlias) {
        InputStream config = null;
        try {
            config = this.getClass().getResourceAsStream("/META-INF/X509Token.xml");
            XWSSProcessorFactory factory = XWSSProcessorFactory.newInstance();
            this.processor = factory.createProcessorForSecurityConfiguration(config, (CallbackHandler)new KeyStoreCallbackHandler(keystore, keystorepass, keystoretype, certAlias));
            config.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public CertStoreHandler() {
        InputStream config = null;
        try {
            config = this.getClass().getResourceAsStream("/META-INF/X509Token.xml");
            XWSSProcessorFactory factory = XWSSProcessorFactory.newInstance();
            this.processor = factory.createProcessorForSecurityConfiguration(config, (CallbackHandler)new KeyStoreCallbackHandler());
            config.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public CertStoreHandler(X509Certificate certificate, PrivateKey privateKey) {
        InputStream config = null;
        try {
            config = this.getClass().getResourceAsStream("/META-INF/X509Token.xml");
            XWSSProcessorFactory factory = XWSSProcessorFactory.newInstance();
            this.processor = factory.createProcessorForSecurityConfiguration(config, (CallbackHandler)new CertStoreCallbackHandler(privateKey, certificate));
            config.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public Set<QName> getHeaders() {
        HashSet<QName> headers = new HashSet<QName>();
        return headers;
    }

    public void close(MessageContext messageContext) {
    }

    public boolean handleFault(SOAPMessageContext messageContext) {
        return true;
    }

    public boolean handleMessage(SOAPMessageContext messageContext) {
        Boolean outMessageIndicator = (Boolean)messageContext.get((Object)"javax.xml.ws.handler.message.outbound");
        SOAPMessage message = messageContext.getMessage();
        if (outMessageIndicator.booleanValue()) {
            try {
                ProcessingContext context = this.processor.createProcessingContext(message);
                context.setSOAPMessage(message);
                SOAPMessage secureMsg = this.processor.secureOutboundMessage(context);
                messageContext.setMessage(secureMsg);
            }
            catch (XWSSecurityException ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return true;
    }
}

