/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.thread;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import is.hugvit.thread.ThreadContext;
import is.hugvit.thread.ThreadManager;
import is.hugvit.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.StringTokenizer;
import org.dom4j.Element;

public final class WebThreadList
extends WebElementBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doGet(WebContext context) throws BirdException {
        try {
            Connection dc = (Connection)context.getAttribute("bird.connection");
            Element root = context.getRootElement().addElement("bird_view");
            String table = "bird_thread";
            String fields = "name,server,enabled,id,lastrun";
            PreparedStatement stmt = dc.prepareStatement("select " + fields + " from " + table + " order by name");
            ResultSet rd = stmt.executeQuery();
            try {
                while (rd.next()) {
                    int i = 1;
                    StringTokenizer e = new StringTokenizer(fields, ",");
                    String name = null;
                    Element item = root.addElement(table);
                    while (e.hasMoreElements()) {
                        String n = (String)e.nextElement();
                        Object obj = rd.getObject(i++);
                        String v = null;
                        if (obj instanceof Date) {
                            Date d = (Date)obj;
                            obj = Util.dateTimeToShort((Date)d);
                        }
                        if (obj != null && !(v = obj.toString()).equals("")) {
                            item.addElement(n).addText(v);
                        }
                        if (!n.equals("name")) continue;
                        name = v;
                    }
                    ThreadContext tc = ThreadManager.getContextByName(name);
                    if (tc == null) continue;
                    item.addElement("isrunning").addText(tc.isRunning() ? "1" : "0");
                }
            }
            finally {
                rd.close();
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new BirdException((Exception)e);
        }
    }
}

