/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.thread;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.core.BirdUtil;
import is.hugvit.bird.core.WebBirdForm;
import is.hugvit.bird.gdr.Install;
import is.hugvit.thread.ThreadContext;
import is.hugvit.thread.ThreadManager;
import is.hugvit.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import net.gopro.gdr.Reader;
import net.gopro.gdr.Router;
import org.dom4j.Element;

public final class WebThread
extends WebBirdForm {
    public WebThread() {
        this.setTable("bird_thread");
        this.setRedirect("bird:threadlist");
        this.add(new Field("name", true));
        this.add(new Field("classname"));
        this.add(new Field("type"));
        this.add(new Field("datapump"));
        this.add(new Field("run"));
        this.add(new Field("loglevel"));
        this.add(new Field("email"));
        this.add(new Field("sms"));
        this.add(new Field("parameters"));
        this.add(new Field("enabled", 2));
        this.add(new Field("mailserver"));
        this.add(new Field("logconsole", 2));
        this.add(new Field("mailresult", 2));
        this.add(new Field("start", 3));
        this.add(new Field("startdate", 4));
        this.add(new Field("enddate", 4));
        this.add(new Field("hours", 1));
        this.add(new Field("minutes", 1));
        this.add(new Field("seconds", 1));
        this.add(new Field("day", 1));
    }

    public final void doDelete(WebContext context, Form data) throws BirdException {
        super.doDelete(context, data);
        ThreadManager.refresh();
    }

    public final void doAction(WebContext context, Form data) throws BirdException {
        block7: {
            try {
                String action = data.getAction();
                if (!action.equals("run") && !action.equals("stop")) break block7;
                Connection dc = (Connection)context.getAttribute("bird.connection");
                PreparedStatement stmt = dc.prepareStatement("select name from bird_thread where id=?");
                stmt.setString(1, data.getID());
                ResultSet rs = stmt.executeQuery();
                String name = "";
                if (rs.next()) {
                    name = rs.getString(1);
                }
                ThreadContext tc = ThreadManager.getContextByName((String)name);
                if (action.equals("run")) {
                    tc.start();
                } else {
                    tc.stop();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                context.setRedirectPage(this.redirect);
            }
            catch (SQLException e) {
                throw new BirdException((Exception)e);
            }
        }
    }

    protected void doXML(WebContext context, Form data) throws BirdException {
        Element root = context.getRootElement();
        super.doXML(context, data);
        try {
            Hashtable<String, String> h = new Hashtable<String, String>();
            h.put("type", "DATAPUMP");
            BirdUtil.view_generateXML((WebContext)context, (String)"name", (String)"bird_datapump", h);
        }
        catch (BirdException e) {
            // empty catch block
        }
        Element r = root.addElement("days");
        String[] days = Util.getWeekdays();
        for (int i = 0; i < days.length; ++i) {
            r.addElement("name").addText(days[i]);
        }
        r = root.addElement("bird_reader");
        boolean found = false;
        try {
            Class.forName("is.hugvit.bird.gdr.Install");
            found = true;
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (found) {
            for (Router router : Install.getRouters()) {
                for (Reader reader : router.getReaders().getReaderList()) {
                    Element r2 = r.addElement("bird_reader");
                    r2.addElement("name").addText(router.getName() + ':' + reader.getName());
                }
            }
        }
    }

    public final boolean querySave(WebContext context, Form data) throws BirdException {
        if (!super.querySave(context, data)) {
            return false;
        }
        String type = data.getString("type");
        String classname = data.getString("classname");
        try {
            if (type.equals("CUSTOM")) {
                Class.forName(classname).newInstance();
            }
        }
        catch (Exception e) {
            data.setError("classname");
            return false;
        }
        return true;
    }

    public final void doSave(WebContext context, Form data) throws BirdException {
        String type = data.getString("type");
        if (type.equals("READER")) {
            data.put("datapump", data.getString("reader"));
        }
        data.remove("reader");
        super.doSave(context, data);
        ThreadManager.refresh();
    }

    public final boolean queryOpen(WebContext context, Form data) throws BirdException {
        super.queryOpen(context, data);
        if (data.isCreate()) {
            data.put("enabled", "1");
            data.put("logconsole", "1");
            data.put("minutes", 10);
            data.put("start", (Object)Util.getTime((int)2, (int)0));
            data.put("loglevel", "1");
            data.put("type", "DATAPUMP");
        }
        return true;
    }
}

