/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.thread;

import is.hugvit.bird.BirdDatabase;
import is.hugvit.thread.ThreadData;
import is.hugvit.thread.ThreadDataStore;
import is.hugvit.util.PropertiesEx;
import is.hugvit.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;

final class ThreadDataStoreImpl
implements ThreadDataStore {
    private BirdDatabase ds;
    private static final int MAX_LOG_SIZE = 32768;

    ThreadDataStoreImpl(BirdDatabase ds) {
        this.ds = ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Vector getThreads() throws Exception {
        Vector<ThreadData> v = new Vector<ThreadData>();
        Connection dc = this.ds.connect();
        try {
            PreparedStatement stmt = dc.prepareStatement("select name,classname,enabled,run,start,seconds,minutes,hours,loglevel,logconsole,sms,email,parameters,type,datapump,mailserver,mailresult,day from bird_thread");
            ResultSet rd = stmt.executeQuery();
            try {
                while (rd.next()) {
                    ThreadData item = new ThreadData();
                    item.setName(rd.getString(1));
                    item.setClassName(rd.getString(2));
                    item.setEnabled(rd.getString(3).equals("1"));
                    item.setRun(rd.getString(4));
                    item.setStartTime((Date)rd.getTime(5));
                    long ms = rd.getInt(6) * 1000;
                    ms += (long)(rd.getInt(7) * 60 * 1000);
                    item.setTime(ms += (long)(rd.getInt(8) * 60 * 60 * 1000));
                    item.setLogLevel(rd.getInt(9));
                    item.setLogConsole(rd.getString(10).equals("1"));
                    item.setSMS(rd.getString(11));
                    item.setEmail(Util.split((String)rd.getString(12), (String)"\r\n"));
                    PropertiesEx p = new PropertiesEx(rd.getString(13));
                    item.setProperties((Properties)p);
                    String type = rd.getString(14);
                    String datapump = rd.getString(15);
                    if (datapump == null) {
                        datapump = "";
                    }
                    if (type.equals("DATAPUMP")) {
                        item.setClassName("is.hugvit.bird.datapump.DataPump");
                        p.put("name", datapump);
                        item.setProperties((Properties)p);
                    } else if (type.equals("READER")) {
                        item.setClassName("is.hugvit.bird.gdr.ReaderThread");
                        p.put("name", datapump);
                        item.setProperties((Properties)p);
                    }
                    item.setMailServer(rd.getString(16));
                    String mr = rd.getString(17);
                    if (mr == null) {
                        mr = "";
                    }
                    item.setMailResult(mr.equals("1"));
                    item.setDay(rd.getInt(18));
                    v.addElement(item);
                }
            }
            finally {
                rd.close();
                stmt.close();
            }
        }
        finally {
            dc.close();
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLastRun(String name, Date date) throws Exception {
        Connection dc = this.ds.connect();
        try {
            PreparedStatement stmt = dc.prepareStatement("update bird_thread set lastrun=? where name=?");
            stmt.setTimestamp(1, new Timestamp(date.getTime()));
            stmt.setString(2, name);
            stmt.executeUpdate();
            stmt.close();
        }
        finally {
            dc.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void appendLog(String name, String log) throws Exception {
        Connection dc = this.ds.connect();
        try {
            String s = "";
            PreparedStatement stmt = dc.prepareStatement("select log from bird_thread where name=?");
            stmt.setString(1, name);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                s = rs.getString(1);
            }
            if ((s = s + log).length() > 32768) {
                while (s.length() > 32768) {
                    int p = s.indexOf(10);
                    s = s.substring(p + 1);
                }
            }
            rs.close();
            stmt.close();
            stmt = dc.prepareStatement("update bird_thread set log=? where name=?");
            stmt.setString(1, s);
            stmt.setString(2, name);
            stmt.executeUpdate();
            stmt.close();
        }
        finally {
            dc.close();
        }
    }
}

