/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.thread;

import is.hugvit.bird.BirdComponentBase;
import is.hugvit.bird.BirdDatabase;
import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdPageType;
import is.hugvit.bird.BirdSession;
import is.hugvit.bird.core.BirdInstallHelper;
import is.hugvit.bird.core.BirdUtil;
import is.hugvit.bird.thread.ThreadDataStoreImpl;
import is.hugvit.bird.thread.WebLang;
import is.hugvit.bird.thread.WebLog;
import is.hugvit.bird.thread.WebThread;
import is.hugvit.bird.thread.WebThreadList;
import is.hugvit.thread.ThreadDataStore;
import is.hugvit.thread.ThreadManager;
import is.hugvit.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public final class Install
extends BirdComponentBase {
    private static final Properties p = new Properties();
    static ResourceBundle lang;

    public Properties getInfo() {
        return p;
    }

    public final void install(BirdSession context) throws BirdException {
        Document doc;
        lang = ResourceBundle.getBundle("is.hugvit.bird.thread.bird_thread", context.getLocale());
        BirdDatabase db = context.getDatabase();
        try {
            BirdPageType h = new Hashtable();
            try {
                h.put("id", "VARCHAR(64)");
                h.put("name", "VARCHAR(255)");
                h.put("server", "VARCHAR(255)");
                h.put("parameters", "LONG VARCHAR");
                h.put("type", "VARCHAR(50)");
                h.put("datapump", "VARCHAR(255)");
                h.put("classname", "VARCHAR(255)");
                h.put("enabled", "CHAR(1)");
                h.put("run", "VARCHAR(20)");
                h.put("start", "TIME");
                h.put("startdate", "DATE");
                h.put("enddate", "DATE");
                h.put("seconds", "INTEGER");
                h.put("minutes", "INTEGER");
                h.put("hours", "INTEGER");
                h.put("day", "INTEGER");
                h.put("loglevel", "CHAR(1)");
                h.put("logconsole", "CHAR(1)");
                h.put("email", "VARCHAR(100)");
                h.put("sms", "VARCHAR(50)");
                h.put("log", "CLOB");
                h.put("lastrun", "TIMESTAMP");
                h.put("mailserver", "VARCHAR(100)");
                h.put("mailresult", "CHAR(1)");
                h.put("modified", "TIMESTAMP");
                h.put("modified_by", "VARCHAR(100)");
                db.createTable("bird_thread", (Hashtable)h);
            }
            catch (BirdException e) {
                // empty catch block
            }
            h = db.createPageType();
            h.put("isprivate", (Object)"1");
            h.put("name", (Object)"bird:thread");
            h.put("elements", (Object)"bird:thread_lang");
            h.put("head", (Object)Util.getResourceString((Object)((Object)this), (String)"files/pagetype_head.html"));
            h.put("body", (Object)Util.getResourceString((Object)((Object)this), (String)"files/pagetype_body.html"));
            h.save();
            h = db.createElement();
            h.put("name", (Object)"bird:threadlist");
            h.put("classname", (Object)WebThreadList.class.getName());
            h.put("isprivate", (Object)"1");
            h.save();
            h.put("name", (Object)"bird:thread");
            h.put("classname", (Object)WebThread.class.getName());
            h.save();
            h.put("name", (Object)"bird:thread_lang");
            h.put("classname", (Object)WebLang.class.getName());
            h.save();
            h.put("name", (Object)"bird:log");
            h.put("classname", (Object)WebLog.class.getName());
            h.save();
            h = db.createFile();
            String filename = "thread.js";
            h.put("name", (Object)"bird/thread");
            h.put("filename", (Object)filename);
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("files/" + filename);
            h.put("body", (Object)in);
            h.put("isprivate", (Object)"1");
            h.save();
            in.close();
            h = db.createFile();
            filename = "kicked.gif";
            h.put("name", (Object)"bird/kicked");
            h.put("filename", (Object)filename);
            in = ((Object)((Object)this)).getClass().getResourceAsStream("images/" + filename);
            h.put("body", (Object)in);
            h.put("isprivate", (Object)"1");
            h.save();
            in.close();
            h = db.createPage();
            h.put("isprivate", (Object)"1");
            h.put("name", (Object)"admin/bird_threads.html");
            h.put("alias", (Object)"bird:threadlist");
            h.put("elements", (Object)"bird:threadlist");
            h.put("title", (Object)"Schedule Manager");
            h.put("pagetype", (Object)"bird:thread");
            h.put("body", (Object)this.getFileContents("threads.html"));
            h.save();
            h = db.createPage();
            h.put("isprivate", (Object)"1");
            h.put("name", (Object)"admin/bird_thread.html");
            h.put("alias", (Object)"bird:thread");
            h.put("elements", (Object)"bird:thread");
            h.put("title", (Object)"Thread");
            h.put("pagetype", (Object)"bird:thread");
            h.put("body", (Object)this.getFileContents("thread.html"));
            h.save();
            h = db.createPage();
            h.put("isprivate", (Object)"1");
            h.put("name", (Object)"admin/bird_log.html");
            h.put("alias", (Object)"bird:log");
            h.put("elements", (Object)"bird:log");
            h.put("title", (Object)"Log");
            h.put("pagetype", (Object)"bird:thread");
            h.put("body", (Object)this.getFileContents("log.html"));
            h.save();
        }
        catch (IOException e) {
            throw new BirdException((Exception)e);
        }
        InputStream is = null;
        try {
            is = ((Object)((Object)this)).getClass().getResourceAsStream("install.xml");
            SAXReader reader = new SAXReader();
            doc = reader.read(is);
        }
        catch (Exception ex) {
            throw new BirdException("Could not read the install.xml", ex);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ex) {
                throw new BirdException(ex);
            }
        }
        BirdInstallHelper helper = new BirdInstallHelper(doc, lang, (Object)this);
        helper.Install(context, db);
    }

    public final void start(BirdSession context) throws BirdException {
        lang = ResourceBundle.getBundle("is.hugvit.bird.thread.bird_thread", context.getLocale());
        ThreadDataStoreImpl ds = new ThreadDataStoreImpl(context.getDatabase());
        ThreadManager.setDataStore((ThreadDataStore)ds);
        ThreadManager.start();
    }

    public final void stop(BirdSession context) throws BirdException {
        ThreadManager.stop();
    }

    public final void refresh(BirdSession context) throws BirdException {
        ThreadManager.refresh();
    }

    public final void uninstall(BirdSession context) throws BirdException {
        BirdDatabase dc = context.getDatabase();
        BirdUtil.deleteElement((BirdDatabase)dc, (String)"bird:threadlist");
        BirdUtil.deleteElement((BirdDatabase)dc, (String)"bird:thread");
        BirdUtil.deleteElement((BirdDatabase)dc, (String)"bird:log");
        BirdUtil.deleteElement((BirdDatabase)dc, (String)"bird:thread_lang");
        BirdUtil.deletePage((BirdDatabase)dc, (String)"bird:thread");
        BirdUtil.deletePage((BirdDatabase)dc, (String)"bird:threadlist");
        BirdUtil.deletePage((BirdDatabase)dc, (String)"bird:log");
        BirdUtil.deletePageType((BirdDatabase)dc, (String)"bird:thread");
        BirdUtil.deleteFile((BirdDatabase)dc, (String)"bird/thread");
        BirdUtil.deleteFile((BirdDatabase)dc, (String)"bird/kicked");
        BirdUtil.deleteMenu((BirdDatabase)dc, (String)"bird:threads");
    }

    private final String getFileContents(String name) throws BirdException {
        StringWriter out = new StringWriter();
        try {
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("files/" + name);
            int i = in.read();
            while (i != -1) {
                out.write((char)i);
                i = in.read();
            }
            in.close();
            return out.toString();
        }
        catch (IOException e) {
            throw new BirdException((Exception)e);
        }
    }

    static {
        p.put("name", "Bird:Schedule Manager");
        p.put("version", "1.2.0");
    }
}

