/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.gdr;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import is.hugvit.bird.gdr.Install;
import is.hugvit.net.QueryString;
import is.hugvit.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import net.gopro.gdr.Router;
import org.dom4j.Element;

public final class WebRouters
extends WebElementBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doGet(WebContext context) throws BirdException {
        try {
            HttpServletRequest req = context.getRequest();
            QueryString qs = new QueryString(req.getQueryString());
            if (qs.contains("delete")) {
                String name = qs.get("name");
                Install.deleteRouter(name);
                context.setRedirectPage("gdr:routers");
                return;
            }
            Element r = context.getRootElement().addElement("gdr_routers");
            for (Router router : Install.getRouters()) {
                Element e = r.addElement("router");
                e.addElement("name").addText(router.getName());
                e.addElement("name_encoded").addText(URLEncoder.encode((String)router.getName()));
                e.addElement("type").addText("router");
            }
            Connection c = context.connect();
            try {
                PreparedStatement stmt = c.prepareStatement("select name,id from bird_datapump where type='DATAPUMP'");
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    String name = rs.getString(1);
                    String id = rs.getString(2);
                    Element e = r.addElement("router");
                    e.addElement("name").addText(name);
                    e.addElement("name_encoded").addText(URLEncoder.encode((String)name));
                    e.addElement("type").addText("datapump");
                    e.addElement("id").addText(id);
                }
                rs.close();
                stmt.close();
            }
            finally {
                c.close();
            }
        }
        catch (SQLException e) {
            throw new BirdException((Exception)e);
        }
    }
}

