/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.gdr;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebForm;
import is.hugvit.bird.gdr.Install;
import is.hugvit.net.URLDecoder;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import net.gopro.gdr.Parameter;
import net.gopro.gdr.Parameters;
import net.gopro.gdr.Router;
import org.dom4j.Element;

public final class WebRouterEdit
extends WebForm {
    public WebRouterEdit() {
        this.add(new Field("name", true));
    }

    protected void doXML(WebContext context, Form data) throws BirdException {
        super.doXML(context, data);
        Element eroot = context.getRootElement().addElement("gdr_parameters");
        Enumeration e = Router.getKnownParameters().elements();
        while (e.hasMoreElements()) {
            Parameter p = (Parameter)e.nextElement();
            Element ep = eroot.addElement("parameter");
            ep.addElement("name").addText(p.getName());
            ep.addElement("description").addText(p.getDescription());
        }
    }

    public final boolean queryOpen(WebContext context, Form data) throws BirdException {
        HttpServletRequest req = context.getRequest();
        String rname = req.getParameter("rname");
        Router router = Install.getRouterByName(rname);
        Parameters pm = router.getParameters();
        data.put("router", rname);
        if (data.isEdit()) {
            String name = data.getID();
            Object value = pm.get((Object)name);
            data.put("name", name);
            data.put("value", value.toString());
            data.put("description", "custom value");
            Enumeration e = Router.getKnownParameters().elements();
            while (e.hasMoreElements()) {
                Parameter p = (Parameter)e.nextElement();
                if (!name.equals(p.getName())) continue;
                data.put("description", p.getDescription());
                break;
            }
        }
        return true;
    }

    public final void doDelete(WebContext context, Form data) throws BirdException {
        try {
            HttpServletRequest req = context.getRequest();
            String rname = req.getParameter("rname");
            Router router = Install.getRouterByName(rname);
            router.removeParameter(data.getID());
            router.save();
            context.setRedirectPage("gdr:router", "name=" + URLDecoder.decode((String)rname));
        }
        catch (Exception e) {
            throw new BirdException(e);
        }
    }

    public final void doAction(WebContext context, Form data) throws BirdException {
        try {
            if (data.getAction().equals("reload")) {
                HttpServletRequest req = context.getRequest();
                String rname = req.getParameter("rname");
                context.setRedirectPage("gdr:editrouter", "rname=" + URLDecoder.decode((String)rname));
            }
        }
        catch (Exception e) {
            throw new BirdException(e);
        }
    }

    public final void doSave(WebContext context, Form data) throws BirdException {
        try {
            String rname = data.getString("router");
            Router router = Install.getRouterByName(rname);
            String name = data.getString("name");
            String customname = data.getString("customname");
            String value = data.getString("value");
            if (!customname.equals("")) {
                name = customname;
            }
            router.setParameter(name, value);
            router.save();
            context.setRedirectPage("gdr:router", "name=" + URLDecoder.decode((String)rname));
        }
        catch (Exception e) {
            throw new BirdException(e);
        }
    }
}

