/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.gdr;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebForm;
import is.hugvit.bird.gdr.Install;
import is.hugvit.net.QueryString;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import net.gopro.gdr.IO;
import net.gopro.gdr.Parameter;
import net.gopro.gdr.Parameters;
import net.gopro.gdr.Router;
import org.dom4j.Element;

public final class WebParam
extends WebForm {
    private static final IO getIO(Router router, String name, String type) {
        if (type.equals("reader")) {
            return router.getReaders().getReaderByName(name);
        }
        return router.getWriters().getWriterByName(name);
    }

    protected void doXML(WebContext context, Form data) throws BirdException {
        super.doXML(context, data);
        HttpServletRequest req = context.getRequest();
        String rname = req.getParameter("rname");
        Router router = Install.getRouterByName(rname);
        String parent = req.getParameter("parent");
        String type = req.getParameter("type");
        Element eroot = context.getRootElement().addElement("gdr_parameters");
        Enumeration e = type.equals("reader") ? router.getReaders().getReaderByName(parent).getKnownParameters().elements() : router.getWriters().getWriterByName(parent).getKnownParameters().elements();
        while (e.hasMoreElements()) {
            Parameter p = (Parameter)e.nextElement();
            Element ep = eroot.addElement("parameter");
            ep.addElement("name").addText(p.getName());
            ep.addElement("description").addText(p.getDescription());
        }
    }

    public final boolean queryOpen(WebContext context, Form data) throws BirdException {
        HttpServletRequest req = context.getRequest();
        String rname = req.getParameter("rname");
        Router router = Install.getRouterByName(rname);
        String parent = req.getParameter("parent");
        String type = req.getParameter("type");
        data.put("parent", parent);
        data.put("type", type);
        data.put("rname", rname);
        if (data.isEdit()) {
            String name = req.getParameter("name");
            data.put("name", name);
            IO io = WebParam.getIO(router, parent, type);
            data.put("value", io.getParameters().getString((Object)name));
            Hashtable h = type.equals("reader") ? router.getReaders().getReaderByName(parent).getKnownParameters() : router.getWriters().getWriterByName(parent).getKnownParameters();
            Parameter p = (Parameter)h.get(name);
            if (p != null) {
                data.put("description", p.getDescription());
            }
        }
        return true;
    }

    public final void doDelete(WebContext context, Form data) throws BirdException {
        try {
            HttpServletRequest req = context.getRequest();
            String rname = req.getParameter("rname");
            Router router = Install.getRouterByName(rname);
            String parent = req.getParameter("parent");
            String type = req.getParameter("type");
            String name = req.getParameter("name");
            Parameters p = null;
            p = type.equals("reader") ? router.getReaders().getReaderByName(parent).getParameters() : router.getWriters().getWriterByName(parent).getParameters();
            p.remove(name);
            router.save();
            QueryString qs = new QueryString();
            qs.put("name", parent);
            qs.put("rname", rname);
            context.setRedirectPage("gdr:" + type + "edit", qs.toString());
        }
        catch (Exception e) {
            throw new BirdException(e);
        }
    }

    public final void doSave(WebContext context, Form data) throws BirdException {
        try {
            String rname = data.getString("rname");
            Router router = Install.getRouterByName(rname);
            String parent = data.getString("parent");
            String name = data.getString("name");
            String customname = data.getString("customname");
            Parameters p = null;
            if (!customname.equals("")) {
                name = customname;
            }
            String value = data.getString("value");
            String type = data.getString("type");
            p = type.equals("reader") ? router.getReaders().getReaderByName(parent).getParameters() : router.getWriters().getWriterByName(parent).getParameters();
            p.put(name, (Object)value);
            router.save();
            QueryString qs = new QueryString();
            qs.put("name", parent);
            qs.put("rname", rname);
            context.setRedirectPage("gdr:" + type + "edit", qs.toString());
        }
        catch (Exception e) {
            throw new BirdException(e);
        }
    }
}

