/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.gdr;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import is.hugvit.bird.datapump.WebDataSources;
import is.hugvit.bird.datapump.WebDataTargets;
import is.hugvit.bird.gdr.Install;
import is.hugvit.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import net.gopro.gdr.IO;
import net.gopro.gdr.Router;
import org.dom4j.Element;

public final class WebIOList
extends WebElementBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doGet(WebContext context) throws BirdException {
        String type = context.getParameter("type");
        List rlist = Install.getRouters();
        Element root = context.getRootElement();
        if (type.equals("reader")) {
            WebDataSources.doTypes((Element)root);
        } else {
            WebDataTargets.doTypes((Element)root);
        }
        Element e_list = root.addElement("gdr_io_list");
        e_list.addElement("type").addText(type);
        for (Router router : rlist) {
            List list = type.equals("reader") ? router.getReaders().getReaderList() : router.getWriters().getWriterList();
            Iterator j = list.iterator();
            while (j.hasNext()) {
                Element e = e_list.addElement("gdr_io");
                IO r = (IO)j.next();
                e.addElement("name").addText(r.getName());
                e.addElement("name_encoded").addText(URLEncoder.encode((String)r.getName()));
                e.addElement("rname").addText(router.getName());
                e.addElement("rname_encoded").addText(URLEncoder.encode((String)router.getName()));
                e.addElement("description").addText(IO.getDescription());
                e.addElement("type").addText(r.getType());
            }
        }
        try {
            Connection c = context.connect();
            try {
                String dtype = type.equals("reader") ? "datasource" : "datatarget";
                PreparedStatement stmt = c.prepareStatement("select name,id from bird_datapump where type=?");
                stmt.setString(1, dtype.toUpperCase());
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    String name = rs.getString(1);
                    String id = rs.getString(2);
                    Element e = e_list.addElement("gdr_io");
                    e.addElement("name").addText(name);
                    e.addElement("name_encoded").addText(URLEncoder.encode((String)name));
                    e.addElement("type").addText(dtype);
                    e.addElement("id").addText(id);
                }
                rs.close();
                stmt.close();
            }
            finally {
                c.close();
            }
        }
        catch (SQLException e) {
            throw new BirdException((Exception)e);
        }
    }
}

