/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.gdr;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebForm;
import is.hugvit.bird.gdr.Install;
import is.hugvit.net.QueryString;
import is.hugvit.net.URLDecoder;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import net.gopro.gdr.IO;
import net.gopro.gdr.IOInfo;
import net.gopro.gdr.Reader;
import net.gopro.gdr.Router;
import org.dom4j.Element;

public final class WebIO
extends WebForm {
    private static final void doIO(IOInfo i, Element root) {
        Element e_io = root.addElement("gdr_io_type");
        e_io.addElement("name").addText(i.getName());
        e_io.addElement("name_encoded").addText(URLDecoder.decode((String)i.getName()));
        e_io.addElement("description").addText(i.getDescription());
        StringBuffer s = new StringBuffer(512);
        s.append("<br/><br/><b>Document description:</b><br/>");
        s.append(i.getDocumentDesc());
        e_io.addElement("documentdesc").addText(s.toString());
    }

    private static final IO getIO(WebContext context) {
        HttpServletRequest req = context.getRequest();
        String rname = req.getParameter("rname");
        String name = req.getParameter("name");
        String type = context.getParameter("type");
        Router router = Install.getRouterByName(rname);
        if (type.equals("reader")) {
            return router.getReaders().getReaderByName(name);
        }
        return router.getWriters().getWriterByName(name);
    }

    private static final String properCase(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public final boolean queryOpen(WebContext context, Form data) throws BirdException {
        Element root = context.getRootElement();
        String type = context.getParameter("type");
        if (data.isCreate()) {
            IOInfo i;
            Element e_io_root = root.addElement("gdr_io_types");
            Hashtable h = IO.getKnownIOs();
            Enumeration e = h.elements();
            while (e.hasMoreElements()) {
                i = (IOInfo)e.nextElement();
                String name = i.getName();
                if (!name.endsWith(WebIO.properCase(type))) continue;
                WebIO.doIO(i, e_io_root);
            }
            i = Install.getRouters().iterator();
            Element e_routers = root.addElement("gdr_routers");
            while (i.hasNext()) {
                Router r = (Router)i.next();
                e_routers.addElement("name").addText(r.getName());
            }
        } else {
            IO io = WebIO.getIO(context);
            data.put("name", io.getName());
        }
        return true;
    }

    public final void doAction(WebContext context, Form data) throws BirdException {
        if (data.getAction().equals("kick")) {
            String type = context.getParameter("type");
            Reader r = (Reader)WebIO.getIO(context);
            r.kick();
            context.setRedirectPage("gdr:" + type + "s");
        }
    }

    public final void doDelete(WebContext context, Form data) throws BirdException {
        try {
            String type = context.getParameter("type");
            String rname = context.getRequest().getParameter("rname");
            Router router = Install.getRouterByName(rname);
            String name = context.getRequest().getParameter("name");
            if (type.equals("reader")) {
                router.getReaders().removeReader(name);
            } else {
                router.getWriters().removeWriter(name);
            }
            router.save();
            context.setRedirectPage("gdr:" + type + "s");
        }
        catch (Exception e) {
            throw new BirdException(e);
        }
    }

    public final void doSave(WebContext context, Form data) throws BirdException {
        try {
            String type = context.getParameter("type");
            String name = data.getString("name");
            String rname = data.getString("router");
            if (data.isCreate()) {
                Router router = Install.getRouterByName(rname);
                String io_type = data.getString("type");
                if (io_type.equals("custom")) {
                    io_type = data.getString("customtype");
                }
                if (type.equals("reader")) {
                    router.getReaders().addReader(name, io_type);
                } else {
                    router.getWriters().addWriter(name, io_type);
                }
                router.save();
            }
            QueryString qs = new QueryString();
            qs.put("name", name);
            qs.put("rname", rname);
            context.setRedirectPage("gdr:" + type + "edit", qs.toString());
        }
        catch (Exception e) {
            throw new BirdException(e);
        }
    }
}

