/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.gdr;

import is.hugvit.bird.BirdComponentBase;
import is.hugvit.bird.BirdDatabase;
import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdSession;
import is.hugvit.bird.core.BirdInstallHelper;
import is.hugvit.bird.core.BirdUtil;
import is.hugvit.bird.gdr.CleanAttachmentsThread;
import is.hugvit.log.FileLog;
import is.hugvit.log.Log;
import is.hugvit.util.Util;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import net.gopro.gdr.Router;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public final class Install
extends BirdComponentBase {
    private static final Properties p = new Properties();
    private static List routers = new ArrayList();
    public static ResourceBundle lang;
    static File web_inf;
    private CleanAttachmentsThread clean_thread;

    public Properties getInfo() {
        return p;
    }

    public final void install(BirdSession context) throws BirdException {
        Document doc;
        lang = ResourceBundle.getBundle("is.hugvit.bird.gdr.bird_gdr", context.getLocale());
        BirdDatabase db = context.getDatabase();
        boolean hide = true;
        db.importXMLData(((Object)((Object)this)).getClass().getResourceAsStream("data/bird_element.xml"), hide);
        db.importXMLData(((Object)((Object)this)).getClass().getResourceAsStream("data/bird_template.xml"), hide);
        db.importXMLData(((Object)((Object)this)).getClass().getResourceAsStream("data/bird_pagetype.xml"), hide);
        InputStream is = null;
        try {
            is = ((Object)((Object)this)).getClass().getResourceAsStream("install.xml");
            SAXReader reader = new SAXReader();
            doc = reader.read(is);
        }
        catch (Exception ex) {
            throw new BirdException("Could not read the install.xml", ex);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ex) {
                throw new BirdException(ex);
            }
        }
        BirdInstallHelper helper = new BirdInstallHelper(doc, lang, (Object)this);
        helper.Install(context, db);
    }

    public final void start(BirdSession context) throws BirdException {
        try {
            lang = ResourceBundle.getBundle("is.hugvit.bird.gdr.bird_gdr", context.getLocale());
            File web_path = null;
            Properties p = context.getParameters();
            String dir = p.getProperty("dir.web-inf");
            if (dir != null) {
                web_inf = new File(dir);
                web_path = web_inf.getParentFile();
            } else {
                ServletContext servletcontext = context.getServletContext();
                if (servletcontext != null) {
                    web_path = new File(servletcontext.getRealPath("/"));
                    web_inf = new File(web_path, "WEB-INF");
                }
            }
            if (web_inf != null) {
                File[] f;
                File logdir = new File(web_inf, "logs");
                File routerdir = new File(web_inf, "routers");
                File att_dir = new File(web_inf, "attachments");
                if (!logdir.exists()) {
                    logdir.mkdir();
                }
                if (!routerdir.exists()) {
                    routerdir.mkdir();
                }
                if (!att_dir.exists()) {
                    att_dir.mkdir();
                }
                if ((f = routerdir.listFiles()) != null) {
                    for (int i = 0; i < f.length; ++i) {
                        String name = Util.changeFileExt((String)f[i].getName(), (String)"");
                        FileLog log = new FileLog(logdir, name, true);
                        log.setLevel(1);
                        Router router = new Router(f[i], (Log)log, false);
                        router.setName(name);
                        router.setWebRoot(web_path.getAbsolutePath());
                        routers.add(router);
                        router.start();
                    }
                }
                this.clean_thread = new CleanAttachmentsThread(att_dir);
                this.clean_thread.start();
            }
        }
        catch (IOException e) {
            throw new BirdException((Exception)e);
        }
    }

    public final void stop(BirdSession context) throws BirdException {
        for (Router router : routers) {
            router.stop();
        }
        this.clean_thread.stopThread();
    }

    public static final Router getRouter() {
        return (Router)routers.get(0);
    }

    public static final List getRouters() {
        return routers;
    }

    public static final synchronized Router getRouterByName(String name) {
        for (Router r : routers) {
            if (!r.getName().equals(name)) continue;
            return r;
        }
        return null;
    }

    private static final File getFile(String name) {
        return new File(web_inf, "routers/" + name + ".xml");
    }

    public static final synchronized Router createRouter(String name) throws IOException {
        File logdir = new File(web_inf, "logs");
        FileLog log = new FileLog(logdir, name, true);
        log.setLevel(1);
        File file = Install.getFile(name);
        Router router = new Router(file, (Log)log, false);
        router.setName(name);
        router.save();
        routers.add(router);
        router.start();
        return router;
    }

    public static final synchronized void changeName(String oldname, String newname) throws IOException {
        Router r = Install.getRouterByName(oldname);
        File f1 = Install.getFile(oldname);
        File f2 = Install.getFile(newname);
        r.setName(newname);
        r.setFile(f2);
        f1.renameTo(f2);
    }

    public static final synchronized void deleteRouter(String name) {
        Router r = Install.getRouterByName(name);
        if (r != null) {
            routers.remove(r);
            File file = new File(web_inf, "routers/" + name + ".xml");
            file.delete();
        }
    }

    public final void uninstall(BirdSession context) throws BirdException {
        BirdDatabase db = context.getDatabase();
        db.removeData(((Object)((Object)this)).getClass().getResourceAsStream("data/bird_element.xml"));
        db.removeData(((Object)((Object)this)).getClass().getResourceAsStream("data/bird_template.xml"));
        db.removeData(((Object)((Object)this)).getClass().getResourceAsStream("data/bird_pagetype.xml"));
        BirdUtil.deleteMenu((BirdDatabase)db, (String)"bird:routers");
        BirdUtil.deleteMenu((BirdDatabase)db, (String)"bird:readers");
        BirdUtil.deleteMenu((BirdDatabase)db, (String)"bird:writers");
    }

    static {
        p.put("name", "Bird:GDR");
        p.put("version", "1.1.0");
    }
}

