/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.gdr;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.mail.internet.MimeBodyPart;
import org.apache.soap.Fault;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.Response;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.transport.http.SOAPHTTPConnection;

public final class GDRServiceProxy {
    private static final String targetObjectURI = "http://tempuri.org/is.hugvit.bird.gdr.GDRService";
    private ArrayList attachments = new ArrayList();
    private URL url;

    public GDRServiceProxy() {
    }

    public GDRServiceProxy(String url) throws MalformedURLException {
        this.url = new URL(url);
    }

    public final void setEndPoint(URL url) {
        this.url = url;
    }

    public final void setEndPoint(String url) throws MalformedURLException {
        this.url = new URL(url);
    }

    public final URL getEndPoint() {
        return this.url;
    }

    public final void addAttachment(String cid, DataSource ds) {
        Object[] a = new Object[]{cid, ds};
        this.attachments.add(a);
    }

    public final void addAttachment(File file) {
        this.addAttachment(file.getName(), file);
    }

    public final void addAttachment(String cid, File file) {
        this.addAttachment(cid, (DataSource)new FileDataSource(file));
    }

    public final void addAttachment(String cid, URL url) {
        this.addAttachment(cid, (DataSource)new URLDataSource(url));
    }

    private static final Call createCall(String name) throws Exception {
        SOAPHTTPConnection soapHTTPConnection = new SOAPHTTPConnection();
        Method m = SOAPHTTPConnection.class.getMethod("setTcpNoDelay", Boolean.class);
        if (m != null) {
            m.invoke((Object)soapHTTPConnection, Boolean.TRUE);
        }
        Call call = new Call();
        call.setSOAPTransport((SOAPTransport)soapHTTPConnection);
        call.setEncodingStyleURI("http://schemas.xmlsoap.org/soap/encoding/");
        call.setTargetObjectURI(targetObjectURI);
        call.setMethodName(name);
        return call;
    }

    private static final void addAttachments(Call call, ArrayList attachments) throws Exception {
        for (Object[] a : attachments) {
            String cid = (String)a[0];
            DataSource ds = (DataSource)a[1];
            String filename = ds.getName();
            DataHandler dh = new DataHandler(ds);
            MimeBodyPart bp = new MimeBodyPart();
            bp.setDataHandler(dh);
            bp.setHeader("Content-ID", cid);
            bp.setFileName(filename);
            call.addBodyPart(bp);
        }
    }

    private final String invoke(Call call, String[] param) throws Exception {
        Response resp;
        String result = null;
        if (param != null) {
            Vector<Parameter> v = new Vector<Parameter>(param.length);
            for (int i = 0; i < param.length; ++i) {
                Parameter p = new Parameter("param" + i, String.class, (Object)param[i], "http://schemas.xmlsoap.org/soap/encoding/");
                v.addElement(p);
            }
            call.setParams(v);
        }
        if ((resp = call.invoke(this.url, "")).generatedFault()) {
            Fault fault = resp.getFault();
            throw new SOAPException(fault.getFaultCode(), fault.getFaultString());
        }
        Parameter refValue = resp.getReturnValue();
        if (refValue != null) {
            result = (String)refValue.getValue();
        }
        return result;
    }

    public final String getProcesses() throws Exception {
        Call call = GDRServiceProxy.createCall("getProcesses");
        return this.invoke(call, null);
    }

    public final void putDocument(String name, String gdf) throws Exception {
        Call call = GDRServiceProxy.createCall("putDocument");
        GDRServiceProxy.addAttachments(call, this.attachments);
        this.invoke(call, new String[]{name, gdf});
    }
}

