/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.gdr;

import is.hugvit.bird.gdr.Install;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import javax.activation.DataHandler;
import net.gopro.gdr.Router;
import net.gopro.gdr.Writer;
import org.apache.axis.MessageContext;
import org.apache.axis.attachments.AttachmentPart;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public final class GDRService {
    private static final boolean isVisible(Router r) {
        return r.getParameters().getBoolean("visible", false);
    }

    private static final void addAttachments(File dir, MessageContext ctx, Element root) throws Exception {
        Iterator i = ctx.getMessage().getAttachments();
        if (i.hasNext()) {
            if (!dir.exists()) {
                dir.mkdir();
            }
            while (i.hasNext()) {
                AttachmentPart ap = (AttachmentPart)i.next();
                String cid = ap.getContentId();
                DataHandler dh = ap.getDataHandler();
                String filename = dh.getName();
                String content_type = ap.getContentType();
                File file = new File(filename);
                Element att = new Element("attachment");
                att.setAttribute("cid", cid);
                att.setAttribute("filename", filename);
                att.setAttribute("url", "file:///" + file.getAbsolutePath());
                att.setAttribute("content_type", content_type);
                root.addContent(att);
                System.out.println("GDRService: cid=" + cid + "; filename=" + filename + "; content_type=" + content_type);
            }
        }
    }

    public final String getProcesses() throws Exception {
        Element root = new Element("processes");
        Document document = new Document(root);
        for (Router r : Install.getRouters()) {
            if (!GDRService.isVisible(r)) continue;
            Element p = new Element("process");
            root.addContent(p);
            Element name = new Element("name");
            name.addContent(r.getName());
            p.addContent(name);
            Element e = new Element("external_parameters");
            p.addContent(e);
            for (Writer w : r.getWriters().getWriterList()) {
                String ext = w.getParameters().getString((Object)"external_parameters", null);
                if (ext == null) continue;
                SAXBuilder builder = new SAXBuilder();
                Document tmpdoc = builder.build((Reader)new StringReader("<root>" + ext + "</root>"));
                for (Element e2 : tmpdoc.getRootElement().getChildren()) {
                    e.addContent((Element)e2.clone());
                }
            }
        }
        StringWriter w = new StringWriter();
        XMLOutputter out = new XMLOutputter();
        try {
            out.output(document, (java.io.Writer)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return w.toString();
    }

    public final void putDocument(String name, String gdf) throws Exception {
        try {
            Router router = Install.getRouterByName(name);
            if (router == null) {
                throw new Exception("Router " + name + " not found");
            }
            MessageContext ctx = MessageContext.getCurrentContext();
            SAXBuilder builder = new SAXBuilder();
            Document document = builder.build((Reader)new StringReader(gdf));
            Element root = document.getRootElement();
            File dir = Install.web_inf;
            dir = new File(dir, "attachments");
            GDRService.addAttachments(dir, ctx, root);
            router.put(document);
            System.out.println("GDRService.putDocument");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

