/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.datapump;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.core.WebBirdForm;
import is.hugvit.bird.datapump.WebDataSource;
import is.hugvit.net.QueryString;
import is.hugvit.util.UID;
import is.hugvit.util.Util;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;

public final class WebDataTarget
extends WebBirdForm {
    public WebDataTarget() {
        this.setTable("bird_datapump");
        this.setRedirect("gdr:datatargets");
        this.add(new Field("name", true));
        this.add(new Field("body"));
    }

    public final void doSave(WebContext context, Form data) throws BirdException {
        if (data.isCreate()) {
            data.put("id", UID.getUID());
            data.put("type", "DATATARGET");
        }
        data.put("modified", (Object)new Timestamp(new Date().getTime()));
        data.put("modified_by", context.getRequest().getRemoteUser());
        super.doSave(context, data);
    }

    public final boolean queryOpen(WebContext context, Form data) throws BirdException {
        super.queryOpen(context, data);
        try {
            if (data.isCreate()) {
                QueryString qs = new QueryString(context.getRequest().getQueryString());
                String type = qs.get("type");
                String body = Util.getResourceString((Object)((Object)this), (String)"datatarget.xml");
                String classname = "";
                StringBuffer s = new StringBuffer(64);
                if (type.equals("sql")) {
                    classname = "is.hugvit.datapump.SQLDataTarget";
                    WebDataSource.addParam(s, "driver", "COM.ibm.db2.jdbc.app.DB2Driver", "");
                    WebDataSource.addParam(s, "connection", "jdbc:db2:mydatabase", "");
                    WebDataSource.addParam(s, "user", "db2admin", "");
                    WebDataSource.addParam(s, "password", "Insert your password here", "");
                    WebDataSource.addParam(s, "table", "MyTable", "Name of your table");
                } else if (type.equals("notes")) {
                    classname = "is.hugvit.datapump.NotesDataTarget";
                    WebDataSource.addParam(s, "server", "myserver", "");
                    WebDataSource.addParam(s, "database", "mydatabase.nsf", "");
                    WebDataSource.addParam(s, "view", "myview", "");
                    WebDataSource.addParam(s, "form", "myform", "");
                } else if (type.equals("text")) {
                    classname = "is.hugvit.datapump.TextDataTarget";
                    WebDataSource.addParam(s, "filename", "c:\\myfilename.txt", "");
                    WebDataSource.addParam(s, "delimeter", ";", "The delimeter to use");
                } else if (type.equals("email")) {
                    classname = "is.hugvit.datapump.EmailDataTarget";
                    WebDataSource.addParam(s, "host", "mail.tristan.is", "The mail server to use");
                    WebDataSource.addParam(s, "contenttype", "text/html", "The content type of email (Default text/plain)");
                } else if (type.equals("goproexchange")) {
                    classname = "is.hugvit.datapump.GoProExchangeDataTarget";
                    WebDataSource.addParam(s, "url", "http://www.myserver.com/gopro.asp", "The url for asp web site");
                    WebDataSource.addParam(s, "form", "Contact", "The name of the form, eg Case, Company or Contact");
                } else if (type.equals("webservice")) {
                    classname = "is.hugvit.datapump.WebServiceDataTarget";
                    WebDataSource.addParam(s, "url", "http://example.com/WebService", "The url for web service");
                    WebDataSource.addParam(s, "method", "MethodName", "The name of the method");
                    WebDataSource.addParam(s, "soapaction", "<url>", "The SOAPAction parameter if needed");
                    WebDataSource.addParam(s, "namespace", "<url>", "The namespace if needed");
                    WebDataSource.addParam(s, "type", "xml", "Use either 'xml' for packing the data as xml or use 'parameters' for adding the data as parameters to the method");
                    WebDataSource.addParam(s, "username", "<username>", "The username if webservice has security");
                    WebDataSource.addParam(s, "password", "<password>", "The password if webservice has security");
                } else {
                    classname = "Insert the name of your class here";
                    WebDataSource.addParam(s, "param1", "???", "");
                    WebDataSource.addParam(s, "param2", "???", "");
                }
                body = Util.replace((String)body, (String)"$classname", (String)classname);
                body = Util.replace((String)body, (String)"$parameters", (String)s.toString());
                data.put("body", body);
            }
        }
        catch (IOException e) {
            throw new BirdException((Exception)e);
        }
        return true;
    }
}

