/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.datapump;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.core.WebBirdForm;
import is.hugvit.net.QueryString;
import is.hugvit.util.Util;
import java.io.IOException;

public final class WebDataSource
extends WebBirdForm {
    public WebDataSource() {
        this.setTable("bird_datapump");
        this.setRedirect("gdr:datasources");
        this.add(new Field("name", true));
        this.add(new Field("body"));
    }

    public final void doSave(WebContext context, Form data) throws BirdException {
        if (data.isCreate()) {
            data.put("type", "DATASOURCE");
        }
        super.doSave(context, data);
    }

    static final void addParam(StringBuffer s, String name, String value, String comment) {
        if (!comment.equals("")) {
            s.append("  <!-- " + comment + " -->\r\n");
        }
        s.append("  <parameter>\r\n");
        s.append("    <name>" + name + "</name>\r\n");
        s.append("    <value>" + value + "</value>\r\n");
        s.append("  </parameter>\r\n\r\n");
    }

    public final boolean queryOpen(WebContext context, Form data) throws BirdException {
        super.queryOpen(context, data);
        try {
            if (data.isCreate()) {
                QueryString qs = new QueryString(context.getRequest().getQueryString());
                String type = qs.get("type");
                String body = Util.getResourceString((Object)((Object)this), (String)"datasource.xml");
                String classname = "";
                StringBuffer s = new StringBuffer(64);
                if (type.equals("sql")) {
                    classname = "is.hugvit.datapump.SQLDataSource";
                    WebDataSource.addParam(s, "driver", "COM.ibm.db2.jdbc.app.DB2Driver", "");
                    WebDataSource.addParam(s, "connection", "jdbc:db2:mydatabase", "");
                    WebDataSource.addParam(s, "user", "db2admin", "");
                    WebDataSource.addParam(s, "password", "Insert your password here", "");
                    WebDataSource.addParam(s, "table", "MyTable", "Name of your table");
                    WebDataSource.addParam(s, "where", "myfield=10", "Insert your where clause here");
                } else if (type.equals("notes")) {
                    classname = "is.hugvit.datapump.NotesDataSource";
                    WebDataSource.addParam(s, "server", "myserver", "");
                    WebDataSource.addParam(s, "database", "mydatabase.nsf", "");
                    WebDataSource.addParam(s, "view", "myview", "");
                } else if (type.equals("text")) {
                    classname = "is.hugvit.datapump.TextDataSource";
                    WebDataSource.addParam(s, "filename", "c:\\myfilename.txt", "");
                    WebDataSource.addParam(s, "delete", "false", "Delete the file when finished");
                    WebDataSource.addParam(s, "delimeter", ";", "Use delimeter for delimeted files (Default \";\")");
                    s.append("\r\n");
                    s.append("<!-- Note use start,width properties in the field definition to the fixed field positions\r\n");
                    s.append("<property name=\"start\" value=\"1\"/>     Specifies where to start\r\n");
                    s.append("<property name=\"width\" value=\"10\"/>    Specified the width of the field\r\n");
                    s.append("-->\r\n");
                } else if (type.equals("xml")) {
                    classname = "is.hugvit.datapump.XMLDataSource";
                    WebDataSource.addParam(s, "url", "http://www.myserver.com/my_xml_file.txt", "The URL to the xml source");
                    WebDataSource.addParam(s, "path", "/data/myrecord", "This is the xpath to induvidual record");
                } else if (type.equals("goproexchange")) {
                    classname = "is.hugvit.datapump.GoProExchangeDataSource";
                    WebDataSource.addParam(s, "url", "http://www.myserver.com/gopro.asp", "The url for asp web site");
                    WebDataSource.addParam(s, "form", "Contact", "The name of the form, eg Case, Company or Contact");
                } else {
                    classname = "Insert the name of your class here";
                    WebDataSource.addParam(s, "param1", "???", "");
                    WebDataSource.addParam(s, "param2", "???", "");
                }
                body = Util.replace((String)body, (String)"$classname", (String)classname);
                body = Util.replace((String)body, (String)"$parameters", (String)s.toString());
                data.put("body", body);
            }
        }
        catch (IOException e) {
            throw new BirdException((Exception)e);
        }
        return true;
    }
}

