/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.datapump;

import is.hugvit.bird.BirdSession;
import is.hugvit.bird.datapump.Install;
import is.hugvit.datapump.XMLDataPump;
import is.hugvit.io.ResourceLocator;
import is.hugvit.log.Log;
import is.hugvit.thread.ThreadContext;
import is.hugvit.thread.ThreadManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class DataPump
implements Runnable,
ResourceLocator {
    private BirdSession context = Install.getBirdSession();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String[] keys) throws Exception {
        Connection dc = null;
        try {
            if (this.context == null) {
                this.context = Install.getBirdSession();
                if (this.context == null) {
                    throw new NullPointerException("Cannot get context instance!");
                }
                dc = this.context.getDatabase().connect();
            } else {
                dc = this.context.getDatabase().connect();
            }
        }
        catch (Exception bex) {
            this.context.getLog().error("Error connecting to database! " + bex.getMessage());
        }
        try {
            PreparedStatement stmt = dc.prepareStatement("select body from bird_datapump where name=? and type=?");
            stmt.setString(1, keys[0]);
            stmt.setString(2, keys[1]);
            ResultSet rd = stmt.executeQuery();
            try {
                if (rd.next()) {
                    String string = rd.getString(1);
                    return string;
                }
            }
            finally {
                rd.close();
                stmt.close();
            }
        }
        finally {
            dc.close();
        }
        return null;
    }

    @Override
    public void run() {
        ThreadContext tc = ThreadManager.getContext((Object)this);
        Log log = tc.getLog();
        try {
            String name = tc.getProperties().getProperty("name");
            XMLDataPump dp = new XMLDataPump();
            dp.setLog(log);
            dp.load(name, (ResourceLocator)this);
            dp.run();
        }
        catch (Exception e) {
            log.error(e);
        }
    }
}

