/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.xml;

import is.hugvit.util.Util;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.dom4j.Element;

public final class XMLUtil {
    public static final void toXML(Element root, Hashtable h) {
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object obj = h.get(key);
            if (obj == null) continue;
            String value = XMLUtil.getString(obj);
            root.addElement(key).addText(value);
        }
    }

    public static final void toXML(Element root, String name, Object[] objs) {
        if (objs != null) {
            Element e = root.addElement(name);
            for (int i = 0; i < objs.length; ++i) {
                e.addElement("value").addText(objs[i].toString());
            }
        }
    }

    private static final String getString(Object obj) {
        Date v;
        if (obj instanceof Time) {
            Time v2 = (Time)obj;
            if (v2 != null) {
                obj = Util.timeToISO(v2);
            }
        } else if (obj instanceof Timestamp) {
            Timestamp v3 = (Timestamp)obj;
            if (v3 != null) {
                obj = Util.dateTimeToISO(v3);
            }
        } else if (obj instanceof Date && (v = (Date)obj) != null) {
            obj = Util.dateToISO(v);
        }
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    public static final void toXML(Element r, ResultSet rs) throws SQLException {
        XMLUtil.toXML(r, rs, null, null);
    }

    public static final void toXML(Element r, ResultSet rs, Properties f, String row_name) throws SQLException {
        ResultSetMetaData rsm = rs.getMetaData();
        if (row_name == null && (row_name = rsm.getTableName(1).toLowerCase()).equals("")) {
            row_name = "row";
        }
        while (rs.next()) {
            Element row = r.addElement(row_name);
            XMLUtil.toXMLFields(row, rs, rsm, f);
        }
    }

    private static final void toXMLFields(Element row, ResultSet rs, ResultSetMetaData rsm, Properties f) throws SQLException {
        int ccount = rsm.getColumnCount();
        for (int i = 1; i <= ccount; ++i) {
            String cname = rsm.getColumnName(i).toLowerCase();
            int type = rsm.getColumnType(i);
            Object value = null;
            switch (type) {
                case 12: {
                    value = rs.getString(i);
                    break;
                }
                case 91: {
                    String format;
                    Date d = rs.getDate(i);
                    if (d == null) break;
                    Element e = row.addElement(cname);
                    e.addText(Util.dateToISO(d));
                    String string = format = f == null ? null : f.getProperty(cname);
                    if (format != null) {
                        e.addAttribute("text", Util.formatDate(format, d));
                        break;
                    }
                    e.addAttribute("text", Util.dateToShort(d));
                    break;
                }
                case 92: {
                    String format;
                    Date d = rs.getTime(i);
                    if (d == null) break;
                    Element e = row.addElement(cname);
                    e.addText(Util.timeToISO(d));
                    e.addAttribute("text", Util.timeToShort(d));
                    String string = format = f == null ? null : f.getProperty(cname);
                    if (format != null) {
                        e.addAttribute("text", Util.formatDate(format, d));
                        break;
                    }
                    e.addAttribute("text", Util.timeToShort(d));
                    break;
                }
                case 93: {
                    String format;
                    Date d = rs.getTimestamp(i);
                    if (d == null) break;
                    Element e = row.addElement(cname);
                    e.addText(Util.dateTimeToISO(d));
                    String string = format = f == null ? null : f.getProperty(cname);
                    if (format != null) {
                        e.addAttribute("text", Util.formatDate(format, d));
                        break;
                    }
                    e.addAttribute("text", Util.dateTimeToShort(d));
                    break;
                }
                default: {
                    value = rs.getObject(i);
                }
            }
            if (value == null) continue;
            row.addElement(cname).addText(value.toString());
        }
    }
}

