/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleXML {
    private Document doc;
    private String encoding = "ISO-8859-1";

    public SimpleXML(Document doc) {
        this.doc = doc;
    }

    public SimpleXML(Document doc, String encoding) {
        this.doc = doc;
        this.encoding = encoding;
    }

    public Document getDocument() {
        return this.doc;
    }

    public String getString(String path) {
        return SimpleXML.getString(this.getElement(this.doc, path, false));
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public final int getInt(String path) {
        String value = SimpleXML.getString(this.getElement(this.doc, path, false));
        if (value.equals("")) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    public final boolean getBoolean(String path) {
        String value = SimpleXML.getString(this.getElement(this.doc, path, false));
        return value.equals("1") || value.equals("true");
    }

    public final NodeList getElements(String path) {
        return this.getElements(this.doc, path);
    }

    public final NodeList getElements(Node node, String name) {
        int p = name.lastIndexOf(47);
        if (p > -1) {
            node = this.getElement(node, name.substring(0, p), false);
            name = name.substring(p + 1);
        }
        if (node != null) {
            return ((Element)node).getElementsByTagName(name);
        }
        return this.doc.getElementsByTagName("");
    }

    public final Vector getStringVector(Node node, String name) {
        Vector<String> v = new Vector<String>();
        NodeList l = this.getElements(node, name);
        for (int i = 1; i < l.getLength(); ++i) {
            Node n = l.item(i);
            v.addElement(SimpleXML.getString(n));
        }
        return v;
    }

    public final String getString(Node n, String path) {
        return SimpleXML.getString(this.getElement(n, path, false));
    }

    public final boolean getBoolean(Node n, String path) {
        String s = SimpleXML.getString(this.getElement(n, path, false));
        return s.equals("1") || s.equals("true");
    }

    public final int getInt(Node n, String path) {
        String value = SimpleXML.getString(this.getElement(n, path, false));
        if (value.equals("")) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    private static final Vector split(String s, String t) {
        Vector<String> v = new Vector<String>();
        int i = 0;
        int j = s.indexOf(t);
        while (j != -1) {
            v.addElement(s.substring(i, j));
            i = j + t.length();
            j = s.indexOf(t, i);
        }
        v.addElement(s.substring(i));
        return v;
    }

    public final Node getElement(String path, boolean create) {
        return this.getElement(this.doc, path, create);
    }

    public final Node getElement(Node n, String path, boolean create) {
        Node e;
        Vector v = SimpleXML.split(path, "/");
        NodeList l = null;
        String name = (String)v.firstElement();
        l = n.getNodeType() == 9 ? ((Document)n).getElementsByTagName(name) : ((Element)n).getElementsByTagName(name);
        if (l.getLength() == 0) {
            if (!create) {
                return null;
            }
            e = this.addElement(n, name);
        } else {
            e = l.item(0);
        }
        for (int i = 1; i < v.size(); ++i) {
            name = (String)v.elementAt(i);
            l = ((Element)e).getElementsByTagName(name);
            if (l.getLength() == 0) {
                if (!create) {
                    return null;
                }
                e = this.addElement(e, name);
                continue;
            }
            e = l.item(0);
        }
        return e;
    }

    public void removeElements(String path, String name, String value) {
        Element n;
        Vector<Element> v = new Vector<Element>();
        NodeList l = this.getElements(this.doc, path);
        for (int i = 0; i < l.getLength(); ++i) {
            n = (Element)l.item(i);
            NodeList k = n.getElementsByTagName(name);
            for (int j = 0; j < k.getLength(); ++j) {
                Element m = (Element)k.item(j);
                if (!SimpleXML.getString(m).equalsIgnoreCase(value)) continue;
                v.addElement(n);
            }
        }
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            n = (Element)e.nextElement();
            Node p = n.getParentNode();
            p.removeChild(n);
        }
    }

    public final Node addElement(Node n, String name) {
        Element m = this.doc.createElement(name);
        m.appendChild(this.doc.createTextNode("\n"));
        n.appendChild(m);
        n.appendChild(this.doc.createTextNode("\n"));
        return m;
    }

    public final Node addElement(String path, String name) {
        return this.addElement(this.getElement(path, true), name);
    }

    public final void addString(Node n, String name, String value) {
        Element m = this.doc.createElement(name);
        n.appendChild(m);
        m.appendChild(this.doc.createTextNode(value));
        n.appendChild(this.doc.createTextNode("\n"));
    }

    public final void replaceString(Node n, String name, String value) {
        Element m = this.doc.createElement(name);
        m.appendChild(this.doc.createTextNode(value));
        n.appendChild(this.doc.createTextNode("\n"));
        Node o = this.getElement(n, name, true);
        if (o == null) {
            n.appendChild(m);
        } else {
            n.replaceChild(m, o);
        }
    }

    public final void addBoolean(Node n, String name, boolean value) {
        this.addInt(n, name, value ? 1 : 0);
    }

    public final void addInt(Node n, String name, int value) {
        this.addString(n, name, value + "");
    }

    private final void writeChildNodes(Writer out, NodeList list, boolean textonly) throws IOException {
        for (int i = 0; i < list.getLength(); ++i) {
            int j;
            Node n = list.item(i);
            if (n.getNodeType() == 1) {
                if (!textonly) {
                    out.write("<" + n.getNodeName());
                    NamedNodeMap amap = n.getAttributes();
                    for (j = 0; j < amap.getLength(); ++j) {
                        Attr a = (Attr)amap.item(j);
                        out.write(" " + a.getName() + "=\"" + SimpleXML.escapeMarkup(a.getValue()) + "\"");
                    }
                }
                if (n.hasChildNodes()) {
                    if (!textonly) {
                        out.write(">");
                    }
                    this.writeChildNodes(out, n.getChildNodes(), textonly);
                    if (textonly) continue;
                    out.write("</" + n.getNodeName() + ">");
                    continue;
                }
                if (textonly) continue;
                out.write("/>");
                continue;
            }
            if (n.getNodeType() == 3) {
                String s;
                if (textonly) {
                    s = n.getNodeValue();
                    if ((s = SimpleXML.replace(s, "\u000e0", " ").trim()).equals("")) continue;
                    out.write(s + " ");
                    continue;
                }
                s = SimpleXML.escapeMarkup(n.getNodeValue());
                s = SimpleXML.replace(s, "\u000e0", "&nbsp;");
                out.write(s);
                continue;
            }
            if (n.getNodeType() != 5) continue;
            NodeList m = n.getChildNodes();
            for (j = 0; j < m.getLength(); ++j) {
                if (textonly) {
                    out.write(SimpleXML.escapeMarkup(m.item(j).getNodeValue()));
                    continue;
                }
                out.write(m.item(j).getNodeValue());
            }
        }
    }

    public final void write(Writer out) throws IOException {
        out.write("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>\n");
        this.writeChildNodes(out, this.doc.getChildNodes(), false);
    }

    public final void writeAsText(Writer out) throws IOException {
        this.writeChildNodes(out, this.doc.getChildNodes(), true);
    }

    public String toString() {
        StringWriter s = new StringWriter();
        try {
            this.write(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return s.toString();
    }

    private static final String replace(String src, String a, String b) {
        int j = src.indexOf(a);
        if (j == -1) {
            return src;
        }
        StringBuffer s = new StringBuffer(src.length());
        int i = 0;
        while (j > -1) {
            s.append(src.substring(i, j));
            s.append(b);
            i = j + a.length();
            j = src.indexOf(a, i);
        }
        s.append(src.substring(i));
        return s.toString();
    }

    private static final String escapeMarkup(String s) {
        if (s == null) {
            return "";
        }
        s = SimpleXML.replace(s, "&", "&amp;");
        s = SimpleXML.replace(s, "<", "&lt;");
        return SimpleXML.replace(s, ">", "&gt;");
    }

    public static final String getString(Node e) {
        StringBuffer s = new StringBuffer(50);
        if (e != null) {
            NodeList l = e.getChildNodes();
            for (int i = 0; i < l.getLength(); ++i) {
                Node n = l.item(i);
                if (n.getNodeType() == 3) {
                    s.append(n.getNodeValue());
                    continue;
                }
                if (n.getNodeType() != 5) continue;
                NodeList t = n.getChildNodes();
                for (int j = 0; j < t.getLength(); ++j) {
                    s.append(t.item(j).getNodeValue());
                }
            }
        }
        return s.toString();
    }
}

