/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.xml;

import is.hugvit.xml.NodeEx;
import is.hugvit.xml.ParserConfig;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.UserDataHandler;

class NodeText
extends NodeEx {
    protected String value;

    public NodeText(String value) {
        this.value = value;
    }

    @Override
    public void write(Writer out, ParserConfig config) throws IOException {
        if (config.getTextOnly()) {
            String s = NodeText.replace(this.value, "&nbsp;", "").trim();
            if (!s.equals("")) {
                out.write(s + " ");
            }
        } else {
            out.write(this.value);
        }
    }

    @Override
    public String getNodeValue() {
        String s = NodeText.unescapeMarkup(this.value);
        return NodeText.replace(s, "&nbsp;", "\u000e0");
    }

    @Override
    public void writeTree(Writer out, int space) throws IOException {
        out.write(NodeText.getSpace(space) + this.value + "\r\n");
    }

    @Override
    public void recycle() {
        this.value = null;
    }

    @Override
    public short getNodeType() {
        return 3;
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return this.parent.setUserData(key, data, handler);
    }

    public String toString() {
        return this.value;
    }
}

