/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.xml;

import is.hugvit.xml.NodeTag;
import is.hugvit.xml.NodeVector;
import is.hugvit.xml.ParserConfig;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class NodeEx
implements Node {
    protected Vector nodes = new Vector();
    protected NodeEx parent;

    NodeEx() {
    }

    public final void NotSupported() throws DOMException {
        throw new DOMException(9, "Not supported");
    }

    public void write(Writer out, ParserConfig config) throws IOException {
        Enumeration e = this.nodes.elements();
        while (e.hasMoreElements()) {
            NodeEx n = (NodeEx)e.nextElement();
            n.write(out, config);
        }
    }

    public void writeTree(Writer out, int space) throws IOException {
        Enumeration e = this.nodes.elements();
        while (e.hasMoreElements()) {
            NodeEx n = (NodeEx)e.nextElement();
            n.writeTree(out, space + 2);
        }
    }

    protected static final String getSpace(int n) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            s.append(" ");
        }
        return s.toString();
    }

    protected static final String replace(String src, String a, String b) {
        int j = src.indexOf(a);
        if (j == -1) {
            return src;
        }
        StringBuffer s = new StringBuffer(src.length());
        int i = 0;
        while (j > -1) {
            s.append(src.substring(i, j));
            s.append(b);
            i = j + a.length();
            j = src.indexOf(a, i);
        }
        s.append(src.substring(i));
        return s.toString();
    }

    protected static final String unescapeMarkup(String s) {
        if (s == null) {
            return "";
        }
        s = NodeEx.replace(s, "&amp;", "&");
        s = NodeEx.replace(s, "&lt;", "<");
        return NodeEx.replace(s, "&gt;", ">");
    }

    protected void setParent(NodeEx parent) {
        this.parent = parent;
    }

    public NodeList getElementsByTagName(String tagname) {
        NodeVector v = new NodeVector();
        Enumeration e = this.nodes.elements();
        while (e.hasMoreElements()) {
            NodeTag tag;
            NodeEx n = (NodeEx)e.nextElement();
            if (!(n instanceof NodeTag) || !(tag = (NodeTag)n).getTagName().equals(tagname)) continue;
            v.add(tag);
        }
        return v;
    }

    public void recycle() {
        if (this.nodes != null) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                NodeEx n = (NodeEx)this.nodes.elementAt(i);
                n.recycle();
                this.nodes.setElementAt(null, i);
            }
            this.nodes = null;
        }
    }

    @Override
    public Node getParentNode() {
        return this.parent;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        NodeEx n = (NodeEx)newChild;
        if (n.parent != null) {
            n.parent.nodes.removeElement(n);
        }
        this.nodes.addElement(newChild);
        n.setParent(this);
        return newChild;
    }

    protected void add(NodeEx n) {
        this.nodes.addElement(n);
    }

    @Override
    public Node cloneNode(boolean deep) {
        return null;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public NodeList getChildNodes() {
        return new NodeVector(this.nodes);
    }

    @Override
    public Node getFirstChild() {
        return (Node)this.nodes.firstElement();
    }

    @Override
    public Node getLastChild() {
        return (Node)this.nodes.lastElement();
    }

    @Override
    public Node getNextSibling() {
        return null;
    }

    @Override
    public String getNodeName() {
        return null;
    }

    @Override
    public short getNodeType() {
        return 0;
    }

    @Override
    public String getNodeValue() {
        return null;
    }

    @Override
    public Document getOwnerDocument() {
        return null;
    }

    @Override
    public Node getPreviousSibling() {
        return null;
    }

    @Override
    public boolean hasChildNodes() {
        return !this.nodes.isEmpty();
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) {
        return null;
    }

    @Override
    public Node removeChild(Node p1) throws DOMException {
        ((NodeEx)p1).setParent(null);
        this.nodes.removeElement(p1);
        return p1;
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return null;
    }

    @Override
    public void setNodeValue(String nodeValue) {
    }

    @Override
    public final void normalize() {
    }

    @Override
    public final String getNamespaceURI() {
        return null;
    }

    @Override
    public final boolean isSupported(String feature, String version) {
        return false;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public final void setPrefix(String prefix) {
    }

    @Override
    public final String getLocalName() {
        return null;
    }

    @Override
    public final boolean hasAttributes() {
        return false;
    }

    public final NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
        return null;
    }

    public final boolean supports(String feature, String version) {
        return false;
    }

    @Override
    public final Object getUserData(String key) {
        return null;
    }

    @Override
    public final Object getFeature(String feature, String version) {
        return null;
    }

    @Override
    public final boolean isEqualNode(Node arg) {
        return false;
    }

    @Override
    public final String lookupNamespaceURI(String prefix) {
        return null;
    }

    @Override
    public final boolean isDefaultNamespace(String namespaceURI) {
        return false;
    }

    @Override
    public final String lookupPrefix(String namespaceURI) {
        return null;
    }

    @Override
    public final boolean isSameNode(Node other) {
        return other.equals(this);
    }

    @Override
    public final void setTextContent(String textContent) throws DOMException {
    }

    @Override
    public final String getTextContent() throws DOMException {
        return null;
    }

    @Override
    public final short compareDocumentPosition(Node other) throws DOMException {
        this.NotSupported();
        return 0;
    }

    @Override
    public final String getBaseURI() {
        return null;
    }
}

