/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.xml;

import is.hugvit.xml.DocumentEx;
import is.hugvit.xml.HtmlConverter;
import is.hugvit.xml.MarkupTokenizer;
import is.hugvit.xml.NodeCDATA;
import is.hugvit.xml.NodeComment;
import is.hugvit.xml.NodeDirective;
import is.hugvit.xml.NodeEx;
import is.hugvit.xml.NodeInstruction;
import is.hugvit.xml.NodeTag;
import is.hugvit.xml.NodeText;
import is.hugvit.xml.ParseException;
import is.hugvit.xml.ParserConfig;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;

public final class MarkupParser {
    private static final Hashtable blockElements = new Hashtable();
    private static final String[] array_blockElements = new String[]{"a", "abbr", "acronym", "address", "applet", "area", "b", "base", "basefont", "bdo", "big", "blockquote", "body", "button", "caption", "center", "cite", "code", "col", "colgroup", "dd", "del", "dir", "div", "dl", "dt", "em", "embed", "fieldset", "font", "form", "frame", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "head", "html", "i", "iframe", "ins", "isindex", "label", "legend", "li", "map", "menu", "noframes", "noscript", "object", "ol", "optgroup", "option", "p", "pre", "q", "select", "small", "span", "style", "strong", "script", "sub", "sup", "table", "textarea", "tbody", "tfoot", "thead", "th", "td", "title", "tr", "tt", "u", "ul", "var"};

    private MarkupParser() {
    }

    private static final void eatSpace(MarkupTokenizer tok) throws ParseException, IOException {
        while (tok.peekTok() == 12) {
            tok.getTok();
        }
    }

    private static final void eatCloseTag(MarkupTokenizer tok) throws ParseException, IOException {
        tok.getTok();
        tok.getTok();
        tok.getTok();
        MarkupParser.eatSpace(tok);
        tok.assertTok(2);
        tok.getTok();
    }

    private static final Vector parseMarkup(MarkupTokenizer tok, ParserConfig config) throws ParseException, IOException {
        Vector v = new Vector();
        boolean loop = true;
        block9: while (loop) {
            switch (tok.peekTok()) {
                case 1: {
                    if (tok.peekTok(1) == 8) {
                        String name;
                        if (tok.peekTok(2) != 5) {
                            tok.expected(tok.getTokType(5));
                        }
                        if (tok.tag_stack.search(name = tok.peekString(2).toLowerCase()) > -1) {
                            loop = false;
                            continue block9;
                        }
                        MarkupParser.eatCloseTag(tok);
                        continue block9;
                    }
                    Enumeration e = MarkupParser.parseElement(tok, config).elements();
                    while (e.hasMoreElements()) {
                        v.addElement(e.nextElement());
                    }
                    continue block9;
                }
                case 9: {
                    v.addElement(new NodeText(tok.getString()));
                    continue block9;
                }
                case 11: {
                    v.addElement(new NodeInstruction(tok.getString()));
                    continue block9;
                }
                case 7: {
                    v.addElement(new NodeComment(tok.getString()));
                    continue block9;
                }
                case 6: {
                    v.addElement(new NodeDirective(tok.getString()));
                    continue block9;
                }
                case 10: {
                    v.addElement(new NodeCDATA(tok.getString()));
                    continue block9;
                }
                case 13: {
                    loop = false;
                    continue block9;
                }
            }
            tok.expected("< or text");
        }
        return v;
    }

    private static final void parseAttributes(MarkupTokenizer tok, NodeTag n) throws ParseException, IOException {
        while (true) {
            MarkupParser.eatSpace(tok);
            if (tok.peekTok() != 5) break;
            String name = tok.getString().toLowerCase();
            String value = MarkupParser.parseValue(tok, name);
            char c = value.charAt(0);
            value = value.substring(1, value.length() - 1);
            n.setAttribute(name, value, c);
        }
    }

    private static final String parseAttribute(MarkupTokenizer tok) throws ParseException, IOException {
        MarkupParser.eatSpace(tok);
        if (tok.peekTok() == 4) {
            return tok.getString();
        }
        StringBuffer s = new StringBuffer("\"");
        while (tok.peekTok() == 5 || tok.peekTok() == 8 || tok.peekTok() == 3) {
            s.append(tok.getString());
        }
        s.append("\"");
        return s.toString();
    }

    private static final String parseValue(MarkupTokenizer tok, String name) throws ParseException, IOException {
        MarkupParser.eatSpace(tok);
        if (tok.peekTok() == 3) {
            tok.getTok();
            return MarkupParser.parseAttribute(tok);
        }
        return "\"" + name + "\"";
    }

    static final boolean isBlockElement(String name) {
        return blockElements.containsKey(name);
    }

    private static final Vector handleBadMarkup(NodeTag n, Vector v) {
        if (!v.isEmpty() && MarkupParser.isBlockElement(n.getTagName())) {
            NodeTag t;
            NodeEx m;
            while (!(v.isEmpty() || (m = (NodeEx)v.firstElement()) instanceof NodeTag && (t = (NodeTag)m).getTagName().equals(n.getTagName()))) {
                n.add(m);
                m.setParent(m);
                v.removeElementAt(0);
            }
        }
        v.insertElementAt(n, 0);
        return v;
    }

    private static final Vector parseElement(MarkupTokenizer tok, ParserConfig config) throws ParseException, IOException {
        tok.getTok();
        tok.assertTok(5);
        String name = tok.getString().toLowerCase();
        NodeTag n = new NodeTag(null, name, config);
        MarkupParser.parseAttributes(tok, n);
        MarkupParser.eatSpace(tok);
        if (tok.peekTok() == 8) {
            tok.getTok();
            MarkupParser.eatSpace(tok);
            tok.assertTok(2);
            tok.getTok();
            Vector<NodeTag> v = new Vector<NodeTag>();
            v.addElement(n);
            return v;
        }
        tok.assertTok(2);
        tok.getTok();
        tok.tag_stack.push(name);
        Vector v = MarkupParser.parseMarkup(tok, config);
        if (tok.peekTok() == 13) {
            return MarkupParser.handleBadMarkup(n, v);
        }
        if (tok.peekTok() != 1 || tok.peekTok(1) != 8 || tok.peekTok(2) != 5) {
            tok.expected("</");
        }
        tok.tag_stack.pop();
        String endname = tok.peekString(2).toLowerCase();
        if (!n.getTagName().equals(endname)) {
            return MarkupParser.handleBadMarkup(n, v);
        }
        MarkupParser.eatCloseTag(tok);
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            NodeEx m = (NodeEx)e.nextElement();
            m.setParent(n);
            n.add(m);
        }
        v.removeAllElements();
        v.addElement(n);
        return v;
    }

    public static final Document parse(Reader in) throws ParseException, IOException {
        return MarkupParser.parse(in, new HtmlConverter());
    }

    static final DocumentEx parse(Reader in, ParserConfig config) throws ParseException, IOException {
        MarkupTokenizer tok = new MarkupTokenizer(3, config);
        tok.setVerbose(true);
        tok.setInput(in);
        Vector v = MarkupParser.parseMarkup(tok, config);
        DocumentEx doc = new DocumentEx(v);
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            NodeEx n = (NodeEx)e.nextElement();
            n.setParent(doc);
        }
        tok.assertTok(13);
        return doc;
    }

    static {
        for (int i = 0; i < array_blockElements.length - 1; ++i) {
            blockElements.put(array_blockElements[i], "");
        }
    }
}

