/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.util;

import is.hugvit.util.ArrayListEx;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Util {
    private static final DateFormat df_iso = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat df_iso2 = new SimpleDateFormat("yyyyMMdd");
    private static final DateFormat tf_iso = new SimpleDateFormat("HH:mm:ss");
    private static final DateFormat tsf_iso = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS");
    private static final DateFormat df_short = DateFormat.getDateInstance(3);
    private static final DateFormat tf_short = DateFormat.getTimeInstance(3);
    private static final DateFormat dtf_short = DateFormat.getDateTimeInstance(3, 3);
    private static final DateFormat dtf = new SimpleDateFormat("dd.MM.yyyy HH:mm");
    private static final int BUFFER_SIZE = 16384;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;

    private Util() {
    }

    public static final String dateToISO(Date date) {
        return df_iso.format(date);
    }

    public static final String dateToShort(Date date) {
        return df_short.format(date);
    }

    public static final Date timestampToDate(Timestamp ts) {
        return new Date(ts.getTime() + (long)(ts.getNanos() / 1000000));
    }

    public static final String dateTimeToShort(Date date) {
        return dtf.format(date);
    }

    public static final String dateToISO(Date date, String separator) {
        return new SimpleDateFormat("yyyy'" + separator + "'MM'" + separator + "'dd").format(date);
    }

    public static final String dateToISOShort(Date date) {
        return df_iso2.format(date);
    }

    public static final String timeToISO(Date date) {
        return tf_iso.format(date);
    }

    public static final Date isoToTime(String iso) throws ParseException {
        return tf_iso.parse(iso);
    }

    public static final int getInt(String r) {
        if (r == null) {
            return 0;
        }
        StringBuffer s = new StringBuffer(r.length());
        for (int i = 0; i < r.length(); ++i) {
            char c = r.charAt(i);
            if (c <= '/' || c >= ':') continue;
            s.append(c);
        }
        if (s.length() == 0) {
            return 0;
        }
        return Integer.parseInt(s.toString());
    }

    public static final Date isoToDate(String iso) throws ParseException {
        if (iso.length() == 8) {
            return df_iso2.parse(iso);
        }
        return df_iso.parse(iso);
    }

    public static final Date isoToDateTime(String iso) throws ParseException {
        return tsf_iso.parse(iso);
    }

    public static final String timeToShort(Date date) {
        return tf_short.format(date);
    }

    public static final String formatDate(String format, Date date) {
        return new SimpleDateFormat(format).format(date);
    }

    public static final String dateTimeToISO(Date date) {
        return tsf_iso.format(date);
    }

    public static final String getShortDatePattern() {
        DateFormat df = DateFormat.getDateInstance(3);
        if (df instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)df).toPattern();
        }
        Calendar c = Calendar.getInstance();
        c.set(1234, 4, 6);
        String s = df.format(c.getTime());
        s = Util.replace(s, "1234", "yyyy");
        s = Util.replace(s, "34", "yy");
        s = Util.replace(s, "05", "MM");
        s = Util.replace(s, "5", "M");
        s = Util.replace(s, "06", "dd");
        s = Util.replace(s, "6", "d");
        return s;
    }

    public static final String[] getWeekdays() {
        SimpleDateFormat sdf = new SimpleDateFormat();
        DateFormatSymbols dfs = sdf.getDateFormatSymbols();
        String[] d = dfs.getWeekdays();
        String[] e = new String[]{Util.properCase(d[1]), Util.properCase(d[2]), Util.properCase(d[3]), Util.properCase(d[4]), Util.properCase(d[5]), Util.properCase(d[6]), Util.properCase(d[7])};
        return e;
    }

    public static final String replace(String src, String a, String b) {
        int j = src.indexOf(a);
        if (j == -1) {
            return src;
        }
        StringBuffer s = new StringBuffer(src.length());
        int i = 0;
        while (j > -1) {
            s.append(src.substring(i, j));
            s.append(b);
            i = j + a.length();
            j = src.indexOf(a, i);
        }
        if (i < src.length()) {
            s.append(src.substring(i));
        }
        return s.toString();
    }

    public static final Vector split(String s, String t) {
        Vector<Object> v = new Vector<Object>();
        if (s != null) {
            StringTokenizer st = new StringTokenizer(s, t);
            while (st.hasMoreElements()) {
                v.addElement(st.nextElement());
            }
        }
        return v;
    }

    public static final String[] splitArray(String s, String t) {
        if (s == null || s.equals("")) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(s, t);
        String[] v = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            v[i++] = st.nextToken();
        }
        return v;
    }

    public static final List splitList(String s, String t) {
        if (s == null) {
            return new ArrayListEx();
        }
        StringTokenizer st = new StringTokenizer(s, t);
        ArrayListEx l = new ArrayListEx();
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        return l;
    }

    public static final String split(String s, char c, int pos) {
        int x = 0;
        int y = 0;
        int n = 1;
        int l = s.length();
        for (int i = 0; i < l && n <= pos; ++i) {
            if (s.charAt(i) == c) {
                if (++n != pos) continue;
                y = x = i + 1;
                continue;
            }
            if (n != pos) continue;
            ++y;
        }
        return s.substring(x, y);
    }

    public static final String split(String str, String delim, int pos) {
        int i;
        int l = delim.length();
        int p1 = 0;
        int p2 = str.indexOf(delim);
        for (i = 1; p2 != -1 && i != pos; ++i) {
            p1 = p2 + l;
            p2 = str.indexOf(delim, p1);
        }
        if (i != pos) {
            return "";
        }
        if (p2 == -1) {
            return str.substring(p1);
        }
        return str.substring(p1, p2);
    }

    public static final String expand(Vector v, String delim) {
        StringBuffer s = new StringBuffer(v.size() * 8);
        Enumeration e = v.elements();
        if (e.hasMoreElements()) {
            s.append((String)e.nextElement());
            while (e.hasMoreElements()) {
                s.append(delim + (String)e.nextElement());
            }
        }
        return s.toString();
    }

    public static final String expandKeys(Hashtable v, String delim) {
        StringBuffer s = new StringBuffer(v.size() * 8);
        Enumeration e = v.keys();
        if (e.hasMoreElements()) {
            s.append((String)e.nextElement());
            while (e.hasMoreElements()) {
                s.append(delim + (String)e.nextElement());
            }
        }
        return s.toString();
    }

    public static final String expand(String[] v, String delim) {
        StringBuffer s = new StringBuffer(v.length * 8);
        for (int i = 0; i < v.length; ++i) {
            if (i > 0) {
                s.append(delim);
            }
            s.append(v[i]);
        }
        return s.toString();
    }

    public static final void writeStream(InputStream in, OutputStream out) throws IOException {
        byte[] b = new byte[16384];
        int count = in.read(b);
        while (count > 0) {
            out.write(b, 0, count);
            count = in.read(b);
        }
    }

    public static final void writeStream(InputStream in, OutputStream out, int size) throws IOException {
        byte[] b = new byte[16384];
        int m = size < b.length ? size : b.length;
        int count = in.read(b, 0, m);
        while (count > 0) {
            out.write(b, 0, count);
            m = (size -= count) < b.length ? size : b.length;
            count = in.read(b, 0, m);
        }
    }

    public static final void writeReader(Reader in, Writer out) throws IOException {
        char[] c = new char[16384];
        int count = in.read(c);
        while (count > 0) {
            out.write(c, 0, count);
            count = in.read(c);
        }
    }

    public static final String getFilename(URL url) {
        String filename = url.getFile();
        int p = filename.lastIndexOf(47);
        if (p != -1) {
            filename = filename.substring(p + 1);
        }
        return filename;
    }

    public static final void deleteOldFiles(File dir, long ms) {
        if (dir.exists()) {
            File[] file = dir.listFiles();
            for (int i = 0; i < file.length; ++i) {
                File f = file[i];
                long modified = f.lastModified();
                long now = System.currentTimeMillis();
                if ((modified += ms) > now) continue;
                f.delete();
            }
        }
    }

    public static final Date getTimeOnly(Date date) {
        return new Date(date.getTime() % 86400000L);
    }

    public static final Date getDateOnly(Date date) {
        long x = date.getTime();
        long y = x % 86400000L;
        return new Date(x - y);
    }

    public static final Date getTime(int hours, int minutes, int seconds, int milliseconds) {
        long ms = hours * 60 * 60 * 1000;
        ms += (long)(minutes * 60 * 1000);
        ms += (long)(seconds * 1000);
        return new Date(ms += (long)milliseconds);
    }

    public static final Date getTime(int hours, int minutes) {
        return Util.getTime(hours, minutes, 0, 0);
    }

    public static final String properCase(String s) {
        if (s != null && s.length() > 0) {
            s = Character.toUpperCase(s.charAt(0)) + s.substring(1);
        }
        return s;
    }

    public static final String escapeMarkup(String s) {
        if (s == null) {
            return "";
        }
        s = Util.replace(s, "&", "&amp;");
        s = Util.replace(s, "<", "&lt;");
        s = Util.replace(s, ">", "&gt;");
        return s;
    }

    public static final String escapeMarkupAttribute(String s) {
        return Util.replace(Util.escapeMarkup(s), "\"", "&quot;");
    }

    public static final String getFileExt(String filename) {
        int i = filename.lastIndexOf(46);
        return i == -1 ? "" : filename.substring(i);
    }

    public static final String changeFileExt(String filename, String ext) {
        int i = filename.lastIndexOf(46);
        i = i == -1 ? filename.length() : i;
        return filename.substring(0, i) + ext;
    }

    public static final String getResourceString(Object obj, String filename) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
        InputStream in = obj.getClass().getResourceAsStream(filename);
        Util.writeStream(in, out);
        in.close();
        return out.toString("ISO-8859-1");
    }

    public static final Date getBirthDay(String s) {
        Date d = null;
        if (s != null && s.length() == 10) {
            int day = Integer.parseInt(s.substring(0, 2));
            int month = Integer.parseInt(s.substring(2, 4)) - 1;
            int c = s.charAt(9) - 48;
            int year = 1900;
            if (c == 8) {
                year = 1800;
            } else if (c != 9) {
                year = 2000 + 100 * c;
            }
            Calendar cal = Calendar.getInstance();
            cal.set(year += Integer.parseInt(s.substring(4, 6)), month, day, 0, 0, 0);
            d = cal.getTime();
        }
        return d;
    }

    public static final File getTempDirectory() {
        File tmp = new File(System.getProperty("java.io.tmpdir"));
        if (!(tmp.exists() || (tmp = new File(File.separatorChar + "temp")).exists() || (tmp = new File(File.separatorChar + "tmp")).exists())) {
            tmp.mkdir();
        }
        return tmp;
    }

    public static final File createTempFile(String filename) throws IOException {
        return Util.createTempFile(Util.getTempDirectory(), filename);
    }

    public static final synchronized File createTempFile(File dir, String filename) throws IOException {
        File file = new File(dir, filename);
        if (file.exists()) {
            String name = Util.changeFileExt(filename, "");
            String ext = Util.getFileExt(filename);
            int i = 0;
            file = new File(dir, name + i + ext);
            while (file.exists()) {
                file = new File(dir, name + ++i + ext);
            }
        }
        FileOutputStream out = new FileOutputStream(file);
        out.close();
        return file;
    }

    public static final boolean hasControlChar(String s) {
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c >= ' ' && c != '\u007f') continue;
                return true;
            }
        }
        return false;
    }

    public static final String getTextFile(String filename) throws IOException {
        File file = new File(filename);
        BufferedReader in = new BufferedReader(new FileReader(file));
        StringWriter out = new StringWriter((int)file.length());
        Util.writeReader(in, out);
        return out.toString();
    }

    public static final String trimWords(String s) {
        StringBuffer t = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            int j;
            while (Character.isWhitespace(s.charAt(i))) {
                if (++i < s.length()) continue;
                return t.toString();
            }
            if (t.length() != 0) {
                t.append(' ');
            }
            for (j = i + 1; j < s.length() && !Character.isWhitespace(s.charAt(j)); ++j) {
            }
            t.append(s.substring(i, j));
            i = j;
        }
        return t.toString();
    }

    public static final String stripMarkup(String s) {
        String v;
        StringBuffer t = new StringBuffer(s.length());
        int p1 = 0;
        int p2 = s.indexOf(60);
        while (p2 > -1) {
            v = s.substring(p1, p2).trim();
            if (t.length() != 0 && v.length() != 0) {
                t.append(' ');
            }
            t.append(v);
            p1 = s.indexOf(62, p2 + 1) + 1;
            if (p1 == 0) {
                p1 = s.length();
                break;
            }
            p2 = s.indexOf(60, p1);
        }
        v = s.substring(p1).trim();
        if (t.length() != 0 && v.length() != 0) {
            t.append(' ');
        }
        t.append(v);
        return t.toString();
    }

    public static final boolean isSupportedCharset(String charset) {
        try {
            new String(new byte[]{10}, charset);
            return true;
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
    }

    public static final String wget(String url) throws IOException {
        URLConnection c = new URL(url).openConnection();
        InputStream in = c.getInputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Util.writeStream(in, out);
        in.close();
        return out.toString();
    }

    public static String convertToDhtmlxDateFormat(String format) {
        String retFormat = format;
        retFormat = Util.replace(retFormat, "MMMM", "%M");
        retFormat = Util.replace(retFormat, "MMM", "%b");
        if ((retFormat = Util.replace(retFormat, "MM", "%m")).indexOf("%M") == -1) {
            retFormat = Util.replace(retFormat, "M", "%c");
        }
        retFormat = Util.replace(retFormat, "yyyy", "%Y");
        retFormat = Util.replace(retFormat, "yy", "%y");
        if ((retFormat = Util.replace(retFormat, "dd", "%d")).indexOf("%d") == -1) {
            retFormat = Util.replace(retFormat, "d", "%e");
        }
        return retFormat;
    }

    public static final String getDatePattern(int style, Locale loc) {
        DateFormat df = loc == null ? DateFormat.getDateInstance(style) : DateFormat.getDateInstance(style, loc);
        if (df instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)df).toPattern();
        }
        Calendar c = Calendar.getInstance(loc);
        c.set(1234, 4, 6);
        String s = df.format(c.getTime());
        s = Util.replace(s, "1234", "yyyy");
        s = Util.replace(s, "34", "yy");
        s = Util.replace(s, "05", "MM");
        s = Util.replace(s, "5", "M");
        s = Util.replace(s, "06", "dd");
        s = Util.replace(s, "6", "d");
        return s;
    }
}

