/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.util;

import is.hugvit.util.ArrayListEx;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;

public final class HashtableEx
extends Hashtable {
    private ArrayListEx v;

    public HashtableEx() {
        this.v = new ArrayListEx();
    }

    public HashtableEx(int initialCapacity) {
        super(initialCapacity);
        this.v = new ArrayListEx(initialCapacity);
    }

    public HashtableEx(Hashtable h) {
        super(h.size());
        this.v = new ArrayListEx(h.size());
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = h.get(key);
            if (value != null) {
                super.put(key, value);
            }
            this.v.addElement(key);
        }
    }

    public HashtableEx(HashMap h) {
        super(h.size());
        this.v = new ArrayListEx(h.size());
        for (Object key : h.keySet()) {
            Object value = h.get(key);
            if (value != null) {
                super.put(key, value);
            }
            this.v.addElement(key);
        }
    }

    @Override
    public final Object put(Object key, Object value) {
        if (!this.v.contains(key)) {
            this.v.addElement(key);
        }
        if (value == null) {
            return super.remove(key);
        }
        return super.put(key, value);
    }

    @Override
    public final void clear() {
        this.v.removeAllElements();
        super.clear();
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.v.contains(key);
    }

    @Override
    public final Object remove(Object key) {
        this.v.removeElement(key);
        return super.remove(key);
    }

    public final boolean retainAll(Hashtable h) {
        boolean changed = false;
        Iterator i = this.v.iterator();
        while (i.hasNext()) {
            Object key = i.next();
            if (h.containsKey(key)) continue;
            i.remove();
            super.remove(key);
            changed = true;
        }
        return changed;
    }

    @Override
    public final int size() {
        return this.v.size();
    }

    @Override
    public final Enumeration keys() {
        return this.v.elements();
    }

    @Override
    public final String toString() {
        StringBuffer s = new StringBuffer(this.v.size() * 8);
        s.append('{');
        Enumeration e = this.v.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            if (i > 0) {
                s.append(',');
            }
            String key = (String)e.nextElement();
            s.append(key);
            s.append('=');
            Object obj = this.get(key);
            if (obj == null) {
                s.append("null");
            } else {
                s.append(obj.toString());
            }
            ++i;
        }
        s.append('}');
        return s.toString();
    }

    public final String toString(char delimeter) {
        StringBuffer s = new StringBuffer(this.size() * 16);
        Enumeration i = this.v.elements();
        int pos = 0;
        while (i.hasMoreElements()) {
            Object key = i.nextElement();
            Object value = this.get(key);
            if (pos > 0) {
                s.append(delimeter);
            }
            s.append(key.toString());
            if (value != null) {
                s.append('=');
                s.append(value.toString());
            }
            ++pos;
        }
        return s.toString();
    }
}

