/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.util;

import is.hugvit.util.CacheEntry;
import is.hugvit.util.CacheIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public final class Cache {
    private HashMap cache;
    private final LinkedList mru = new LinkedList();
    private long expire_time;
    private int max;

    public Cache(int max) {
        this.max = max;
        this.cache = new HashMap(max);
    }

    public Cache(int max, int minutes) {
        this.max = max;
        this.cache = new HashMap(max);
        this.setExpireTime(minutes);
    }

    public final void setExpireTime(int minutes) {
        this.expire_time = minutes * 60 * 1000;
    }

    private final boolean isExpired(long ms) {
        return this.expire_time > 0L && System.currentTimeMillis() - ms > this.expire_time;
    }

    public final synchronized Object get(Object id) {
        CacheEntry c = (CacheEntry)this.cache.get(id);
        if (c != null && !this.isExpired(c.timestamp)) {
            this.mru.remove(id);
            this.mru.addFirst(id);
            return c.data;
        }
        return null;
    }

    public final synchronized Object getExpired(Object id) {
        CacheEntry c = (CacheEntry)this.cache.get(id);
        if (c != null) {
            return c.data;
        }
        return null;
    }

    public final synchronized void put(Object id, Object data) {
        this.cache.remove(id);
        this.mru.remove(id);
        CacheEntry c = new CacheEntry();
        c.data = data;
        c.timestamp = System.currentTimeMillis();
        if (this.cache.size() >= this.max) {
            this.cache.remove(this.mru.removeLast());
        }
        this.cache.put(id, c);
        this.mru.addFirst(id);
    }

    public final synchronized void clear() {
        this.mru.clear();
        this.cache.clear();
    }

    public final synchronized void setSize(int max) {
        if (this.max != max) {
            this.mru.clear();
            this.cache.clear();
            this.max = max;
            this.cache = new HashMap(max);
        }
    }

    public final Iterator keys() {
        return this.cache.keySet().iterator();
    }

    public final Iterator iterator() {
        return new CacheIterator(this.cache.values().iterator());
    }

    public final synchronized void remove(Object id) {
        this.mru.remove(id);
        this.cache.remove(id);
    }

    public final synchronized String toString() {
        StringBuffer s = new StringBuffer(this.cache.size() + 2);
        s.append('{');
        int i = 0;
        for (CacheEntry cacheEntry : this.cache.entrySet()) {
            if (i > 0) {
                s.append(',');
            }
            s.append(cacheEntry.data.toString());
            ++i;
        }
        s.append('}');
        return this.mru.toString() + ' ' + s.toString();
    }
}

