/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.thread;

import is.hugvit.log.Log;
import is.hugvit.net.SMS;
import is.hugvit.net.SMTP;
import is.hugvit.thread.ThreadContext;
import is.hugvit.thread.ThreadData;
import is.hugvit.thread.ThreadDataStore;
import is.hugvit.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;

final class ThreadItem
extends ThreadData
implements Runnable,
ThreadContext,
Log {
    private static final long DAY = 86400000L;
    private static final String FROM_ADDRESS = "ScheduleManager@hugvit.is";
    private static final String FROM_NAME = "Schedule Manager";
    private static boolean INITIAL_RUN = true;
    private long lastrun;
    private Thread thread;
    private final StringBuffer log = new StringBuffer(1024);
    private final StringBuffer result = new StringBuffer(1024);
    private Date createdate;
    private ThreadDataStore ds;
    private int log_counter;
    Runnable runner;

    public ThreadItem(ThreadDataStore ds) {
        this.ds = ds;
        this.createdate = new Date();
    }

    public final void setParameter(String name, String value) {
        this.prop.put(name, value);
    }

    final void update(ThreadData item) {
        this.server = item.server;
        this.name = item.name;
        this.classname = item.classname;
        this.log_level = item.log_level;
        this.log_console = item.log_console;
        this.mailresult = item.mailresult;
        this.email = item.email;
        this.sms = item.sms;
        this.enabled = item.enabled;
        this.run = item.run;
        this.ms = item.ms;
        this.starttime = item.starttime;
        this.startdate = item.startdate;
        this.stopdate = item.stopdate;
        this.prop = item.prop;
        this.mailserver = item.mailserver;
        this.day = item.day;
    }

    final boolean isReady() {
        return this.thread == null && this.getSleepTime() == 0L;
    }

    @Override
    public final boolean isRunning() {
        return this.thread != null;
    }

    final long getSleepTime() {
        if (!this.enabled) {
            return -1L;
        }
        Date now = new Date();
        if (this.stopdate != null && this.stopdate.before(now)) {
            return -1L;
        }
        if (this.startdate != null && this.startdate.after(now)) {
            return -1L;
        }
        if (this.run.equals("ONCE") || this.run.equals("STARTUP")) {
            if (this.lastrun != 0L) {
                return -1L;
            }
        } else {
            if (this.run.equals("MINUTE") || this.run.equals("INTERVAL")) {
                long t = now.getTime() - this.lastrun;
                if ((t = this.ms - t) < 0L) {
                    t = 0L;
                }
                return t;
            }
            if (this.run.equals("DAY")) {
                if (this.starttime != null) {
                    Date rundate = new Date(Util.getDateOnly(now).getTime() + this.starttime.getTime());
                    Date checkdate = this.createdate;
                    if (this.lastrun != 0L) {
                        checkdate = new Date(this.lastrun);
                    }
                    if (checkdate.before(rundate) && (now.after(rundate) || now.equals(rundate))) {
                        return 0L;
                    }
                    long s = rundate.getTime() - now.getTime();
                    if (s < 0L) {
                        s += 86400000L;
                    }
                    if (s < 0L) {
                        s = 0L;
                    }
                    return s;
                }
            } else if (this.run.equals("WEEK") && this.starttime != null) {
                Calendar c = Calendar.getInstance();
                c.setTime(now);
                long time = this.starttime.getTime();
                int minutes = (int)(time / 60000L);
                int hours = minutes / 60;
                c.set(11, hours);
                c.set(12, minutes %= 60);
                c.set(13, 0);
                c.set(14, 0);
                c.set(7, this.day + 1);
                Date rundate = c.getTime();
                Date checkdate = this.createdate;
                if (this.lastrun != 0L) {
                    checkdate = new Date(this.lastrun);
                }
                if (rundate.before(checkdate) || rundate.equals(checkdate)) {
                    c.add(5, 7);
                    rundate = c.getTime();
                }
                if (checkdate.before(rundate) && (now.after(rundate) || now.equals(rundate))) {
                    return 0L;
                }
                long s = rundate.getTime() - now.getTime();
                return s;
            }
        }
        return 0L;
    }

    @Override
    public final void start() {
        try {
            this.result.setLength(0);
            if (this.thread == null) {
                Date date = new Date();
                this.lastrun = date.getTime();
                if (this.runner == null) {
                    this.runner = (Runnable)Class.forName(this.classname).newInstance();
                }
                this.thread = new Thread(this);
                this.ds.setLastRun(this.name, date);
                this.thread.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error(e);
            this.flushLog();
        }
    }

    @Override
    public final void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    @Override
    public void run() {
        this.info("ThreadManager:Start:" + this.name);
        try {
            this.runner.run();
        }
        finally {
            this.thread = null;
        }
        this.info("ThreadManager:Stop:" + this.name);
        this.sendResult();
        this.flushLog();
    }

    private final void flushLog() {
        try {
            if (this.log.length() > 0) {
                this.ds.appendLog(this.name, this.log.toString());
                this.log.setLength(0);
                this.log_counter = 0;
            }
        }
        catch (Exception e) {
            System.out.println("ThreadManager:Unable to flush log");
            e.printStackTrace();
        }
    }

    private final void sendResult() {
        if (this.mailresult) {
            try {
                SMTP mail = new SMTP(this.mailserver);
                mail.setFrom(FROM_ADDRESS);
                mail.setFromName(FROM_NAME);
                mail.setSubject(this.name);
                mail.setBody(this.result.toString());
                Enumeration e = this.email.elements();
                while (e.hasMoreElements()) {
                    String s = (String)e.nextElement();
                    mail.send(s);
                    Thread.sleep(100L);
                }
                mail.close();
                this.log(0, "Sending results to " + this.email, null);
            }
            catch (Exception e2) {
                this.log(3, "Unable to send mail", e2);
            }
        }
    }

    @Override
    public final void log(int level, String message, Exception e) {
        if (this.log_level <= level) {
            String timeinfo = Util.dateTimeToShort(new Date());
            StringBuffer s = new StringBuffer(128);
            s.append(Log.names[level]);
            s.append(' ');
            s.append(message);
            this.log.append(timeinfo + " " + s.toString());
            this.log.append('\n');
            this.result.append(timeinfo + " " + s.toString());
            this.result.append('\n');
            if (this.log_console) {
                if (this.ds.getClass().getName().equals("is.hugvit.thread.ThreadDataStoreNotes")) {
                    System.out.println(s.toString());
                } else {
                    System.out.println(timeinfo + ' ' + s.toString());
                }
            }
            if (e != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                this.log.append(sw.toString());
                this.log.append("\n");
                this.result.append(sw.toString());
                this.result.append("\n");
                if (this.log_console) {
                    e.printStackTrace();
                }
            }
            if (level >= 1 || this.log_counter > 10) {
                this.flushLog();
            }
            ++this.log_counter;
        }
    }

    @Override
    public final void error(Exception e) {
        this.log(3, e.getMessage(), e);
        this.notifyError(e.getMessage(), e);
    }

    @Override
    public final void error(String msg) {
        this.log(3, msg, null);
        this.notifyError(msg, null);
    }

    @Override
    public final void error(String msg, Exception e) {
        this.log(3, msg, e);
        this.notifyError(msg, e);
    }

    private final void notifyError(String msg, Exception e) {
        StringWriter s = new StringWriter();
        if (e != null) {
            e.printStackTrace(new PrintWriter(s));
        }
        String subject = "Error in: " + this.name + ": " + msg;
        String body = s.toString();
        if (this.email.size() > 0) {
            try {
                if (!this.mailserver.equals("")) {
                    SMTP mail = new SMTP(this.mailserver);
                    mail.setFrom(FROM_ADDRESS);
                    mail.setFromName(FROM_NAME);
                    mail.setSubject(subject);
                    mail.setBody(body);
                    Enumeration en = this.email.elements();
                    while (en.hasMoreElements()) {
                        String em = (String)en.nextElement();
                        if (em.equals("")) continue;
                        mail.send(em);
                        Thread.sleep(100L);
                    }
                    mail.close();
                    this.log(0, "Sending email to: " + this.email, null);
                }
            }
            catch (Exception e2) {
                this.log(3, "Unable to send mail", e2);
            }
        }
        if (!this.sms.equals("")) {
            try {
                SMS.send(this.sms, subject);
                this.log(0, "Sending SMS to: " + this.sms, null);
            }
            catch (IOException e2) {
                this.log(3, "Unable to send sms", e2);
            }
        }
    }

    @Override
    public final void info(String msg) {
        this.log(1, msg, null);
    }

    @Override
    public final void warn(String msg) {
        this.log(2, msg, null);
    }

    @Override
    public final void warn(String msg, Exception e) {
        this.log(2, msg, e);
    }

    @Override
    public final void debug(String msg) {
        this.log(0, msg, null);
    }

    @Override
    public final Log getLog() {
        return this;
    }

    public final void setLog(Log log) {
    }

    @Override
    public final void setLevel(int level) {
        this.log_level = level;
    }

    @Override
    public final int getLevel() {
        return this.log_level;
    }
}

