/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public final class NativeTypes {
    private final HashMap h = new HashMap(16);
    private static final ArrayList clobtypes = new ArrayList();
    private static final ArrayList lvtypes = new ArrayList();
    private static final ArrayList blobtypes = new ArrayList();
    private static final ArrayList datetypes = new ArrayList();
    private static final ArrayList timetypes = new ArrayList();
    private static final ArrayList tstypes = new ArrayList();
    private boolean is_db2;
    static final HashMap stypes = new HashMap(16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeTypes(Connection c) throws SQLException {
        DatabaseMetaData meta = c.getMetaData();
        HashMap<String, Object> n = new HashMap<String, Object>(64);
        String product_name = meta.getDatabaseProductName();
        this.is_db2 = product_name.startsWith("DB2");
        try (ResultSet rs = meta.getTypeInfo();){
            while (rs.next()) {
                String s = rs.getString(1).toLowerCase();
                n.put(s, null);
            }
        }
        if (this.is_db2) {
            n.put("long varchar", null);
        }
        this.h.put(new Integer(4), "integer");
        this.h.put(new Integer(1), "char");
        this.h.put(new Integer(12), "varchar");
        this.h.put(new Integer(91), NativeTypes.getBestMatch(n, datetypes));
        this.h.put(new Integer(92), NativeTypes.getBestMatch(n, timetypes));
        this.h.put(new Integer(93), NativeTypes.getBestMatch(n, tstypes));
        this.h.put(new Integer(-1), NativeTypes.getBestMatch(n, lvtypes));
        this.h.put(new Integer(-4), "long vargraphic");
        this.h.put(new Integer(2005), NativeTypes.getBestMatch(n, clobtypes));
        this.h.put(new Integer(2004), NativeTypes.getBestMatch(n, blobtypes));
    }

    private static final String getBestMatch(HashMap n, ArrayList list) {
        for (String s : list) {
            if (!n.containsKey(s)) continue;
            return s;
        }
        return (String)list.get(0);
    }

    private final String getNativeString(Object type) {
        StringBuffer s = new StringBuffer(16);
        String stype = (String)this.h.get(type);
        s.append(stype);
        if (this.is_db2) {
            if (stype.equals("clob")) {
                s.append("(1048576)");
            } else if (stype.equals("blob")) {
                s.append("(134217728)");
            }
        }
        if (stype.equals("varchar")) {
            s.append("(255)");
        }
        return s.toString();
    }

    public final String getString(int type) {
        return this.getNativeString(new Integer(type));
    }

    public final String getString(String type) {
        Integer i = (Integer)stypes.get(type);
        if (i != null) {
            type = this.getNativeString(i);
        }
        return type;
    }

    public final int getInt(int type) {
        String stype = (String)this.h.get(new Integer(type));
        Integer i = (Integer)stypes.get(stype);
        if (i != null) {
            type = i;
        }
        return type;
    }

    public final boolean isDb2() throws SQLException {
        return this.is_db2;
    }

    static {
        stypes.put("integer", new Integer(4));
        stypes.put("char", new Integer(1));
        stypes.put("date", new Integer(91));
        stypes.put("time", new Integer(92));
        stypes.put("timestamp", new Integer(93));
        stypes.put("blob", new Integer(2004));
        stypes.put("clob", new Integer(2005));
        stypes.put("longvarbinary", new Integer(-4));
        stypes.put("longvarchar", new Integer(-1));
        stypes.put("varchar", new Integer(12));
        stypes.put("long varchar", new Integer(-1));
        clobtypes.add("clob");
        clobtypes.add("longtext");
        clobtypes.add("text");
        clobtypes.add("longchar");
        clobtypes.add("long varchar");
        clobtypes.add("longvarchar");
        lvtypes.add("longvarchar");
        lvtypes.add("text");
        lvtypes.add("longchar");
        lvtypes.add("long varchar");
        lvtypes.add("clob");
        lvtypes.add("varchar");
        blobtypes.add("longblob");
        blobtypes.add("blob");
        blobtypes.add("long raw");
        blobtypes.add("image");
        blobtypes.add("longbinary");
        blobtypes.add("longvarbinary");
        blobtypes.add("varbinary");
        datetypes.add("date");
        datetypes.add("datetime");
        timetypes.add("time");
        timetypes.add("datetime");
        timetypes.add("date");
        tstypes.add("datetime");
        tstypes.add("timestamp");
        tstypes.add("date");
    }
}

