/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.net;

import is.hugvit.net.SMTPException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;

public final class SMTP {
    private static String localhost = "localhost";
    private String from = "Unknown";
    private String fromname;
    private Socket socket;
    private BufferedReader in;
    private OutputStream out;
    private String subject;
    private String body;
    private String content_type;
    private String charset;
    private Properties p = new Properties();
    private boolean debug = false;

    public SMTP() throws IOException {
        this(null);
    }

    public SMTP(String host) throws IOException {
        this(host, false);
    }

    public SMTP(String host, boolean debug) throws IOException {
        this.debug = debug;
        String mailhost = host == null ? localhost : host;
        this.socket = new Socket(mailhost, 25);
        this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.out = this.socket.getOutputStream();
        this.checkResponse();
        this.sendString("HELO " + localhost);
    }

    public final void setHeader(String name, String value) {
        this.p.put(name, value);
    }

    public final void setDebug(boolean debug) {
        this.debug = debug;
    }

    public final void setFrom(String from) {
        this.from = from;
    }

    public final void setFromName(String name) {
        this.fromname = name;
    }

    public final void setContentType(String type) {
        this.content_type = type;
    }

    public final void setCharset(String charset) {
        this.charset = charset;
    }

    public final void setSubject(String subject) {
        this.subject = subject;
    }

    public final void setBody(String body) {
        this.body = body;
    }

    private final void checkResponse() throws IOException {
        String t = this.in.readLine();
        if (this.debug) {
            System.out.println(t);
        }
        if (t.equals("") || t.length() < 5) {
            throw new SMTPException("Invalid response");
        }
        int result = Integer.parseInt(t.substring(0, 3));
        if (result >= 400) {
            throw new SMTPException(result, t.substring(4));
        }
    }

    private final void sendString(String s, String encoding, boolean response) throws IOException {
        byte[] b = null;
        if (encoding != null) {
            try {
                b = s.getBytes(encoding);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (b == null) {
            b = s.getBytes();
        }
        this.out.write(b);
        this.out.write(13);
        this.out.write(10);
        this.out.flush();
        if (response) {
            this.checkResponse();
        }
    }

    private final void sendString(String s) throws IOException {
        this.sendString(s, null, true);
    }

    public final void send(String to) throws IOException {
        this.sendString("MAIL FROM:" + this.from);
        this.sendString("RCPT TO:" + to);
        this.sendString("DATA");
        if (this.subject != null) {
            this.sendString("Subject: " + this.subject, this.charset, false);
        }
        this.sendString("To: " + to, null, false);
        if (this.fromname != null) {
            this.sendString("From: " + this.fromname + " <" + this.from + '>', this.charset, false);
        }
        String ct = "text/plain";
        if (this.content_type != null) {
            ct = this.content_type;
        }
        if (this.charset != null) {
            ct = ct + "; charset=" + this.charset;
        }
        this.sendString("Content-Type: " + ct, null, false);
        Enumeration<Object> e = this.p.elements();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = this.p.getProperty(name);
            if (value.equals("")) continue;
            this.sendString(name + ": " + value, this.charset, false);
        }
        this.sendString("", null, false);
        if (this.body != null) {
            this.sendString(this.body, this.charset, false);
        }
        this.sendString(".");
    }

    public final void close() throws IOException {
        if (this.socket != null) {
            this.sendString("QUIT");
            this.socket.close();
        }
    }

    static {
        try {
            InetAddress ipaddress = InetAddress.getLocalHost();
            String s = ipaddress.getHostName();
            if (s != null) {
                localhost = s;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }
}

