/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.net;

import is.hugvit.net.URLEncoder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public final class HTTPClient {
    private Properties cookies = new Properties();
    private String host;
    private int port = 80;
    private String referer;

    public HTTPClient(String host) {
        this.host = host;
    }

    public HTTPClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    private static final void writeRequest(URLConnection conn, Properties p) {
        if (p != null) {
            Enumeration<Object> e = p.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = p.getProperty(key);
                conn.setRequestProperty(key, value);
            }
        }
    }

    private static final void readInput(URLConnection conn, Writer out) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        int c = ((Reader)in).read();
        while (c != -1) {
            if (out != null) {
                out.write((char)c);
            }
            c = ((Reader)in).read();
        }
        ((Reader)in).close();
    }

    private static final void writePost(URLConnection conn, Properties p) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream()));
        Enumeration<Object> e = p.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = p.getProperty(key);
            out.write(key + "=" + URLEncoder.encode(value));
            if (!e.hasMoreElements()) continue;
            out.write("&");
        }
        ((Writer)out).close();
    }

    private final void readCookies(URLConnection conn) {
        String s;
        int i;
        StringTokenizer st;
        String cookie = conn.getHeaderField("SET-COOKIE");
        if (cookie != null && (st = new StringTokenizer(cookie, ";")).hasMoreTokens() && (i = (s = st.nextToken()).indexOf(61)) > -1) {
            String name = s.substring(0, i).trim();
            String value = s.substring(i + 1).trim();
            this.cookies.put(name, value);
        }
    }

    private final void writeCookies(URLConnection conn) {
        if (!this.cookies.isEmpty()) {
            StringBuffer s = new StringBuffer(this.cookies.size() * 16);
            Enumeration<Object> e = this.cookies.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = this.cookies.getProperty(name);
                s.append(name + "=" + value);
                if (!e.hasMoreElements()) continue;
                s.append(';');
            }
            conn.setRequestProperty("COOKIE", s.toString());
        }
    }

    private final String getHostName() {
        StringBuffer s = new StringBuffer("http://");
        s.append(this.host);
        if (this.port != 80) {
            s.append(":" + this.port);
        }
        return s.toString();
    }

    private final void writeReferer(URLConnection conn) {
        if (this.referer != null) {
            conn.setRequestProperty("REFERER", this.referer);
        }
    }

    public final void doGet(String path) throws IOException {
        this.doGet(path, null, null);
    }

    public final void doGet(String path, Properties h) throws IOException {
        this.doGet(path, h, null);
    }

    public final void doGet(String path, Writer out) throws IOException {
        this.doGet(path, null, out);
    }

    public final void doPost(String path, Properties h, Properties p) throws IOException {
        this.doPost(path, h, p, null);
    }

    public final void doPost(String path, Properties p, Writer out) throws IOException {
        this.doPost(path, null, p, out);
    }

    public final void doPost(String path, Properties p) throws IOException {
        this.doPost(path, null, p, null);
    }

    public final void setReferer(String referer) {
        this.referer = referer;
    }

    public final void doGet(String path, Properties req, Writer out) throws IOException {
        String url = this.getHostName() + path;
        URLConnection conn = new URL(url).openConnection();
        this.writeReferer(conn);
        HTTPClient.writeRequest(conn, req);
        this.writeCookies(conn);
        this.readCookies(conn);
        HTTPClient.readInput(conn, out);
        this.referer = url;
    }

    public final void doPost(String path, Properties req, Properties data, Writer out) throws IOException {
        String url = this.getHostName() + path;
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestMethod("POST");
        this.writeReferer(conn);
        HTTPClient.writeRequest(conn, req);
        this.writeCookies(conn);
        HTTPClient.writePost(conn, data);
        this.readCookies(conn);
        HTTPClient.readInput(conn, out);
        this.referer = url;
    }
}

