/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public final class ReaderInputStream
extends InputStream {
    private static final int DEFAULT_SIZE = 2048;
    private Reader in;
    private String enc;
    private char[] cbuf;
    private byte[] bbuf;
    private int pos;
    private int count;

    public ReaderInputStream(Reader in) {
        this(in, null, 2048);
    }

    public ReaderInputStream(Reader in, String enc) {
        this(in, enc, 2048);
    }

    public ReaderInputStream(InputStream in, String enc1, String enc2) throws UnsupportedEncodingException {
        this(new InputStreamReader(in, enc1), enc2, 2048);
    }

    public ReaderInputStream(Reader in, String enc, int size) {
        this.in = in;
        this.enc = enc;
        this.cbuf = new char[size];
    }

    @Override
    public final int read() throws IOException {
        this.fillBuffer();
        return this.count > 0 ? this.bbuf[this.pos++] : -1;
    }

    @Override
    public final int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    private final void fillBuffer() throws IOException {
        int size = this.count - this.pos;
        if (size == 0) {
            this.pos = 0;
            this.count = this.in.read(this.cbuf);
            if (this.count != -1) {
                String s = new String(this.cbuf, 0, this.count);
                this.bbuf = this.enc == null ? s.getBytes() : s.getBytes(this.enc);
                this.count = this.bbuf.length;
            }
        }
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        int x;
        int result = -1;
        this.fillBuffer();
        int size = this.count - this.pos;
        int n = x = size < len ? size : len;
        while (this.count != -1 && x > 0) {
            System.arraycopy(this.bbuf, this.pos, b, off, x);
            off += x;
            this.pos += x;
            result += x;
            this.fillBuffer();
            size = this.count - this.pos;
            x = size < (len -= x) ? size : len;
        }
        if (result > -1) {
            ++result;
        }
        return result;
    }

    @Override
    public final void reset() throws IOException {
        this.in.reset();
        this.pos = 0;
        this.count = 0;
    }

    @Override
    public final long skip(long n) throws IOException {
        int m = 0;
        int size = this.count - this.pos;
        while (size != -1 && n > (long)size) {
            m += this.count;
            this.count = 0;
            this.pos = 0;
            n -= (long)size;
            this.fillBuffer();
            size = this.count;
        }
        if (this.count == -1) {
            this.pos = (int)((long)this.pos + n);
            m = (int)((long)m + n);
        }
        return m;
    }

    @Override
    public final int available() throws IOException {
        this.fillBuffer();
        return this.count - this.pos;
    }

    @Override
    public final void close() throws IOException {
        this.in.close();
    }
}

