/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.datapump;

import is.hugvit.datapump.ConstantField;
import is.hugvit.datapump.Criteria;
import is.hugvit.datapump.DataException;
import is.hugvit.datapump.DataPumpErrorListener;
import is.hugvit.datapump.DataPumpListener;
import is.hugvit.datapump.DataSource;
import is.hugvit.datapump.DataTarget;
import is.hugvit.datapump.Field;
import is.hugvit.datapump.Transformation;
import is.hugvit.io.ResourceLocator;
import is.hugvit.log.Log;
import is.hugvit.log.SystemLog;
import is.hugvit.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public final class XMLDataPump {
    private static final Hashtable mtype = new Hashtable();
    private static final Hashtable methods = new Hashtable();
    private Log log = new SystemLog();
    private final Hashtable classes = new Hashtable();
    private final Vector trans = new Vector();

    private static final Properties getMappings(Element e) throws Exception {
        Properties p = new Properties();
        Iterator iter = e.elementIterator("mapping");
        while (iter.hasNext()) {
            Element e2 = (Element)iter.next();
            String n = e2.elementText("source");
            String v = e2.elementText("target");
            p.put(v, n);
        }
        return p;
    }

    private static final Properties getParameters(Element e) throws Exception {
        Properties p = new Properties();
        Iterator iter = e.elementIterator("parameter");
        while (iter.hasNext()) {
            Element e2 = (Element)iter.next();
            String n = e2.elementText("name");
            String v = e2.elementText("value");
            p.put(n, v);
        }
        return p;
    }

    private static final Vector getFields(Element e) throws Exception {
        String n;
        Element e2;
        Vector<Field> h = new Vector<Field>();
        Iterator iter = e.elementIterator("field");
        while (iter.hasNext()) {
            Integer type_int;
            e2 = (Element)iter.next();
            n = e2.elementText("name");
            String a = e2.elementText("alias");
            String t = e2.elementText("type");
            if (t == null) {
                t = "string";
            }
            if ((type_int = (Integer)mtype.get(t)) == null) {
                throw new DataException("Type " + t + " not recognized");
            }
            int type = type_int;
            Properties p = new Properties();
            Iterator i2 = e2.elementIterator("property");
            while (i2.hasNext()) {
                Element r = (Element)i2.next();
                String n2 = r.attributeValue("name");
                String v = r.attributeValue("value");
                p.put(n2, v);
            }
            h.addElement(new Field(n, a, type, p));
        }
        iter = e.elementIterator("constantfield");
        while (iter.hasNext()) {
            int type;
            e2 = (Element)iter.next();
            n = e2.elementText("name");
            String t = e2.elementText("type");
            Object v = e2.elementText("value");
            if (t == null) {
                t = "string";
            }
            if ((type = ((Integer)mtype.get(t)).intValue()) == 1) {
                v = new Integer((String)v);
            }
            h.addElement(new ConstantField(n, v));
        }
        return h;
    }

    public final void setLog(Log log) {
        this.log = log;
    }

    private static final String getXSL_URL(String xsl_url) throws IOException {
        URL url = new URL(xsl_url);
        ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
        InputStream in = url.openStream();
        Util.writeStream(in, out);
        return out.toString("ISO-8859-1");
    }

    public final void load(String name, ResourceLocator loc) throws DataException {
        try {
            SAXReader reader = new SAXReader();
            String[] keys = new String[]{name, "DATAPUMP"};
            String in = (String)loc.get(keys);
            Document doc = reader.read((Reader)new StringReader(in));
            Element root = doc.getRootElement();
            Iterator iter = root.elementIterator("transformation");
            while (iter.hasNext()) {
                Element e2;
                String l;
                String delay;
                String start;
                String status;
                Element e = (Element)iter.next();
                String s = e.elementText("name");
                if (s == null) {
                    s = name;
                }
                Transformation t = new Transformation();
                t.setLog(this.log);
                t.setName(s);
                String max = e.elementText("max");
                if (max != null) {
                    t.setMax(Integer.parseInt(max));
                }
                if ((status = e.elementText("status")) != null) {
                    t.setStatusInterval(Integer.parseInt(status));
                }
                if ((start = e.elementText("start")) != null) {
                    t.setStart(Integer.parseInt(start));
                }
                if ((delay = e.elementText("delay")) != null) {
                    t.setDelay(Integer.parseInt(delay));
                }
                if ((l = e.elementText("listener")) != null) {
                    DataPumpListener dpl = (DataPumpListener)this.classes.get(l);
                    if (dpl == null) {
                        dpl = (DataPumpListener)Class.forName(l).newInstance();
                        this.classes.put(dpl.getClass().getName(), dpl);
                    }
                    t.setListener(dpl);
                }
                if ((l = e.elementText("error_listener")) != null) {
                    DataPumpErrorListener err = (DataPumpErrorListener)this.classes.get(l);
                    if (err == null) {
                        err = (DataPumpErrorListener)Class.forName(l).newInstance();
                        this.classes.put(err.getClass().getName(), err);
                    }
                    t.setErrorListener(err);
                }
                Element ds_element = e.element("datasource");
                String ds_name = ds_element.elementText("name");
                DataSource ds = this.getDataSource(loc, ds_name);
                Iterator i2 = ds_element.elementIterator("backtag");
                while (i2.hasNext()) {
                    e2 = (Element)i2.next();
                    ds.addBackTag(e2.getText());
                }
                t.setSource(ds);
                i2 = e.elementIterator("datatarget");
                while (i2.hasNext()) {
                    Namespace ns;
                    Element xsl_element;
                    e2 = (Element)i2.next();
                    String dt_name = e2.elementText("name");
                    String xsl_url = e2.elementText("xsl_url");
                    String xsl = null;
                    if (xsl_url != null) {
                        xsl = XMLDataPump.getXSL_URL(xsl_url);
                    }
                    if ((xsl_element = e2.element(new QName("stylesheet", ns = new Namespace("xsl", "http://www.w3.org/1999/XSL/Transform")))) != null) {
                        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                        String xsl_header = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\r\n";
                        out.write(xsl_header.getBytes());
                        OutputFormat format = new OutputFormat("", true, "ISO-8859-1");
                        format.setNewlines(false);
                        XMLWriter xw = new XMLWriter((OutputStream)out, format);
                        xw.write(xsl_element);
                        xsl = out.toString();
                    }
                    Properties p = XMLDataPump.getMappings(e2);
                    t.addTarget(this.getDataTarget(loc, dt_name, p), xsl);
                }
                this.trans.addElement(t);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DataException(e);
        }
    }

    public final void run() throws DataException {
        Enumeration e = this.trans.elements();
        while (e.hasMoreElements()) {
            Transformation t = (Transformation)e.nextElement();
            boolean do_run = true;
            if (t.getListener() != null) {
                do_run = t.getListener().queryRun(t);
            }
            if (!do_run) continue;
            t.run();
        }
    }

    private final DataTarget getDataTarget(ResourceLocator loc, String name, Properties map) throws Exception {
        String crit;
        SAXReader reader = new SAXReader();
        String[] keys = new String[]{name, "DATATARGET"};
        String in = (String)loc.get(keys);
        if (in == null) {
            throw new DataException("DataTarget \"" + name + "\" not found");
        }
        Document doc = reader.read((Reader)new StringReader(in));
        Element root = doc.getRootElement();
        DataTarget dt = (DataTarget)Class.forName(root.elementText("classname")).newInstance();
        dt.setLog(this.log);
        String dt_name = root.elementText("name");
        if (dt_name == null) {
            dt_name = name;
        }
        dt.setName(dt_name);
        String method = root.elementText("method");
        if (method == null) {
            dt.setMethod(0);
        } else {
            Integer mint = (Integer)methods.get(method);
            dt.setMethod(mint);
        }
        Properties p = XMLDataPump.getParameters(root);
        Enumeration<Object> e = p.keys();
        while (e.hasMoreElements()) {
            String n = (String)e.nextElement();
            String v = p.getProperty(n);
            dt.setParameter(n, v);
        }
        String synch = root.elementText("synch");
        if (synch != null) {
            dt.setSynch(synch);
        }
        if ((crit = root.elementText("criteria")) != null) {
            Criteria dpl = (Criteria)this.classes.get(crit);
            if (dpl == null) {
                dpl = (Criteria)Class.forName(crit).newInstance();
                this.classes.put(dpl.getClass().getName(), dpl);
            }
            dt.setCriteria(dpl);
        }
        Vector fields = XMLDataPump.getFields(root);
        e = fields.elements();
        while (e.hasMoreElements()) {
            Field f = (Field)e.nextElement();
            String new_alias = map.getProperty(f.getName());
            if (new_alias != null) {
                f.setAlias(new_alias);
            }
            dt.addField(f);
        }
        Iterator iter = root.elementIterator("key");
        while (iter.hasNext()) {
            Element e2 = (Element)iter.next();
            dt.addKey(e2.getText());
        }
        return dt;
    }

    private final DataSource getDataSource(ResourceLocator loc, String name) throws Exception {
        SAXReader reader = new SAXReader();
        String[] keys = new String[]{name, "DATASOURCE"};
        String in = (String)loc.get(keys);
        if (in == null) {
            throw new DataException("DataSource \"" + name + "\" not found");
        }
        Document doc = reader.read((Reader)new StringReader(in));
        Element root = doc.getRootElement();
        DataSource ds = (DataSource)Class.forName(root.elementText("classname")).newInstance();
        ds.setLog(this.log);
        String ds_name = root.elementText("name");
        if (ds_name == null) {
            ds_name = name;
        }
        ds.setName(ds_name);
        Properties p = XMLDataPump.getParameters(root);
        Enumeration<Object> e = p.keys();
        while (e.hasMoreElements()) {
            String n = (String)e.nextElement();
            String v = p.getProperty(n);
            ds.setParameter(n, v);
        }
        Vector f = XMLDataPump.getFields(root);
        e = f.elements();
        while (e.hasMoreElements()) {
            ds.addField((Field)e.nextElement());
        }
        return ds;
    }

    static {
        mtype.put("string", new Integer(0));
        mtype.put("integer", new Integer(1));
        mtype.put("double", new Integer(2));
        mtype.put("date", new Integer(3));
        mtype.put("time", new Integer(9));
        mtype.put("string", new Integer(0));
        mtype.put("vector", new Integer(4));
        mtype.put("readers", new Integer(5));
        mtype.put("authors", new Integer(6));
        mtype.put("inputstream", new Integer(7));
        mtype.put("item", new Integer(8));
        mtype.put("timestamp", new Integer(10));
        methods.put("create", new Integer(0));
        methods.put("update", new Integer(1));
        methods.put("synch", new Integer(2));
        methods.put("clear_create", new Integer(3));
        methods.put("clear", new Integer(4));
        methods.put("update_only", new Integer(5));
        methods.put("create_only", new Integer(6));
    }
}

