/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.datapump;

import is.hugvit.datapump.Criteria;
import is.hugvit.datapump.DataException;
import is.hugvit.datapump.DataPumpErrorListener;
import is.hugvit.datapump.DataPumpListener;
import is.hugvit.datapump.DataSource;
import is.hugvit.datapump.DataTarget;
import is.hugvit.log.Log;
import is.hugvit.log.NullLog;
import is.hugvit.xml.XMLUtil;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.HTMLWriter;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXContentHandler;
import org.xml.sax.InputSource;

public class Transformation {
    private DataSource source;
    private Vector output = new Vector();
    private Vector xsl_output = new Vector();
    private Log log = new NullLog();
    private DataPumpListener listener;
    private DataPumpErrorListener error_listener;
    private String name = "";
    private int max = -1;
    private long delay = -1L;
    private int start;
    private int interval = -1;
    private static TransformerFactory tf;
    private static OutputFormat format;
    private static DocumentFactory df;

    public Transformation() {
        tf = TransformerFactory.newInstance();
        format = new OutputFormat("", true, "UTF-8");
        format.setNewlines(true);
        df = new DocumentFactory();
    }

    public void setSource(DataSource source) {
        this.source = source;
    }

    public DataSource getSource() {
        return this.source;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public void setStatusInterval(int interval) {
        this.interval = interval;
    }

    public void setDelay(long ms) {
        this.delay = ms;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void addTarget(DataTarget target) {
        this.output.addElement(target);
        this.xsl_output.addElement(null);
    }

    public void addTarget(DataTarget target, String xsl) throws DataException {
        try {
            Templates template = null;
            if (xsl != null) {
                StringReader r = new StringReader(xsl);
                template = tf.newTemplates(new StreamSource(r));
            }
            this.output.addElement(target);
            this.xsl_output.addElement(template);
        }
        catch (Exception e) {
            throw new DataException(e);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public DataTarget getTargetByName(String name) {
        Enumeration e = this.output.elements();
        while (e.hasMoreElements()) {
            DataTarget t = (DataTarget)e.nextElement();
            if (!t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    public Vector getAllTargets() {
        return this.output;
    }

    public String getName() {
        return this.name;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        return this.log;
    }

    public void setListener(DataPumpListener listener) {
        this.listener = listener;
    }

    public void setErrorListener(DataPumpErrorListener listener) {
        this.error_listener = listener;
    }

    public DataPumpListener getListener() {
        return this.listener;
    }

    private final void openTargets() throws DataException {
        Enumeration e = this.output.elements();
        while (e.hasMoreElements()) {
            DataTarget s = (DataTarget)e.nextElement();
            s.open();
        }
    }

    private final void closeAll() {
        try {
            this.source.close();
        }
        catch (DataException e) {
            this.log.error("Can't close datasource: " + this.source.getName(), e);
        }
        Enumeration en = this.output.elements();
        while (en.hasMoreElements()) {
            DataTarget s = (DataTarget)en.nextElement();
            try {
                s.close();
            }
            catch (DataException e) {
                this.log.error("Can't close datatarget: " + s.getName(), e);
            }
        }
    }

    private final void start() throws DataException {
        this.source.start();
        Enumeration en = this.output.elements();
        while (en.hasMoreElements()) {
            DataTarget s = (DataTarget)en.nextElement();
            s.start();
        }
    }

    private final void stop() throws DataException {
        this.source.stop();
        Enumeration en = this.output.elements();
        while (en.hasMoreElements()) {
            DataTarget s = (DataTarget)en.nextElement();
            s.stop();
        }
    }

    private final void transform(Hashtable h, Templates template) throws Exception {
        Element root = df.createElement("document");
        Document doc = df.createDocument(root);
        XMLUtil.toXML(root, h);
        Transformer t = template.newTransformer();
        DocumentSource ds = new DocumentSource(doc);
        InputSource is = ds.getInputSource();
        SAXContentHandler ch = new SAXContentHandler(df);
        DocumentResult dr = new DocumentResult(ch);
        t.transform(new SAXSource(is), (Result)dr);
        Document doc2 = dr.getDocument();
        root = doc2.getRootElement();
        Iterator i = root.elementIterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            if (!e.isTextOnly()) {
                StringWriter out = new StringWriter(1024);
                HTMLWriter hw = new HTMLWriter((Writer)out, format);
                Iterator i2 = e.nodeIterator();
                while (i2.hasNext()) {
                    Node n = (Node)i2.next();
                    hw.write(n);
                }
                h.put(e.getName(), out.toString());
                continue;
            }
            h.put(e.getName(), e.getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public int run() throws DataException {
        int i = 0;
        try {
            Hashtable h = new Hashtable();
            try {
                this.source.open();
                this.openTargets();
                if (this.listener != null) {
                    this.listener.doPreTransformation(this);
                }
                this.start();
                int count = 0;
                int skipped = 0;
                while (this.max == -1 || count < this.max) {
                    int cont;
                    h.clear();
                    try {
                        if (!this.source.getRecord(h)) {
                            break;
                        }
                    }
                    catch (Exception e) {
                        if (this.error_listener != null && (cont = this.error_listener.onSourceError(this, this.source, h, e)) != 0) continue;
                        throw e;
                    }
                    if (i % 500 == 0) {
                        Thread.yield();
                    }
                    if (this.start > 0 && ++i < this.start) {
                        h.clear();
                        continue;
                    }
                    try {
                        if (this.delay != -1L) {
                            Thread.sleep(this.delay);
                        } else if (count % 1000 == 0) {
                            Thread.sleep(10L);
                        }
                    }
                    catch (InterruptedException e) {
                        this.log.info(this.source.getName() + ":Stopped by user " + count + " processed (Skipped " + skipped + ")");
                        cont = i;
                        this.closeAll();
                        return cont;
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        this.log.info(this.source.getName() + ":Stopped by user " + count + " processed (Skipped " + skipped + ")");
                        int e = i;
                        return e;
                    }
                    if (this.listener != null) {
                        this.listener.doPostOpen(this.source, h);
                    }
                    ++count;
                    Enumeration e = this.output.elements();
                    Enumeration ex = this.xsl_output.elements();
                    while (e.hasMoreElements()) {
                        DataTarget out = (DataTarget)e.nextElement();
                        Templates template = (Templates)ex.nextElement();
                        Criteria c = out.getCriteria();
                        if (c == null || c.isCriteria(out, h)) {
                            if (this.interval > 0 && i % this.interval == 0) {
                                this.log.info(this.name + ":Processing: " + i);
                            }
                            if (this.listener != null) {
                                this.listener.doPreSave(this.source, out, h);
                            }
                            if (out.getMethod() != 4) {
                                if (template != null) {
                                    this.transform(h, template);
                                }
                                try {
                                    out.putRecord(h);
                                }
                                catch (Exception ex2) {
                                    boolean cont2;
                                    if (this.error_listener != null && (cont2 = this.error_listener.onTargetError(this, this.source, out, h, ex2))) continue;
                                    throw ex2;
                                }
                                if (this.listener != null) {
                                    this.listener.doPostSave(this.source, out, h);
                                }
                            }
                            this.source.backTagRecord(h);
                            continue;
                        }
                        this.log.debug(this.name + ":Skipping: " + i);
                        ++skipped;
                    }
                }
                this.log.info(this.source.getName() + ":Processed total " + count + " (Skipped " + skipped + ")");
                if (this.listener != null) {
                    this.listener.doPostTransformation(this);
                }
                this.stop();
                int n = i;
                return n;
            }
            finally {
                this.closeAll();
            }
        }
        catch (DataException e) {
            e.setPosition(i);
            throw e;
        }
        catch (Exception e) {
            throw new DataException(e, i);
        }
    }
}

