/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.datapump;

import is.hugvit.datapump.DataException;
import is.hugvit.datapump.Field;
import is.hugvit.datapump.SQLDataSource;
import is.hugvit.sql.Null;
import is.hugvit.sql.SQLUtil;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SQLDataTarget
extends SQLDataSource {
    private PreparedStatement stmt_lookup;
    private PreparedStatement stmt_insert;
    private PreparedStatement stmt_update;

    @Override
    public void open() throws DataException {
        super.open();
        try {
            int count;
            if (this.method == 3 || this.method == 4) {
                count = this.getCount();
                if (count > 0) {
                    String sql = "delete from " + this.param.getProperty("table");
                    this.log.debug("sql=" + sql);
                    Statement stmt = this.conn.createStatement();
                    stmt.executeUpdate(sql);
                    stmt.close();
                }
            } else if (this.method == 2 && (count = this.getCount()) > 0) {
                String s = "update " + this.param.getProperty("table") + " set " + this.synch + "=0";
                this.log.debug("Resetting synch in table " + this.param.getProperty("table"));
                this.log.debug("sql=" + s);
                Statement stmt = this.conn.createStatement();
                stmt.executeUpdate(s);
                stmt.close();
            }
            if (this.keys.size() > 0) {
                String s = this.getLookupSQL();
                this.log.debug("sql:lookup=" + s);
                this.stmt_lookup = this.conn.prepareStatement(s);
            }
            String s = this.getInsertSQL();
            this.log.debug("sql:insert=" + s);
            this.stmt_insert = this.conn.prepareStatement(s);
            s = this.getUpdateSQL();
            this.log.debug("sql:update=" + s);
            this.stmt_update = this.conn.prepareStatement(s);
        }
        catch (Exception e) {
            throw new DataException(e);
        }
    }

    private final String getLookupSQL() {
        String key1 = (String)this.keys.firstElement();
        StringBuffer s = new StringBuffer(128);
        s.append("select " + key1 + " from " + this.param.getProperty("table") + " where ");
        for (int i = 0; i < this.keys.size(); ++i) {
            String key = (String)this.keys.elementAt(i);
            if (i != 0) {
                s.append(" and ");
            }
            s.append(key + "=?");
        }
        return s.toString();
    }

    private final String getInsertSQL() {
        StringBuffer s = new StringBuffer(128);
        s.append("insert into ");
        s.append(this.param.getProperty("table"));
        s.append(" (");
        Enumeration e = this.fields.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            Field f = (Field)e.nextElement();
            if (i != 0) {
                s.append(",");
            }
            s.append(f.getName());
            ++i;
        }
        if (this.method == 2) {
            s.append("," + this.synch);
        }
        s.append(") values (");
        for (i = 0; i < this.fields.size(); ++i) {
            if (i != 0) {
                s.append(",");
            }
            s.append("?");
        }
        if (this.method == 2) {
            s.append(",1");
        }
        s.append(")");
        return s.toString();
    }

    private final String getUpdateSQL() {
        StringBuffer s = new StringBuffer(128);
        s.append("update " + this.param.getProperty("table") + " set ");
        int i = 0;
        Enumeration e = this.fields.elements();
        while (e.hasMoreElements()) {
            Field f = (Field)e.nextElement();
            String name = f.getName();
            if (this.keys.contains(name)) continue;
            if (i != 0) {
                s.append(",");
            }
            s.append(name + "=?");
            ++i;
        }
        if (this.method == 2) {
            s.append("," + this.synch + "=1");
        }
        s.append(" where ");
        for (i = 0; i < this.keys.size(); ++i) {
            String key = (String)this.keys.elementAt(i);
            if (i != 0) {
                s.append(" and ");
            }
            s.append(key + "=?");
        }
        return s.toString();
    }

    @Override
    public void stop() throws DataException {
        try {
            if (this.conn != null && this.method == 2) {
                StringBuffer s = new StringBuffer(128);
                s.append("delete from " + this.param.getProperty("table") + " where ");
                s.append(this.synch);
                s.append("=0");
                this.log.debug("Deleting out of synch records");
                this.log.debug("sql=" + s.toString());
                Statement stmt = this.conn.createStatement();
                stmt.executeUpdate(s.toString());
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new DataException(e);
        }
    }

    @Override
    public void close() throws DataException {
        try {
            if (this.stmt_lookup != null) {
                this.stmt_lookup.close();
            }
            if (this.stmt_insert != null) {
                this.stmt_insert.close();
            }
            if (this.stmt_update != null) {
                this.stmt_update.close();
            }
            super.close();
        }
        catch (SQLException e) {
            throw new DataException(e);
        }
    }

    private final int getCount() throws SQLException {
        int count = 0;
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery("select count(*) from " + this.param.getProperty("table"));
        if (rs.next()) {
            count = rs.getInt(1);
        }
        rs.close();
        stmt.close();
        return count;
    }

    private final boolean recordExists(Vector k) throws SQLException, IOException {
        this.log.debug("lookup:values=" + k);
        SQLUtil.setStatement(this.stmt_lookup, k, 1);
        ResultSet rs = this.stmt_lookup.executeQuery();
        boolean result = rs.next();
        rs.close();
        return result;
    }

    private final Vector getValues(Hashtable h, boolean includekeys) throws DataException {
        Vector<Object> v = new Vector<Object>();
        Enumeration e = this.fields.elements();
        while (e.hasMoreElements()) {
            Field f = (Field)e.nextElement();
            String name = f.getName();
            if (!includekeys && this.keys.contains(name)) continue;
            Object obj = this.getValue(h, f);
            if (obj == null) {
                obj = new Null(f.getSQLType());
            }
            v.addElement(obj);
        }
        return v;
    }

    private final void createRecord(Hashtable h) throws DataException {
        try {
            Vector k = this.getValues(h, true);
            this.log.debug("insert:values=" + k);
            SQLUtil.setStatement(this.stmt_insert, k, 1);
            this.stmt_insert.executeUpdate();
        }
        catch (SQLException e) {
            throw new DataException(e);
        }
        catch (IOException e) {
            throw new DataException(e);
        }
    }

    private final void updateRecord(Hashtable h, int method) throws DataException {
        try {
            Vector k = this.getKeyValues(h);
            if (this.recordExists(k)) {
                if (method != 6) {
                    Vector v = this.getValues(h, false);
                    this.log.debug("update:values=" + v);
                    this.log.debug("update:keys=" + k);
                    SQLUtil.setStatement(this.stmt_update, v, 1);
                    SQLUtil.setStatement(this.stmt_update, k, v.size() + 1);
                    this.stmt_update.executeUpdate();
                }
            } else if (method != 5) {
                this.createRecord(h);
            }
        }
        catch (SQLException e) {
            throw new DataException(e);
        }
        catch (IOException e) {
            throw new DataException(e);
        }
    }

    @Override
    public void putRecord(Hashtable h) throws DataException {
        if (this.method == 1 || this.method == 2 || this.method == 5 || this.method == 6) {
            this.updateRecord(h, this.method);
        } else {
            this.createRecord(h);
        }
    }
}

