/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.datapump;

import is.hugvit.datapump.ConstantField;
import is.hugvit.datapump.DataException;
import is.hugvit.datapump.DataTargetImpl;
import is.hugvit.datapump.Field;
import is.hugvit.util.Util;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class SQLDataSource
extends DataTargetImpl {
    private Driver driver;
    protected Connection conn;
    private PreparedStatement pstmt;
    private ResultSet rs;

    @Override
    public void open() throws DataException {
        super.open();
        try {
            this.driver = (Driver)Class.forName(this.param.getProperty("driver")).newInstance();
            this.conn = this.createConnection();
        }
        catch (Exception e) {
            throw new DataException(e);
        }
    }

    @Override
    public void close() throws DataException {
        try {
            if (this.pstmt != null) {
                this.pstmt.close();
            }
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException e) {
            throw new DataException(e);
        }
    }

    private final String getSelectSQL() {
        String table = this.param.getProperty("table");
        String where = this.param.getProperty("where");
        String sql_rest = this.param.getProperty("sql");
        StringBuffer s = new StringBuffer(128);
        s.append("select ");
        Enumeration e = this.fields.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            Field f = (Field)e.nextElement();
            if (f instanceof ConstantField) continue;
            if (i != 0) {
                s.append(",");
            }
            s.append(f.getName());
            ++i;
        }
        s.append(" from ");
        s.append(table);
        if (where != null) {
            s.append(" where ");
            s.append(where);
        }
        if (sql_rest != null) {
            s.append(" " + sql_rest);
        }
        return s.toString();
    }

    @Override
    public boolean getRecord(Hashtable h) throws DataException {
        try {
            if (this.rs == null) {
                String sql = this.getSelectSQL();
                this.log.debug("sql=" + sql);
                this.pstmt = this.conn.prepareStatement(sql);
                this.rs = this.pstmt.executeQuery();
            }
            if (!this.rs.next()) {
                this.rs.close();
                return false;
            }
            Enumeration e = this.fields.elements();
            int i = 1;
            while (e.hasMoreElements()) {
                String s;
                Object obj;
                Field f = (Field)e.nextElement();
                if (f instanceof ConstantField) {
                    obj = ((ConstantField)f).getValue();
                } else {
                    obj = f.getType() == 0 ? this.rs.getString(i) : (f.getType() == 1 ? new Integer(this.rs.getInt(i)) : (f.getType() == 2 ? new Double(this.rs.getDouble(i)) : (f.getType() == 3 ? this.rs.getDate(i) : (f.getType() == 9 ? this.rs.getTime(i) : (f.getType() == 10 ? this.rs.getTimestamp(i) : (f.getType() == 7 ? this.rs.getBinaryStream(i) : this.rs.getObject(i)))))));
                    ++i;
                }
                if (obj == null) continue;
                String alias = f.getAlias();
                if (alias == null) {
                    alias = f.getName();
                }
                if (obj instanceof String && (s = (String)(obj = Util.replace((String)obj, "\u017e", "\u00fe"))).equals("\u0002")) {
                    obj = null;
                }
                if (obj == null) continue;
                h.put(alias, obj);
            }
            return true;
        }
        catch (SQLException e) {
            throw new DataException(e);
        }
    }

    public final Connection getConnection() {
        return this.conn;
    }

    public final Connection createConnection() throws SQLException {
        String connstring = this.param.getProperty("connection");
        String user = this.param.getProperty("user");
        Properties up = new Properties();
        if (user != null) {
            up.put("user", user);
            String password = this.param.getProperty("password");
            if (password == null) {
                password = "";
            }
            up.put("password", password);
        }
        return this.driver.connect(connstring, up);
    }

    public final String getTable() {
        return this.param.getProperty("table");
    }
}

