/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.datapump;

import is.hugvit.datapump.DataException;
import is.hugvit.datapump.Field;
import is.hugvit.datapump.GoProExchangeDataSource;
import is.hugvit.net.URLEncoder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class GoProExchangeDataTarget
extends GoProExchangeDataSource {
    private final String createXML(Hashtable h) throws DataException {
        System.out.println("in createXML");
        StringWriter out = null;
        try {
            out = new StringWriter();
            String form = this.getParameter("form");
            DocumentFactory df = new DocumentFactory();
            Element root = df.createElement("document");
            Document doc = df.createDocument(root);
            root.addElement("form").addText(form);
            root.addAttribute("description", form + " N1");
            Element items = root.addElement("items");
            Enumeration e = this.fields.elements();
            while (e.hasMoreElements()) {
                Field f = (Field)e.nextElement();
                Object obj = this.getValue(h, f);
                String s = "";
                if (obj instanceof String) {
                    s = (String)obj;
                }
                Element el = items.addElement("item").addText(s);
                el.addAttribute("name", f.getName());
                el.addAttribute("type", "TEXT");
            }
            OutputFormat format = new OutputFormat("", true, "ISO-8859-1");
            XMLWriter xw = new XMLWriter((Writer)out, format);
            xw.write(doc);
            this.log.debug("done generating xml");
        }
        catch (IOException e) {
            throw new DataException(e);
        }
        return out.toString();
    }

    @Override
    public void putRecord(Hashtable h) throws DataException {
        String xml = this.createXML(h);
        try {
            String sUrl = this.getParameter("url");
            this.log.debug("Sending XML to " + sUrl);
            this.log.debug(xml);
            HttpURLConnection conn = (HttpURLConnection)new URL(sUrl).openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream()));
            out.write(xml);
            xml = URLEncoder.encode(xml);
            ((Writer)out).flush();
            ((Writer)out).close();
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            ((Reader)in).close();
            int resp_code = conn.getResponseCode();
            String resp_msg = conn.getResponseMessage();
            String response = resp_code + " " + resp_msg;
            this.log.debug("Response " + response);
            conn.disconnect();
        }
        catch (Exception e) {
            this.log.debug("ERROR in sending XML to ASP web site ");
            throw new DataException(e);
        }
    }
}

