/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.datapump;

import java.io.InputStream;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;

public class Field {
    public static final int STRING = 0;
    public static final int INTEGER = 1;
    public static final int DOUBLE = 2;
    public static final int DATE = 3;
    public static final int VECTOR = 4;
    public static final int READERS = 5;
    public static final int AUTHORS = 6;
    public static final int INPUTSTREAM = 7;
    public static final int ITEM = 8;
    public static final int TIME = 9;
    public static final int TIMESTAMP = 10;
    private String name;
    private int type = 0;
    private String alias;
    private Properties p;

    public Field(String name, String alias, int type) {
        this.name = name;
        this.alias = alias;
        this.type = type;
    }

    public Field(String name, String alias) {
        this.name = name;
        this.alias = alias;
    }

    public Field(String name, String alias, Properties p) {
        this.name = name;
        this.alias = alias;
        this.p = p;
    }

    public Field(String name, String alias, int type, Properties p) {
        this.name = name;
        this.alias = alias;
        this.type = type;
        this.p = p;
    }

    public Field(String name, int type, Properties p) {
        this.name = name;
        this.type = type;
        this.p = p;
    }

    public Field(String name, Properties p) {
        this.name = name;
        this.p = p;
    }

    public Field(String name, int type) {
        this.name = name;
        this.type = type;
    }

    public Field(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getAliasOrName() {
        return this.alias == null ? this.name : this.alias;
    }

    public int getType() {
        return this.type;
    }

    public Properties getProperties() {
        return this.p;
    }

    public String getProperty(String name) {
        return this.p.getProperty(name);
    }

    public int getPropertyInt(String name) {
        String s = this.p.getProperty(name);
        return s == null ? 0 : Integer.parseInt(s);
    }

    public static int getType(Object value) {
        if (value instanceof Integer) {
            return 1;
        }
        if (value instanceof Time) {
            return 9;
        }
        if (value instanceof Timestamp) {
            return 10;
        }
        if (value instanceof Date) {
            return 3;
        }
        if (value instanceof Vector) {
            return 4;
        }
        if (value instanceof Double) {
            return 2;
        }
        if (value instanceof InputStream) {
            return 7;
        }
        return 0;
    }

    public int getSQLType() {
        if (this.type == 1) {
            return 4;
        }
        if (this.type == 3) {
            return 91;
        }
        if (this.type == 9) {
            return 92;
        }
        if (this.type == 10) {
            return 93;
        }
        if (this.type == 2) {
            return 8;
        }
        if (this.type == 7) {
            return -4;
        }
        return 12;
    }
}

